/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.mapper;

import de.maggicraft.mcommons.util.MTuple;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class CreateUnifiedStateName {
    private static final Function<String, String> REMOVE_WATER_LOGGED = pS -> pS.replace("waterlogged=true", "").replace("waterlogged=false", "");
    private static final Function<String, String> REMOVE_ARTIFACTS = pS -> pS.replace("[]", "").replace(",,", ",").replace(",]", "]");
    private static final Function<String, String> REMOVE_TAG = pS -> pS.replace("Block{", "").replace("}", "");
    private static final Function<String, String> REMOVE_BRACKET = pS -> pS.replace("]", "");
    private static final Function<String, MTuple<String, String>> SPLIT_PARTS = pS -> {
        String[] parts = pS.split("\\[");
        if (parts.length == 2) {
            return new MTuple<String, String>(parts[0], parts[1]);
        }
        return new MTuple<String, String>(parts[0], "");
    };
    private static final Function<String, String> REMOVE = CreateUnifiedStateName.combineF(REMOVE_WATER_LOGGED, REMOVE_ARTIFACTS, REMOVE_TAG, REMOVE_BRACKET);
    private static final Function<String, String[]> SPLIT = pS -> pS.split(",");
    private static final Function<String[], String[]> ORDER = pArr -> {
        Arrays.sort(pArr, Comparator.naturalOrder());
        return pArr;
    };
    private static final Function<String[], String> COMBINE = pArr -> {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ((String[])pArr).length; ++i) {
            sb.append(pArr[i]);
            if (i == ((String[])pArr).length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    };

    private CreateUnifiedStateName() {
    }

    @NotNull
    public static String unify(@NotNull String pRawName) {
        MTuple<String, String> tuple = SPLIT_PARTS.apply(REMOVE.apply(pRawName));
        String combined = COMBINE.apply(ORDER.apply(SPLIT.apply(tuple.getB())));
        return tuple.getA() + '[' + combined + ']';
    }

    @SafeVarargs
    private static <T> Function<T, T> combineF(Function<T, T> ... pFuncs) {
        return Arrays.stream(pFuncs).reduce(Function.identity(), Function::andThen);
    }
}

