/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.mapper;

import org.jetbrains.annotations.NotNull;

public final class IdMeta {
    private final int mBlockId;
    private final int mMeta;

    public IdMeta(@NotNull String pBlockIdMeta) {
        String[] parts = pBlockIdMeta.split(":");
        this.mBlockId = Integer.parseInt(parts[0]);
        this.mMeta = Integer.parseInt(parts[1]);
        this.checkBounds();
    }

    public IdMeta(int pBlockId, int pMeta) {
        this.mBlockId = pBlockId;
        this.mMeta = pMeta;
        this.checkBounds();
    }

    private void checkBounds() {
        if (this.mBlockId < 0 || this.mBlockId > 255) {
            throw new IllegalArgumentException("blockID \"" + this.mBlockId + "\" out of bounds");
        }
        if (this.mMeta < 0 || this.mMeta > 16) {
            throw new IllegalArgumentException("meta \"" + this.mMeta + "\" out of bounds");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IdMeta{");
        sb.append("mBlockId=").append(this.mBlockId);
        sb.append(", mMeta=").append(this.mMeta);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        IdMeta idMeta = (IdMeta)pO;
        return this.mBlockId == idMeta.mBlockId && this.mMeta == idMeta.mMeta;
    }

    public int hashCode() {
        return this.mBlockId << 4 | this.mMeta;
    }

    public int getBlockId() {
        return this.mBlockId;
    }

    public int getMeta() {
        return this.mMeta;
    }
}

