/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.mapper;

import de.maggicraft.ism.ISMMain;
import de.maggicraft.ism.mapper.IPlaceBlockTable;
import de.maggicraft.ism.mapper.IStateTranslator;
import net.minecraft.block.BlockState;
import org.jetbrains.annotations.NotNull;

public class PlaceBlockTable
implements IPlaceBlockTable {
    public static final PlaceBlockTable EMPTY_TABLE = new PlaceBlockTable(0);
    @NotNull
    private final BlockState[] mStates;

    public PlaceBlockTable(int pSize) {
        this.mStates = new BlockState[pSize];
    }

    public PlaceBlockTable(@NotNull IStateTranslator pTranslator) {
        BlockState[] blockStates = ISMMain.getBlockStateMapper().getMapping();
        this.mStates = new BlockState[blockStates.length];
        for (int i = 0; i < blockStates.length; ++i) {
            this.mStates[i] = pTranslator.translate(blockStates[i]);
        }
    }

    @Override
    @NotNull
    public BlockState get(int pBlockID, int pMeta) {
        return this.mStates[pBlockID << 4 | pMeta];
    }
}

