/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.placed;

import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.placed.EPlacedSourceType;
import de.maggicraft.ism.placed.EPlacedType;
import de.maggicraft.ism.placed.IPlaced;
import de.maggicraft.ism.placed.IPlacedWorld;
import de.maggicraft.ism.str.IReadableStructure;
import de.maggicraft.ism.world.util.Dim;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IFilterInput;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.ism.world.util.Pos;
import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mioutil.json.IStorable;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Date;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public class Placed
implements IPlaced,
IStorable {
    @NotNull
    private static final String EMPTY = "";
    @NotNull
    private static final String FOLDER_BACK_UP = "backups" + CCon.SEP;
    @NotNull
    protected final EPlacedSourceType mSource;
    @NotNull
    protected final String mStructureName;
    @NotNull
    protected final IDim mDim;
    protected final int mDimX;
    protected final int mDimZ;
    @NotNull
    private final IPos mCorner;
    @NotNull
    private final IPos mCenter;
    @NotNull
    private final EPlacedType mType;
    @NotNull
    private final Date mDatePlaced;
    @NotNull
    private final IPlacedWorld mPlacedWorld;
    private final int mRot;
    private final int mBlocks;
    protected String mPathBackUp;

    protected Placed(@NotNull IPlacedWorld pPlacedWorld, @NotNull EPlacedType pType, @NotNull EPlacedSourceType pSource, @NotNull String pStructureName, @NotNull IReadableStructure pStr, @NotNull IPos pCorner, int pRot, int pDimX, int pDimZ, @NotNull Date pDate) {
        this.mPlacedWorld = pPlacedWorld;
        this.mType = pType;
        this.mSource = pSource;
        this.mStructureName = pStructureName;
        this.mBlocks = pStr.getBlocks();
        this.mDim = pStr.getDim();
        this.mCorner = pCorner;
        this.mRot = pRot;
        this.mDimX = pDimX;
        this.mDimZ = pDimZ;
        this.mCenter = this.mCorner.center(new Dim(pDimX, pStr.getDim().getY(), pDimZ));
        this.mPathBackUp = this.createBackUpPath();
        this.mDatePlaced = pDate;
    }

    protected Placed(@NotNull IPlacedWorld pPlacedWorld, @NotNull EPlacedType pType, @NotNull EPlacedSourceType pSource, @NotNull String pStructureName, @NotNull IReadableStructure pStr, @NotNull IPos pCorner, int pRot, int pDimX, int pDimZ) {
        this.mPlacedWorld = pPlacedWorld;
        this.mType = pType;
        this.mSource = pSource;
        this.mStructureName = pStructureName;
        this.mBlocks = pStr.getBlocks();
        this.mDim = pStr.getDim();
        this.mCorner = pCorner;
        this.mRot = pRot;
        this.mDimX = pDimX;
        this.mDimZ = pDimZ;
        this.mCenter = this.mCorner.center(new Dim(pDimX, pStr.getDim().getY(), pDimZ));
        this.mPathBackUp = this.createBackUpPath();
        this.mDatePlaced = new Date();
    }

    protected Placed(@NotNull IPlacedWorld pPlacedWorld, @NotNull JSONObject pJSON) {
        this.mPlacedWorld = pPlacedWorld;
        this.mCorner = new Pos(ReadableUtil.getLong(pJSON, EKeys.CORNER));
        this.mDatePlaced = ReadableUtil.getDate(pJSON, EKeys.DATE_PLACED);
        this.mPathBackUp = ReadableUtil.getString(pJSON, EKeys.PATH_BACK_UP);
        this.mStructureName = ReadableUtil.getString(pJSON, EKeys.STRUCTURE_NAME);
        this.mRot = ReadableUtil.getInt(pJSON, EKeys.ROT);
        this.mBlocks = ReadableUtil.getInt(pJSON, EKeys.BLOCKS);
        this.mDimX = ReadableUtil.getInt(pJSON, EKeys.DIM_X);
        this.mDimZ = ReadableUtil.getInt(pJSON, EKeys.DIM_Z);
        this.mDim = new Dim(ReadableUtil.getJSON(pJSON, EKeys.DIM));
        this.mSource = EPlacedSourceType.getType(ReadableUtil.getInt(pJSON, EKeys.SOURCE));
        this.mType = EPlacedType.getType(ReadableUtil.getInt(pJSON, EKeys.TYPE));
        this.mCenter = this.mCorner.center(new Dim(this.mDimX, this.mDim.getY(), this.mDimZ));
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        StorableUtil.put(json, (IUniqueID<String>)EKeys.PATH_BACK_UP, this.mPathBackUp);
        StorableUtil.put(json, (IUniqueID<String>)EKeys.STRUCTURE_NAME, this.mStructureName);
        StorableUtil.put(json, (IUniqueID<String>)EKeys.CORNER, this.mCorner.toLong());
        StorableUtil.put(json, (IUniqueID<String>)EKeys.DATE_PLACED, this.mDatePlaced);
        StorableUtil.put(json, (IUniqueID<String>)EKeys.ROT, this.mRot);
        StorableUtil.put(json, (IUniqueID<String>)EKeys.BLOCKS, this.mBlocks);
        StorableUtil.put(json, (IUniqueID<String>)EKeys.DIM_X, this.mDimX);
        StorableUtil.put(json, (IUniqueID<String>)EKeys.DIM_Z, this.mDimZ);
        StorableUtil.put(json, (IUniqueID<String>)EKeys.DIM, this.mDim.toJSON());
        StorableUtil.put(json, (IUniqueID<String>)EKeys.SOURCE, this.mSource.getUID());
        StorableUtil.put(json, (IUniqueID<String>)EKeys.TYPE, this.mType.getUID());
        return json;
    }

    @NotNull
    private String createBackUpPath() {
        String pathBackUp;
        int i = 0;
        String path = new File(this.mPlacedWorld.getWorldFolder().getAbsolutePath(), FOLDER_BACK_UP).getAbsolutePath();
        do {
            pathBackUp = MFilter.validateFilename(this.mStructureName + (i == 0 ? EMPTY : "_" + i));
            ++i;
        } while (new File(path, pathBackUp + ".schematic").exists());
        return pathBackUp;
    }

    protected Optional<File> fileBackUp() {
        if (this.mPathBackUp.equals(EMPTY)) {
            return Optional.empty();
        }
        File file = new File(this.mPlacedWorld.getWorldFolder(), FOLDER_BACK_UP + this.mPathBackUp + ".schematic");
        return Optional.of(file);
    }

    @Override
    public void reposition(@NotNull String pDim, @NotNull IFilterInput pInput, @NotNull IPos pCorner, int pRot, int pDimX, int pDimZ, boolean pFlatten) {
        new Thread(() -> {}).start();
    }

    @Override
    public void remove() {
        new Thread(() -> {}).start();
    }

    @Override
    public void deleteBackUp() {
        Optional<File> optFile = this.fileBackUp();
        if (optFile.isPresent()) {
            try {
                Files.deleteIfExists(optFile.get().toPath());
            }
            catch (IOException pE) {
                ISMContainer.getLogger().log(pE);
            }
        }
        if (!this.mPathBackUp.equals(EMPTY)) {
            this.mPathBackUp = EMPTY;
            this.mPlacedWorld.store();
        }
    }

    @NotNull
    public IPlacedWorld getPlacedWorld() {
        return this.mPlacedWorld;
    }

    @Override
    public boolean isChangeable() {
        Optional<File> optFile = this.fileBackUp();
        return optFile.isPresent() && optFile.get().exists();
    }

    @Override
    @NotNull
    public String getWorldName() {
        return this.mPlacedWorld.getWorldFolder().getName();
    }

    @Override
    @NotNull
    public EPlacedType getType() {
        return this.mType;
    }

    @Override
    @NotNull
    public Date getDatePlaced() {
        return this.mDatePlaced;
    }

    @Override
    @NotNull
    public EPlacedSourceType getSource() {
        return this.mSource;
    }

    @Override
    @NotNull
    public String getStructureName() {
        return this.mStructureName;
    }

    @Override
    @NotNull
    public IPos getCorner() {
        return this.mCorner;
    }

    @Override
    @NotNull
    public IPos getCenter() {
        return this.mCenter;
    }

    @Override
    public int getBlocks() {
        return this.mBlocks;
    }

    @Override
    public int getRot() {
        return this.mRot;
    }

    @Override
    public int getDimX() {
        return this.mDimX;
    }

    @Override
    public int getDimZ() {
        return this.mDimZ;
    }

    @Override
    @NotNull
    public IDim getDim() {
        return this.mDim;
    }

    public static enum EKeys implements IUID
    {
        PATH_BACK_UP("pth"),
        STRUCTURE_NAME("nme"),
        CORNER("pos"),
        DATE_PLACED("tim"),
        ROT("rot"),
        BLOCKS("blk"),
        DIM_X("dix"),
        DIM_Z("diz"),
        DIM("dim"),
        SOURCE("src"),
        TYPE("typ"),
        VERSION("ver");

        private final String mUID;

        private EKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        public String getUID() {
            return this.mUID;
        }
    }
}

