/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.placed;

import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.placed.EPlacedSourceType;
import de.maggicraft.ism.placed.EPlacedType;
import de.maggicraft.ism.placed.IPlacedIntern;
import de.maggicraft.ism.placed.IPlacedWorld;
import de.maggicraft.ism.placed.Placed;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.IStorageCollection;
import de.maggicraft.ism.storage.IStorageProject;
import de.maggicraft.ism.storage.IStorageProjectBase;
import de.maggicraft.ism.storage.IStorageStructure;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.str.IReadableStructure;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public class PlacedIntern
extends Placed
implements IPlacedIntern {
    private final String mProjectURL;
    private final int mPID;

    public PlacedIntern(@NotNull IPlacedWorld pPlacedWorld, @NotNull EPlacedType pType, @NotNull String pName, IReadableStructure pStr, @NotNull IPos pCorner, int pRot, int pDimX, int pDimZ, IProject pProject, @NotNull Date pDate) {
        super(pPlacedWorld, pType, pProject.isCollection() ? EPlacedSourceType.SRC_COLLECTION : EPlacedSourceType.SRC_PROJECT, pName, pStr, pCorner, pRot, pDimX, pDimZ, pDate);
        this.mProjectURL = pProject.getURL();
        this.mPID = pProject.getPID();
    }

    public PlacedIntern(@NotNull IPlacedWorld pPlacedWorld, @NotNull EPlacedType pType, IStorageStructure pStr, @NotNull IPos pCorner, int pRot, int pDimX, int pDimZ) {
        super(pPlacedWorld, pType, pStr.getProject().isCollection() ? EPlacedSourceType.SRC_COLLECTION : EPlacedSourceType.SRC_PROJECT, pStr.getName(), pStr, pCorner, pRot, pDimX, pDimZ);
        this.mProjectURL = pStr.getProject().getURL();
        this.mPID = pStr.getProject().getPID();
    }

    public PlacedIntern(@NotNull IPlacedWorld pPlacedWorld, @NotNull JSONObject pJSON) throws StorageException {
        super(pPlacedWorld, pJSON);
        this.mProjectURL = ReadableUtil.getString(pJSON, EPlacedInternKeys.PROJECT_URL);
        this.mPID = MData.pidByURL(this.mProjectURL);
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        if (!super.equals(pO)) {
            return false;
        }
        PlacedIntern that = (PlacedIntern)pO;
        return this.mPID == that.mPID && this.mProjectURL.equals(that.mProjectURL);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mProjectURL, this.mPID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PlacedIntern{");
        sb.append("mProjectURL='").append(this.mProjectURL).append('\'');
        sb.append(", mPID=").append(this.mPID);
        sb.append(", mSource=").append(this.mSource);
        sb.append(", mStructureName='").append(this.mStructureName).append('\'');
        sb.append(", mDim=").append(this.mDim);
        sb.append(", mDimX=").append(this.mDimX);
        sb.append(", mDimZ=").append(this.mDimZ);
        sb.append(", mPathBackUp='").append(this.mPathBackUp).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @NotNull
    public IStorageStructure placeableStructure() throws StorageException {
        IProject dataProject = MData.getProject(this.mPID);
        Optional<IStorageProjectBase> optionalProject = ISMContainer.getStorageManager().getProject(dataProject);
        IStorageProjectBase project = optionalProject.isPresent() ? optionalProject.get() : ISMContainer.getStorageManager().addProject(dataProject);
        if (project.isCollection()) {
            Optional<IStorageStructure> structure = ((IStorageCollection)project).getStructure(this.mStructureName);
            if (structure.isPresent()) {
                return structure.get();
            }
            String message = "pid: " + this.mPID + ", name: " + this.mStructureName;
            throw new StorageException(EStorageException.NO_MATCHING_STRUCTURE, message);
        }
        return ((IStorageProject)project).getStructure();
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        StorableUtil.put(json, (IUniqueID<String>)EPlacedInternKeys.PROJECT_URL, this.mProjectURL);
        return json;
    }

    @Override
    @NotNull
    public String getCreatorURL() {
        return MData.creatorURL(this.getCID());
    }

    @Override
    @NotNull
    public String getProjectURL() {
        return this.mProjectURL;
    }

    @Override
    public int getCID() {
        return MData.creatorUnitByProject(this.mPID);
    }

    @Override
    public int getPID() {
        return this.mPID;
    }

    public static enum EPlacedInternKeys implements IUID
    {
        PROJECT_URL("prj");

        private final String mUID;

        private EPlacedInternKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        public String getUID() {
            return this.mUID;
        }
    }
}

