/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.placed;

import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.placed.IPlaced;
import de.maggicraft.ism.placed.IPlacedManager;
import de.maggicraft.ism.placed.IPlacedWorld;
import de.maggicraft.ism.placed.PlacedUtil;
import de.maggicraft.ism.placed.PlacedWorld;
import de.maggicraft.ism.world.info.IWorldInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PlacedManager
implements IPlacedManager {
    private List<IPlacedWorld> mWorlds = new LinkedList<IPlacedWorld>();
    private File mFolder;

    public static boolean canInit(@NotNull File pWorldFolder) {
        return new File(pWorldFolder, "placed.json").exists();
    }

    public PlacedManager(@NotNull File pFolder) {
        this.mFolder = pFolder;
    }

    public PlacedManager() {
    }

    @Override
    public void initialize() {
        File[] worldFolders;
        if (this.mFolder == null) {
            this.mFolder = PlacedUtil.savesFolder();
        }
        if ((worldFolders = this.mFolder.listFiles(File::isDirectory)) != null) {
            this.mWorlds = new ArrayList<IPlacedWorld>(worldFolders.length + 3);
            for (File worldFolder : worldFolders) {
                if (!PlacedManager.canInit(worldFolder)) continue;
                try {
                    this.mWorlds.add(new PlacedWorld(worldFolder));
                }
                catch (FileNotFoundException pE) {
                    ISMContainer.getLogger().log(pE);
                }
            }
        }
    }

    private void recheckWorlds() {
        for (int i = 0; i < this.mWorlds.size(); ++i) {
            if (new File(this.mWorlds.get(i).getWorldFolder(), "placed.json").exists()) continue;
            this.mWorlds.remove(this.mWorlds.get(i));
            --i;
        }
    }

    @Override
    @NotNull
    public IPlacedWorld getPlacedWorld(@NotNull IWorldInfo pWorld) {
        this.recheckWorlds();
        for (IPlacedWorld world : this.mWorlds) {
            if (!world.isSameWorld(pWorld)) continue;
            return world;
        }
        PlacedWorld placedWorld = new PlacedWorld(pWorld.getFolder(), pWorld.getSeed());
        this.mWorlds.add(placedWorld);
        return placedWorld;
    }

    @Override
    @NotNull
    public List<IPlaced> allPlaced() {
        this.recheckWorlds();
        int size = 0;
        for (IPlacedWorld world : this.mWorlds) {
            size += world.getPlaceds().size();
        }
        ArrayList<IPlaced> placeds = new ArrayList<IPlaced>(size);
        for (IPlacedWorld world : this.mWorlds) {
            placeds.addAll(world.getPlaceds());
        }
        placeds.sort(PlacedUtil.SORT_DATE);
        return placeds;
    }

    public List<IPlacedWorld> getWorlds() {
        return this.mWorlds;
    }
}

