/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.placed;

import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.placed.EPlacedSortingType;
import de.maggicraft.ism.placed.EPlacedSourceType;
import de.maggicraft.ism.placed.IPlaced;
import de.maggicraft.ism.placed.IPlacedWorld;
import de.maggicraft.ism.placed.Placed;
import de.maggicraft.ism.placed.PlacedIntern;
import de.maggicraft.ism.placed.PlacedLocal;
import de.maggicraft.ism.placed.PlacedUtil;
import de.maggicraft.ism.storage.StorageCompoundException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.ism.world.info.IWorldInfo;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mioutil.io.MIOUtil;
import de.maggicraft.mioutil.json.IReadableManager;
import de.maggicraft.mioutil.json.IStorableManager;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class PlacedWorld
implements IPlacedWorld,
IStorableManager,
IReadableManager {
    @NotNull
    public static final String FILE_JSON = "placed.json";
    @NotNull
    private static final String VERSION = "1";
    @NotNull
    private final File mWorldFolder;
    @NotNull
    private final File mFileJSON;
    private List<IPlaced> mPlaceds;
    private long mSeed;

    public PlacedWorld(@NotNull File pWorldFolder, @NotNull File pFileJSON, long pSeed) {
        this.mWorldFolder = pWorldFolder;
        this.mFileJSON = pFileJSON;
        this.mSeed = pSeed;
        this.mPlaceds = new LinkedList<IPlaced>();
    }

    PlacedWorld(@NotNull File pWorldFolder, long pSeed) {
        this.mWorldFolder = pWorldFolder;
        this.mFileJSON = new File(this.mWorldFolder, FILE_JSON);
        this.mSeed = pSeed;
        this.mPlaceds = new LinkedList<IPlaced>();
        this.store();
    }

    public PlacedWorld(@NotNull File pWorldFolder) throws FileNotFoundException {
        this.mWorldFolder = pWorldFolder;
        this.mFileJSON = new File(this.mWorldFolder, FILE_JSON);
        if (!this.mFileJSON.exists()) {
            throw new FileNotFoundException();
        }
        this.read();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        PlacedWorld that = (PlacedWorld)pO;
        return this.mSeed == that.mSeed && this.mWorldFolder.equals(that.mWorldFolder) && this.mFileJSON.equals(that.mFileJSON) && Objects.equals(this.mPlaceds, that.mPlaceds);
    }

    public int hashCode() {
        return Objects.hash(this.mWorldFolder, this.mFileJSON, this.mSeed);
    }

    public String toString() {
        return "PlacedWorld{mWorldFolder=" + this.mWorldFolder + ", mFileJSON=" + this.mFileJSON + ", mPlaceds=" + this.mPlaceds + ", mSeed=" + this.mSeed + '}';
    }

    @Override
    public void store() {
        MIOUtil.write(this.mFileJSON, this.toJSON().toJSONString());
    }

    @Override
    public void addPlaced(@NotNull IPlaced pPlaced) {
        this.mPlaceds.add(pPlaced);
        this.store();
    }

    @Override
    public void storeHeader(@NotNull JSONObject pJSON) {
        StorableUtil.put(pJSON, (IUniqueID<String>)EPlacedWorldKeys.VERSION, VERSION);
        StorableUtil.put(pJSON, (IUniqueID<String>)EPlacedWorldKeys.SEED, this.mSeed);
    }

    @Override
    public void readHeader(@NotNull JSONObject pJSON) {
        this.mSeed = ReadableUtil.getLong(pJSON, EPlacedWorldKeys.SEED);
        String version = ReadableUtil.getString(pJSON, EPlacedWorldKeys.VERSION);
        if (!version.equals(VERSION)) {
            throw new IllegalArgumentException("version \"" + version + "\" not support");
        }
    }

    @Override
    public void readEntities(@NotNull JSONArray pJSONArray) {
        this.mPlaceds = new ArrayList<IPlaced>(pJSONArray.size() + 2);
        String message = "";
        StorageCompoundException exception = new StorageCompoundException(message);
        for (Object object : pJSONArray) {
            Placed placed;
            JSONObject json = (JSONObject)object;
            EPlacedSourceType type = EPlacedSourceType.getType(ReadableUtil.getInt(json, Placed.EKeys.SOURCE));
            if (type == EPlacedSourceType.SRC_LOCAL_STR) {
                placed = new PlacedLocal(this, json);
                this.mPlaceds.add(placed);
                continue;
            }
            if (type == EPlacedSourceType.SRC_PROJECT || type == EPlacedSourceType.SRC_COLLECTION) {
                try {
                    placed = new PlacedIntern(this, json);
                    this.mPlaceds.add(placed);
                }
                catch (StorageException pE) {
                    exception.addException(pE);
                }
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (exception.hasException()) {
            StorageUtil.handleStorageException(exception);
        }
    }

    @Override
    public boolean isSameWorld(@NotNull IWorldInfo pWorld) {
        return this.mWorldFolder.equals(pWorld.getFolder()) && this.mSeed == pWorld.getSeed();
    }

    @Override
    @NotNull
    public List<IPlaced> getPlaceds(@NotNull EPlacedSortingType pSorting, boolean pChangeableOnly) {
        ArrayList<IPlaced> list;
        Comparator<IPlaced> sorting;
        if (pSorting == EPlacedSortingType.SORT_DATE) {
            sorting = PlacedUtil.SORT_DATE;
        } else {
            IPos pos = ISMContainer.getWorldInfoManager().getPlayerPos();
            sorting = Comparator.comparingDouble(pPlaced -> pPlaced.getCorner().distance(pos));
        }
        if (pChangeableOnly) {
            list = new ArrayList(this.mPlaceds.size() / 2);
            for (IPlaced placed : this.mPlaceds) {
                if (!placed.isChangeable()) continue;
                list.add(placed);
            }
        } else {
            list = new ArrayList<IPlaced>(this.mPlaceds);
        }
        list.sort(sorting);
        return list;
    }

    @Override
    @NotNull
    public List<IPlaced> getPlaceds() {
        return this.mPlaceds;
    }

    @NotNull
    public List<IPlaced> getStorables() {
        return this.mPlaceds;
    }

    @Override
    @NotNull
    public File getWorldFolder() {
        return this.mWorldFolder;
    }

    @Override
    @NotNull
    public File getFile() {
        return this.mFileJSON;
    }

    public long getSeed() {
        return this.mSeed;
    }

    public static enum EPlacedWorldKeys implements IUID
    {
        VERSION("vers"),
        SEED("seed");

        private final String mUID;

        private EPlacedWorldKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

