/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.project_lists;

import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.project_lists.IProjectList;
import de.maggicraft.ism.results.ViewRes;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mioutil.compr.Compressed;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MDetailProjectListsView
extends MISMView<Integer> {
    private IProjectList mProjectList;

    @Override
    protected void displayState(Integer pMode) {
        MPanel header = ViewUtil.header(this, this.mProjectList.getTitle());
        IProject project = MData.getProject(this.mProjectList.getThumbPID());
        MButton thumbnail = new MButton((MMPos)MPos.pos(this, "[[<30>p,[[<76>p"), this.mProjectList.getThumbnail(false));
        thumbnail.addAction(pEvent -> ViewManager.displayDetail(project));
        thumbnail.setCursor(CSharedCon.CURSOR_HAND);
        this.displayInfo(thumbnail, project);
        ViewRes viewRes = new ViewRes(MPos.pos("V||<>m<>,[]<45>p", thumbnail), ViewManager.getScroll(), CSettings.SETTING_VIEW_STR_LIST, true){

            @Override
            public void actPrefDim(int pWidth, int pHeight) {
                MDetailProjectListsView.this.setDim(pWidth, pHeight + 340);
            }

            @Override
            public int getSort() {
                return 0;
            }
        };
        viewRes.buttonsResType(MPos.pos(header, "]]p<30>,]]p<5>"));
        viewRes.buttonsPage(MPos.pos(this, "||p,]]p<25>"));
        MFlowPanel panelFilter = new MFlowPanel(LPos.pos("V[[<>m<>,[]<>60", (IComp)thumbnail, 1), 61, MCon.colorFrame());
        ViewUtil.initFilter(this, 286, LPos.pos(panelFilter, "||<30>M850<30>,||<>30<>", 2), viewRes);
        Collection<Integer> projects = this.mProjectList.getPIDs();
        Compressed res = new Compressed(projects.size(), Integer.toBinaryString(MData.projectQuantity()).length());
        int i = 0;
        for (Integer fav : projects) {
            res.set(i, (int)fav);
            ++i;
        }
        viewRes.init(res, null);
        viewRes.actPref();
    }

    private void displayInfo(@NotNull IComp pPic, @NotNull IProject pProject) {
        ICreator creator = pProject.getCreator();
        MText tTitle = new MText(MPos.pos("[]p,[[<>p", pPic)).text(this.mProjectList.getDesc());
        MText tStats = new MText(MPos.pos("[]p,[]p", pPic, tTitle)).rep("projectListStats", CommonUtil.decMark(this.mProjectList.getStructureQuantity()), CommonUtil.decMark(this.mProjectList.getCreatorQuantity()), CommonUtil.decMark(this.mProjectList.getBlocksQuantity()));
        MText tDate = new MText(MPos.pos("[]p,[]p", pPic, tStats));
        String dateCreated = SharedUtil.DATE_FORMAT_TO.format(this.mProjectList.getCreated());
        if (!this.mProjectList.getUpdated().isPresent() || this.mProjectList.getUpdated().get().equals(this.mProjectList.getCreated())) {
            tDate.rep("projectListPubl", dateCreated);
        } else {
            tDate.rep("projectListUpdt", dateCreated, SharedUtil.DATE_FORMAT_TO.format(this.mProjectList.getUpdated().get()));
        }
        MText tCover = new MText(MPos.pos("[]p,]]p<>", pPic)).title("cv");
        String pos = "[]<>p<>,]]p<>";
        MText tStr = new MText(MPos.pos(pos, tCover, pPic)).text(pProject.getTitle());
        SharedUtil.addLink(tStr, () -> ViewManager.displayDetail(pProject));
        MText tBy = new MText(MPos.pos(pos, tStr, pPic)).text(" built by ");
        MText tCre = new MText(MPos.pos(pos, tBy, pPic)).text(creator.getName());
        SharedUtil.addLink(tCre, () -> ViewManager.displayDetail(creator));
        SharedUtil.moreStr(pProject, this, true, false);
    }

    public void setProjectList(IProjectList pProjectList) {
        this.mProjectList = pProjectList;
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        return EURI.PRE_STR_LISTS.toString() + (Object)((Object)EURI.VIEW) + this.mProjectList.getURI();
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_DETAIL_PROJECT_LIST;
    }

    @Override
    public int getMenuButton() {
        return 1;
    }

    @Override
    @NotNull
    public EFeature getFeature() {
        return EFeature.PROJECT_LISTS;
    }
}

