/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.project_lists;

import de.maggicraft.ism.project_lists.IGenre;
import de.maggicraft.ism.project_lists.IProjectList;
import de.maggicraft.ism.project_lists.MProjectList;
import de.maggicraft.ism.storage.StorageCompoundException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.ReadableUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MGenre
implements IGenre {
    @NotNull
    private final HashSet<IProjectList> mProjectLists;
    @NotNull
    private final String mName;
    @NotNull
    private final String mURI;
    private final int mIndex;

    public MGenre(@NotNull HashSet<IProjectList> pProjectLists, @NotNull String pName, @NotNull String pURI, int pIndex) {
        this.mProjectLists = pProjectLists;
        this.mName = pName;
        this.mURI = pURI;
        this.mIndex = pIndex;
    }

    public MGenre(@NotNull JSONObject pJSON) {
        this.mName = ReadableUtil.getString(pJSON, EGenreKeys.NAME);
        this.mURI = ReadableUtil.getString(pJSON, EGenreKeys.URI);
        this.mIndex = ReadableUtil.getInt(pJSON, EGenreKeys.INDEX);
        JSONArray array = ReadableUtil.getArray(pJSON, EGenreKeys.LISTS);
        this.mProjectLists = new HashSet(array.size());
        StorageCompoundException exception = new StorageCompoundException("project lists");
        for (Object json : array) {
            try {
                MProjectList projectList = new MProjectList(this.mURI, (JSONObject)json);
                this.mProjectLists.add(projectList);
            }
            catch (StorageException pE) {
                exception.addException(pE);
            }
        }
        if (exception.hasException()) {
            StorageUtil.handleStorageException(exception);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MGenre{");
        sb.append("mProjectLists=").append(this.mProjectLists);
        sb.append(", mName='").append(this.mName).append('\'');
        sb.append(", mURI='").append(this.mURI).append('\'');
        sb.append(", mIndex=").append(this.mIndex);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        MGenre mGenre = (MGenre)pO;
        return this.mIndex == mGenre.mIndex && this.mProjectLists.equals(mGenre.mProjectLists) && this.mName.equals(mGenre.mName) && this.mURI.equals(mGenre.mURI);
    }

    public int hashCode() {
        return Objects.hash(this.mProjectLists, this.mName, this.mURI, this.mIndex);
    }

    public void addProject(@NotNull IProjectList pProjectList) {
        this.mProjectLists.add(pProjectList);
    }

    @Override
    @NotNull
    public List<IProjectList> getProjectList() {
        ArrayList<IProjectList> list = new ArrayList<IProjectList>(this.mProjectLists);
        list.sort(Comparator.comparingInt(IProjectList::getIndex));
        return list;
    }

    @Override
    @NotNull
    public String getURI() {
        return this.mURI;
    }

    @Override
    @NotNull
    public String getName() {
        return this.mName;
    }

    @Override
    public int getIndex() {
        return this.mIndex;
    }

    public static enum EGenreKeys implements IUID
    {
        NAME("nme"),
        URI("uri"),
        INDEX("ind"),
        LISTS("lists");

        @NotNull
        private final String mUID;

        private EGenreKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

