/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.project_lists;

import de.maggicraft.ism.project_lists.IGenre;
import de.maggicraft.ism.project_lists.IGenreManager;
import de.maggicraft.ism.project_lists.MGenre;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.ReadableUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MGenreManager
implements IGenreManager {
    @NotNull
    private List<IGenre> mGenres;
    @NotNull
    private Date mUpdated;

    public MGenreManager(@NotNull JSONObject pJSON) {
        this.mUpdated = ReadableUtil.getDate(pJSON, EGenreManagerKeys.UPDATED);
        JSONArray jsonArray = (JSONArray)pJSON.get("entities");
        this.mGenres = new ArrayList<IGenre>(jsonArray.size());
        for (Object object : jsonArray) {
            this.mGenres.add(new MGenre((JSONObject)object));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MGenreManager{");
        sb.append("mGenres=").append(this.mGenres);
        sb.append(", mUpdated=").append(this.mUpdated);
        sb.append('}');
        return sb.toString();
    }

    @Override
    @NotNull
    public List<IGenre> getGenres() {
        return this.mGenres;
    }

    @Override
    @NotNull
    public Date getDate() {
        return this.mUpdated;
    }

    public static enum EGenreManagerKeys implements IUID
    {
        UPDATED("upt");

        @NotNull
        private final String mUID;

        private EGenreManagerKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

