/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.project_lists;

import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.project_lists.IListedProject;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.ReadableUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;

public class MListedProject
implements IListedProject {
    private final int mPID;

    public MListedProject(int pPID) {
        this.mPID = pPID;
    }

    public MListedProject(@NotNull JSONObject pJSON) throws StorageException {
        String projectURL = ReadableUtil.getString(pJSON, EListedProjectKeys.PROJECT_URL);
        this.mPID = MData.pidByURL(projectURL, ReadableUtil.getInt(pJSON, EListedProjectKeys.PID));
    }

    public String toString() {
        return "MListedProject{mPID=" + this.mPID + '}';
    }

    public boolean equals(@Nullable Object pObject) {
        if (this == pObject) {
            return true;
        }
        if (pObject == null || this.getClass() != pObject.getClass()) {
            return false;
        }
        MListedProject that = (MListedProject)pObject;
        return this.mPID == that.mPID;
    }

    public int hashCode() {
        return Objects.hash(this.mPID);
    }

    @Override
    public int getPID() {
        return this.mPID;
    }

    public static enum EListedProjectKeys implements IUID
    {
        PROJECT_URL("purl"),
        PID("pid");

        @NotNull
        private final String mUID;

        private EListedProjectKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

