/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.project_lists;

import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.project_lists.IListedThumbnail;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.ReadableUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;

public class MListedThumbnail
implements IListedThumbnail {
    @NotNull
    private final String mImgURL;
    private final int mPID;

    public MListedThumbnail(@NotNull String pImgURL, int pPID) {
        this.mImgURL = pImgURL;
        this.mPID = pPID;
    }

    public MListedThumbnail(@NotNull JSONObject pJSON) throws StorageException {
        this.mImgURL = ReadableUtil.getString(pJSON, MListedThumbnailKeys.IMAGE_URL);
        String strURL = ReadableUtil.getString(pJSON, MListedThumbnailKeys.PROJECT_URL);
        this.mPID = MData.pidByURL(strURL, ReadableUtil.getInt(pJSON, MListedThumbnailKeys.PID));
    }

    @NotNull
    public String toString() {
        return "MListedThumbnail{mImgURL='" + this.mImgURL + '\'' + ", PID=" + this.mPID + '}';
    }

    public boolean equals(@Nullable Object pObject) {
        if (this == pObject) {
            return true;
        }
        if (pObject == null || this.getClass() != pObject.getClass()) {
            return false;
        }
        MListedThumbnail mListedThumbnail = (MListedThumbnail)pObject;
        return this.mPID == mListedThumbnail.mPID && this.mImgURL.equals(mListedThumbnail.mImgURL);
    }

    public int hashCode() {
        return Objects.hash(this.mImgURL, this.mPID);
    }

    @Override
    @NotNull
    public String getImgURL() {
        return this.mImgURL;
    }

    @Override
    public int getPID() {
        return this.mPID;
    }

    public static enum MListedThumbnailKeys implements IUID
    {
        PROJECT_URL("purl"),
        IMAGE_URL("img"),
        PID("pid");

        @NotNull
        private final String mUID;

        private MListedThumbnailKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

