/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.project_lists;

import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.loader.ISMLoader;
import de.maggicraft.ism.project_lists.IListedProject;
import de.maggicraft.ism.project_lists.IListedThumbnail;
import de.maggicraft.ism.project_lists.IProjectList;
import de.maggicraft.ism.project_lists.MListedProject;
import de.maggicraft.ism.project_lists.MListedThumbnail;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageCompoundException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.ReadableUtil;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MProjectList
implements IProjectList {
    private static final int TIME_SPAN = 864000000;
    @NotNull
    private static final BufferedImage TAG_NEW;
    @NotNull
    private static final BufferedImage TAG_UPDATED;
    @NotNull
    private final String mURI;
    @NotNull
    private final HashSet<IListedThumbnail> mThumbs;
    @NotNull
    private final HashSet<IListedProject> mProjects;
    @NotNull
    private final Date mCreated;
    @NotNull
    private final Optional<Date> mUpdated;
    @NotNull
    private final String mTitle;
    @NotNull
    private final String mDesc;
    private final int mIndex;
    private ImageIcon mThumbnail;
    private int mThumbPID;
    private int mCreatorQuantity = -1;
    private int mBlocksQuantity = -1;

    public MProjectList(@NotNull String pURI, @NotNull HashSet<IListedThumbnail> pThumbs, @NotNull HashSet<IListedProject> pProjects, @NotNull Date pCreated, @NotNull Optional<Date> pUpdated, @NotNull String pTitle, @NotNull String pDesc, int pIndex) {
        this.mURI = pURI;
        this.mThumbs = pThumbs;
        this.mProjects = pProjects;
        this.mCreated = pCreated;
        this.mUpdated = pUpdated;
        this.mTitle = pTitle;
        this.mDesc = pDesc;
        this.mIndex = pIndex;
    }

    public MProjectList(@NotNull String pGenreUID, @NotNull JSONObject pJSON) throws StorageException {
        this.mCreated = ReadableUtil.getDate(pJSON, EStrListKeys.CREATED);
        if (ReadableUtil.contains(pJSON, EStrListKeys.UPDATED)) {
            Date update = ReadableUtil.getDate(pJSON, EStrListKeys.UPDATED);
            if (update.getTime() < this.mCreated.getTime()) {
                String message = "update " + update.getTime() + " before creation " + this.mCreated.getTime();
                throw new StorageException(EStorageException.PROGRAMMING_ERROR, message);
            }
            this.mUpdated = Optional.of(update);
        } else {
            this.mUpdated = Optional.empty();
        }
        this.mURI = pGenreUID + ReadableUtil.getString(pJSON, EStrListKeys.URI);
        this.mTitle = ReadableUtil.getString(pJSON, EStrListKeys.TITLE);
        this.mDesc = ReadableUtil.getString(pJSON, EStrListKeys.DESCRIPTION);
        this.mIndex = ReadableUtil.getInt(pJSON, EStrListKeys.INDEX);
        StorageCompoundException exception = new StorageCompoundException("missing project");
        JSONArray array = ReadableUtil.getArray(pJSON, EStrListKeys.THUMBNAILS);
        this.mThumbs = new HashSet(array.size());
        this.addThumbs(array, exception);
        array = ReadableUtil.getArray(pJSON, EStrListKeys.PROJECTS);
        this.mProjects = new HashSet(array.size());
        this.addProjects(array, exception);
        if (exception.hasException()) {
            StorageUtil.handleStorageException(exception);
        }
    }

    private void addThumbs(@NotNull JSONArray pArray, @NotNull StorageCompoundException pException) {
        for (Object json : pArray) {
            try {
                MListedThumbnail thumbnail = new MListedThumbnail((JSONObject)json);
                this.mThumbs.add(thumbnail);
            }
            catch (StorageException pE) {
                pException.addException(pE);
            }
        }
    }

    private void addProjects(@NotNull JSONArray pArray, @NotNull StorageCompoundException pException) {
        for (Object json : pArray) {
            try {
                MListedProject project = new MListedProject((JSONObject)json);
                this.mProjects.add(project);
            }
            catch (StorageException pE) {
                pException.addException(pE);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MProjectList{");
        sb.append("mURI='").append(this.mURI).append('\'');
        sb.append(", mThumbs=").append(this.mThumbs);
        sb.append(", mProjects=").append(this.mProjects);
        sb.append(", mCreated=").append(this.mCreated);
        sb.append(", mUpdated=").append(this.mUpdated);
        sb.append(", mTitle='").append(this.mTitle).append('\'');
        sb.append(", mDesc='").append(this.mDesc).append('\'');
        sb.append(", mIndex=").append(this.mIndex);
        sb.append(", mThumbnail=").append(this.mThumbnail);
        sb.append(", mThumbPID=").append(this.mThumbPID);
        sb.append(", mCreatorQuantity=").append(this.mCreatorQuantity);
        sb.append(", mBlocksQuantity=").append(this.mBlocksQuantity);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        MProjectList that = (MProjectList)pO;
        return this.mIndex == that.mIndex && this.mURI.equals(that.mURI) && this.mThumbs.equals(that.mThumbs) && this.mProjects.equals(that.mProjects) && this.mCreated.equals(that.mCreated) && this.mUpdated.equals(that.mUpdated) && this.mTitle.equals(that.mTitle) && this.mDesc.equals(that.mDesc);
    }

    public int hashCode() {
        return Objects.hash(this.mURI, this.mThumbs, this.mProjects, this.mCreated, this.mUpdated, this.mTitle, this.mDesc, this.mIndex);
    }

    @Override
    @NotNull
    public ImageIcon getThumbnail(boolean pNewThumbnail) {
        if (pNewThumbnail || this.mThumbnail == null) {
            this.loadThumbnail();
        }
        return this.mThumbnail;
    }

    private void loadThumbnail() {
        Optional<String> thumbURL;
        Optional<String> optional = thumbURL = this.mThumbs.isEmpty() ? this.anyThumbnail() : this.selectedThumbnail();
        if (thumbURL.isPresent()) {
            Optional<BufferedImage> img = SharedUtil.loadThumbnail(thumbURL.get());
            this.mThumbnail = img.map(this::editThumbnail).orElse(CSharedCon.ICON_THUMBNAIL);
        } else {
            this.mThumbnail = CSharedCon.ICON_THUMBNAIL;
        }
    }

    @NotNull
    private Optional<String> anyThumbnail() {
        int i = 0;
        int rdm = new Random().nextInt(this.mProjects.size());
        for (IListedProject project : this.mProjects) {
            if (i == rdm) {
                this.mThumbPID = project.getPID();
                String url = MData.projectImgURLs(project.getPID())[0];
                return Optional.of(url);
            }
            ++i;
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<String> selectedThumbnail() {
        int i = 0;
        int rdm = new Random().nextInt(this.mThumbs.size());
        for (IListedThumbnail thumb : this.mThumbs) {
            if (i == rdm) {
                this.mThumbPID = thumb.getPID();
                return Optional.of(thumb.getImgURL());
            }
            ++i;
        }
        return Optional.empty();
    }

    @NotNull
    private ImageIcon editThumbnail(@NotNull BufferedImage pThumbnail) {
        boolean isNew = this.isNew();
        BufferedImage base = new BufferedImage(260, 150, 1);
        Graphics g = base.getGraphics();
        g.setColor(MCon.colorFrame().darker());
        g.drawRect(0, 0, 260, 150);
        pThumbnail = ImgUtil.makePropScaled(pThumbnail, 260, 150);
        int posX = (260 - pThumbnail.getWidth()) / 2;
        int posY = (150 - pThumbnail.getHeight()) / 2;
        g.drawImage(pThumbnail, posX, posY, null);
        if (isNew || this.isUpdated()) {
            if (isNew) {
                g.drawImage(TAG_NEW, 0, 0, null);
            } else {
                g.drawImage(TAG_UPDATED, 0, 0, null);
            }
        }
        return ImgUtil.getImg(base);
    }

    public boolean isNew() {
        return new Date(new Date().getTime() - 864000000L).before(this.mCreated);
    }

    private boolean isUpdated() {
        return this.mUpdated.isPresent() && !this.isNew() && new Date(new Date().getTime() - 864000000L).before(this.mUpdated.get());
    }

    @Override
    public int getStructureQuantity() {
        return this.mProjects.size();
    }

    @Override
    public int getCreatorQuantity() {
        if (this.mCreatorQuantity == -1) {
            HashSet<Integer> cres = new HashSet<Integer>();
            for (IListedProject str : this.mProjects) {
                cres.add(MData.creatorUnitByProject(str.getPID()));
            }
            this.mCreatorQuantity = cres.size();
        }
        return this.mCreatorQuantity;
    }

    @Override
    public int getBlocksQuantity() {
        if (this.mBlocksQuantity == -1) {
            int[] units = new int[this.mProjects.size()];
            int i = 0;
            for (IListedProject str : this.mProjects) {
                units[i] = str.getPID();
                ++i;
            }
            this.mBlocksQuantity = MData.totalBlocks(units);
        }
        return this.mBlocksQuantity;
    }

    @NotNull
    public Set<IListedProject> getProjects() {
        return this.mProjects;
    }

    @NotNull
    public List<Integer> getPIDs() {
        ArrayList<Integer> units = new ArrayList<Integer>(this.mProjects.size());
        for (IListedProject str : this.mProjects) {
            units.add(str.getPID());
        }
        return units;
    }

    @Override
    @NotNull
    public Date getCreated() {
        return this.mCreated;
    }

    @Override
    @NotNull
    public Optional<Date> getUpdated() {
        return this.mUpdated;
    }

    @Override
    @NotNull
    public String getURI() {
        return this.mURI;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.mTitle;
    }

    @Override
    @NotNull
    public String getDesc() {
        return this.mDesc;
    }

    @Override
    public int getIndex() {
        return this.mIndex;
    }

    @Override
    public int getThumbPID() {
        return this.mThumbPID;
    }

    static {
        ISMLoader.INIT_ICON_CONSTANTS.initLazy();
        Optional<BufferedImage> optionalTag = ImgUtil.getAppBuffered("tag_new");
        Optional<BufferedImage> optionalUpdated = ImgUtil.getAppBuffered("tag_updated");
        if (!optionalTag.isPresent() || !optionalUpdated.isPresent()) {
            throw new NullPointerException();
        }
        TAG_NEW = optionalTag.get();
        TAG_UPDATED = optionalUpdated.get();
    }

    public static enum EStrListKeys implements IUID
    {
        UPDATED("upd"),
        CREATED("crt"),
        URI("uri"),
        TITLE("tit"),
        DESCRIPTION("dsc"),
        INDEX("ind"),
        THUMBNAILS("tmbs"),
        PROJECTS("strs");

        @NotNull
        private final String mUID;

        private EStrListKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

