/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.project_lists;

import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.project_lists.EProjectListsViewState;
import de.maggicraft.ism.project_lists.IGenre;
import de.maggicraft.ism.project_lists.IGenreManager;
import de.maggicraft.ism.project_lists.IProjectList;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.view.MBox;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mthread.MAction;
import de.maggicraft.mthread.MasterThread;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MProjectListsView
extends MISMView<EProjectListsViewState> {
    @NotNull
    private final Runnable mRunFailed = () -> {
        MEditor text = new MEditor(MPos.pos(this, "||p,||p")).title("noProjectLists");
        this.setDim(text.prefWidth() + 2 * MCon.defaultGap(), 200);
        this.updatePref();
    };
    @NotNull
    private final Runnable mRunLoaded = () -> {
        Optional<IGenreManager> genreManager = ISMContainer.getProjectListLoader().getGenreManager();
        if (genreManager.isPresent()) {
            List<IGenre> genres = genreManager.get().getGenres();
            ArrayList<MAction> thumbnailTasks = new ArrayList<MAction>(genres.size());
            MBox[] boxes = new MBox[genres.size()];
            this.initGenres(boxes, thumbnailTasks, genres);
            SwingUtilities.invokeLater(() -> {
                if (this.getPos() != null) {
                    this.getPos().updateView();
                }
                for (MBox box : boxes) {
                    if (box.getPos() == null) continue;
                    box.getPos().updateView();
                }
                ViewManager.getScroll().scrollToTop();
            });
            int cores = Runtime.getRuntime().availableProcessors();
            new MasterThread(thumbnailTasks, "str-loader", Math.max(thumbnailTasks.size(), cores)).start();
            this.updatePref();
        } else {
            this.mRunFailed.run();
        }
    };
    private EProjectListsViewState mCurrentState = EProjectListsViewState.LOADING;
    @NotNull
    private final Runnable mRunLoading = () -> {
        String main = "loading project lists";
        MText text = new MText(MPos.pos(this, "||p,||p")).text(main + "...");
        this.setDim(300, 200);
        new Thread(() -> {
            String[] dots = new String[]{"", ".", "..", "..."};
            int i = 0;
            while (this.mCurrentState == EProjectListsViewState.LOADING && this.isVisible()) {
                try {
                    Thread.sleep(750L);
                }
                catch (InterruptedException pE) {
                    ISMContainer.getLogger().log(pE);
                }
                if (this.mCurrentState != EProjectListsViewState.LOADING || !this.isVisible()) continue;
                text.setText(main + dots[i]);
                i = (i + 1) % 4;
            }
        }).start();
    };
    private boolean mIsLoaded = false;
    private boolean mAfterDisplay = false;

    private static void initProjectLists(@NotNull MBox[] pBoxes, @NotNull List<MAction> pThumbnailTasks, @NotNull IGenre pGenre, int pI) {
        for (IProjectList projectList : pGenre.getProjectList()) {
            MPanel panel = pBoxes[pI].getPanel();
            panel.setBackground(MCon.colorFrame().darker());
            MButton thumb = new MButton((MMPos)MPos.pos(panel, "[[<>260<>,[[<>150<>"), (Icon)CSharedCon.ICON_THUMBNAIL);
            thumb.addAction(pEvent -> {
                ViewManager.VIEW_DETAIL_PROJECT_LIST.setProjectList(projectList);
                ViewManager.displayLeftMenu(ViewManager.VIEW_DETAIL_PROJECT_LIST);
            });
            thumb.setCursor(CSharedCon.CURSOR_HAND);
            pThumbnailTasks.add(new MAction(() -> {
                Icon icon = projectList.getThumbnail(true);
                if (icon != CSharedCon.ICON_THUMBNAIL) {
                    thumb.setIcon(icon);
                }
            }));
            MText projectTitle = new MText(MPos.pos("V[[p,[]<8>p", thumb)).text(projectList.getTitle());
            projectTitle.setForeground(MCon.colorTitleText());
            new MText(MPos.pos("V[[p,[]<8>p<>", projectTitle)).text(projectList.getDesc());
        }
    }

    @NotNull
    private static Dimension getPrefDim(@NotNull MBox[] pBoxes) {
        int width = 320;
        int height = 75;
        for (MBox box : pBoxes) {
            if (box.getPos() == null) continue;
            width = Math.max(width, box.getPos().getPrefWidth());
            height += box.getPos().getPrefHeight() + 58;
        }
        return new Dimension(60 + width, height);
    }

    @Override
    protected void stash(@NotNull EProjectListsViewState pState) {
        if (!this.mIsLoaded || this.mCurrentState != pState || pState != EProjectListsViewState.LOADED && pState != EProjectListsViewState.UPDATED) {
            this.mAfterDisplay = true;
            super.stash(pState);
        }
    }

    @Override
    protected void displayState(@NotNull EProjectListsViewState pState) {
        Runnable runnable = this.getAction(this.mCurrentState, pState);
        this.mCurrentState = pState;
        runnable.run();
        this.mIsLoaded = true;
    }

    public void setCurrentState(@NotNull EProjectListsViewState pCurrentState) {
        if (ViewManager.getScroll() != null && ViewManager.isCurrent(ViewManager.VIEW_PROJECT_LISTS)) {
            ViewManager.VIEW_PROJECT_LISTS.display(pCurrentState);
        } else if (pCurrentState != this.mCurrentState) {
            this.mIsLoaded = false;
            this.mCurrentState = pCurrentState;
        }
    }

    private Runnable getAction(@NotNull EProjectListsViewState pOldState, @NotNull EProjectListsViewState pCurrentState) {
        if (this.mIsLoaded) {
            if (pOldState == pCurrentState) {
                return () -> {};
            }
            if (pOldState == EProjectListsViewState.LOADING) {
                if (pCurrentState == EProjectListsViewState.LOADED || pCurrentState == EProjectListsViewState.UPDATED) {
                    return this.mRunLoaded;
                }
                if (pCurrentState == EProjectListsViewState.FAILED) {
                    return this.mRunFailed;
                }
                throw new IllegalArgumentException();
            }
            if (pOldState == EProjectListsViewState.LOADED && pCurrentState == EProjectListsViewState.UPDATED) {
                return this.mRunLoaded;
            }
            throw new IllegalArgumentException();
        }
        if (pCurrentState == EProjectListsViewState.LOADING) {
            return this.mRunLoading;
        }
        if (pCurrentState == EProjectListsViewState.LOADED || pCurrentState == EProjectListsViewState.UPDATED) {
            return this.mRunLoaded;
        }
        if (pCurrentState == EProjectListsViewState.FAILED) {
            return this.mRunFailed;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public EProjectListsViewState getDefaultState() {
        return this.mCurrentState;
    }

    @Override
    public void initialize() {
        MFlowPanel header = new MFlowPanel((MMPos)LPos.pos(this, "[[<>m<>,[[<>61", 1), MCon.colorFrame());
        new MTitle(MPos.pos(header, "[[m,]]<>p<>")).title("projectList");
    }

    private void initGenres(final @NotNull MBox[] pBoxes, @NotNull List<MAction> pThumbnailTasks, @NotNull List<IGenre> pGenres) {
        int i = 0;
        MBox last = null;
        for (IGenre genre : pGenres) {
            MPos pos = i == 0 ? LPos.pos(this, "||<>m<>,[[<76>45", 1 + i) : LPos.pos("||<>m<>,[]45", last, 1 + i);
            MFlowPanel panelHeader = new MFlowPanel(pos, 61, MCon.colorFrame());
            new MTitle(MPos.pos(panelHeader, "[[m,]]<>p<>")).text(genre.getName());
            pos = i == 0 ? MPos.pos(this, "||<>m<>,[[<136>p") : MPos.pos("[[<>m<>,[]<75>p", last);
            pBoxes[i] = new MBox(pos, 260, 260){

                @Override
                public void updateScrollDim(int pWidth, int pHeight) {
                    Dimension prefDim = MProjectListsView.getPrefDim(pBoxes);
                    MProjectListsView.this.setDim(prefDim.width, prefDim.height);
                }
            };
            pBoxes[i].setBackground(MCon.colorFrame());
            MProjectListsView.initProjectLists(pBoxes, pThumbnailTasks, genre, i);
            last = pBoxes[i];
            ++i;
        }
    }

    @Override
    public void afterDisplay(@NotNull EProjectListsViewState pState) {
        if (this.mAfterDisplay) {
            this.mAfterDisplay = false;
            SwingUtilities.invokeLater(this::afterDisplay);
        }
    }

    @Override
    @NotNull
    public String getURI() {
        return "structure-lists/overview/";
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_PROJECT_LISTS;
    }

    @Override
    public int getMenuButton() {
        return 1;
    }

    @Override
    @NotNull
    public EFeature getFeature() {
        return EFeature.PROJECT_LISTS;
    }
}

