/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.project_lists;

import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.loader.ISMLoader;
import de.maggicraft.ism.project_lists.EProjectListsViewState;
import de.maggicraft.ism.project_lists.IGenreManager;
import de.maggicraft.ism.project_lists.IProjectListLoader;
import de.maggicraft.ism.project_lists.MGenreManager;
import de.maggicraft.mcommons.initialization.EInitializableStates;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mioutil.io.MIOUtil;
import de.maggicraft.mioutil.json.ReadableUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Date;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ProjectListLoader
implements IProjectListLoader {
    private File mFile;
    private URL mURL;
    private IGenreManager mGenreManager;

    public ProjectListLoader() {
    }

    public ProjectListLoader(@NotNull File pFile, @NotNull URL pURL) {
        this.mFile = pFile;
        this.mURL = pURL;
    }

    @Override
    public void initialize() {
        new Thread(() -> {
            if (this.mFile == null) {
                this.mFile = new File(MCon.appFolder(), "project_lists.json");
            }
            if (this.mURL == null) {
                try {
                    this.mURL = new URL("https://instant-structures-mod.com/project_lists.json");
                }
                catch (MalformedURLException pE) {
                    ISMContainer.getLogger().log(pE);
                }
            }
            this.load();
        }).start();
    }

    private void load() {
        if (this.mFile.exists()) {
            Optional<JSONObject> jsonUpdate;
            Optional<JSONObject> jsonActual = this.jsonFromFile();
            if (jsonActual.isPresent()) {
                new Thread(() -> {
                    MGenreManager genreManager = new MGenreManager((JSONObject)jsonActual.get());
                    this.initGUI(genreManager, EProjectListsViewState.LOADED);
                }).start();
            }
            if (ProjectListLoader.hasUpdate(jsonActual, jsonUpdate = this.loadFileFromServer()) && jsonUpdate.isPresent()) {
                MGenreManager genreManager = new MGenreManager(jsonUpdate.get());
                this.initGUI(genreManager, EProjectListsViewState.UPDATED);
                MIOUtil.write(this.mFile, jsonUpdate.get().toJSONString());
            }
        } else {
            this.loadFromServer();
        }
    }

    private void loadFromServer() {
        try {
            Optional<JSONObject> jsonUpdate = this.loadFileFromServer();
            if (jsonUpdate.isPresent()) {
                MGenreManager genreManager = new MGenreManager(jsonUpdate.get());
                this.initGUI(genreManager, EProjectListsViewState.LOADED);
                MIOUtil.write(this.mFile, jsonUpdate.get().toJSONString());
            }
        }
        catch (Exception pE) {
            ISMContainer.getLogger().log(pE);
            ViewManager.VIEW_PROJECT_LISTS.setCurrentState(EProjectListsViewState.FAILED);
        }
    }

    @NotNull
    private Optional<JSONObject> jsonFromFile() {
        if (this.mFile.exists()) {
            try {
                JSONObject json = (JSONObject)new JSONParser().parse(new BufferedReader(new FileReader(this.mFile)));
                return Optional.of(json);
            }
            catch (IOException | ParseException pE) {
                ISMContainer.getLogger().log(pE);
                try {
                    Files.deleteIfExists(this.mFile.toPath());
                }
                catch (IOException pEx) {
                    ISMContainer.getLogger().log(pEx);
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static boolean hasUpdate(@NotNull Optional<JSONObject> pJSONActual, @NotNull Optional<JSONObject> pJSONUpdate) {
        if (pJSONActual.isPresent() && pJSONUpdate.isPresent()) {
            Date dateActual = ReadableUtil.getDate(pJSONActual.get(), MGenreManager.EGenreManagerKeys.UPDATED);
            Date dateUpdate = ReadableUtil.getDate(pJSONUpdate.get(), MGenreManager.EGenreManagerKeys.UPDATED);
            return dateUpdate.getTime() > dateActual.getTime();
        }
        return pJSONUpdate.isPresent();
    }

    @NotNull
    private Optional<JSONObject> loadFileFromServer() {
        return SharedUtil.loadResource(this.mURL, pInputStream -> {
            JSONObject json = (JSONObject)new JSONParser().parse(new InputStreamReader((InputStream)pInputStream));
            return Optional.of(json);
        }, Optional.empty());
    }

    private synchronized void initGUI(@NotNull IGenreManager pGenreManager, @NotNull EProjectListsViewState pState) {
        if (this.mGenreManager == null || pGenreManager.getDate().getTime() > this.mGenreManager.getDate().getTime()) {
            this.mGenreManager = pGenreManager;
            if (ISMLoader.INIT_STYLE_CONSTANTS.getState() == EInitializableStates.INITIALIZED) {
                ViewManager.VIEW_PROJECT_LISTS.setCurrentState(pState);
            }
        }
    }

    @Override
    @NotNull
    public Optional<IGenreManager> getGenreManager() {
        return Optional.ofNullable(this.mGenreManager);
    }
}

