/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.results;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.jetbrains.annotations.NotNull;

public class MResLayout
implements LayoutManager {
    public static final boolean RES_TYPE_DETAIL = true;
    static final boolean RES_TYPE_MINIMAL = false;
    public static final int MAX_WIDTH_DETAIL = 850;
    public static final int GAP = 30;
    private static final int MIN_WIDTH_DETAIL = 630;
    private static final int WIDTH_MINIMAL = 256;
    private static final int HEIGHT_MINIMAL = 150;
    private static final int GAP_V = 15;
    private int mCreQuantity;
    private boolean mResType;

    MResLayout(boolean pResType) {
        this.mResType = pResType;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        int compQuantity = parent.getComponentCount();
        int columns = this.getColumns(compQuantity, parent.getWidth());
        int height = this.getHeight(columns, compQuantity);
        return new Dimension(parent.getWidth(), height);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container parent) {
        int compQuantity = parent.getComponentCount();
        int height = this.getHeight(this.getColumns(compQuantity, parent.getWidth()), compQuantity);
        return new Dimension((!this.mResType ? 256 : 630) + 30, height);
    }

    @Override
    public void layoutContainer(@NotNull Container parent) {
        if (parent.getWidth() == 0) {
            return;
        }
        int comps = parent.getComponentCount();
        if (this.mResType) {
            int width = Math.min(parent.getWidth() - 60, 850);
            int x = (parent.getWidth() - width) / 2;
            int y = 15;
            for (int i = 0; i < comps; ++i) {
                int height = parent.getComponent((int)i).getPreferredSize().height;
                parent.getComponent(i).setBounds(x, y, width, height);
                y += height + 15;
            }
        } else {
            int columns = this.getColumns(comps, parent.getWidth());
            int rows = MResLayout.getRows(columns, comps);
            int posX = 30 + (parent.getWidth() - columns * 286 - 30) / 2;
            int c = 0;
            for (int y = 0; y < rows; ++y) {
                for (int x = 0; x < columns; ++x) {
                    parent.getComponent(c).setBounds(posX + x * 286, 15 + y * 165, 256, 150);
                    if (++c != comps) continue;
                    return;
                }
            }
        }
    }

    private int getHeight(int pColumns, int pComps) {
        if (this.mResType) {
            return 165 * (pComps - this.mCreQuantity) + 135 * this.mCreQuantity;
        }
        return 165 * MResLayout.getRows(pColumns, pComps);
    }

    private static int getRows(int pColumns, int pComps) {
        return (int)Math.ceil((double)pComps / (double)pColumns);
    }

    private int getColumns(int pCompQuantity, int pWidth) {
        if (!this.mResType) {
            int cols = (pWidth - 30) / (this.getColumnWidth() + 30);
            return Math.min(Math.max(1, cols), pCompQuantity);
        }
        return 1;
    }

    private int getColumnWidth() {
        return !this.mResType ? 256 : 850;
    }

    void setResType(int pCreQuantity, boolean pResType) {
        this.mCreQuantity = pCreQuantity;
        this.mResType = pResType;
    }
}

