/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.results;

import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.results.ResProject;
import de.maggicraft.ism.results.ResSearch;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MPanel;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;

public class ResCol
extends ResProject {
    private ICollection mCollection;

    public ResCol(int pPID, boolean pCreView) {
        super(pPID, pCreView);
    }

    @Override
    public void initInfo() {
        this.mCollection = MData.getCollection(this.mUnit);
        this.mProject = this.mCollection;
    }

    @Override
    public void resDetail() {
        int max;
        MText tInfo2;
        this.mTextComps = new LinkedList();
        MPanel panel = new MPanel(MPos.pos(ResSearch.sPanel, "||p,||p"), COLOR_BACKGROUND);
        panel.setPreferredSize(new Dimension(256, 150));
        this.mThumb = new MButton((MMPos)MPos.pos(panel, "[[<>256<>,[[<>150<>"), (Icon)CSharedCon.ICON_THUMBNAIL).addAction(pEvent -> ViewManager.displayDetail(this.mCollection));
        this.mThumb.setCursor(CSharedCon.CURSOR_HAND);
        MText title = new MText(MPos.pos("H[]<20>p,[[<14>p", this.mThumb)).text(this.mCollection.getTitle());
        title.setLineWrap(false);
        this.mTextComps.add(title);
        MPos pos = MPos.pos("[]<20>p,[]<14>p", this.mThumb, title);
        if (sShowCreator) {
            tInfo2 = new MText(pos).text(MLangManager.get("i.cre") + ": ");
            MText creCon = new MText(MPos.pos("[]<>p,||p", tInfo2)).text(this.mCollection.getCreator().getName());
            creCon.setLineWrap(false);
            this.mTextComps.add(creCon);
            SharedUtil.addLink(creCon, () -> ViewManager.displayDetail(this.mCollection.getCreator()));
        } else {
            tInfo2 = new MText(pos).rep("totBlks", CommonUtil.decMark(this.mCollection.getTotalBlocks()));
        }
        MText tTags = new MText(MPos.pos("[]<20>p,[]<14>p", this.mThumb, tInfo2)).text(MLangManager.get("i.tag") + ": ");
        int curWidth = 0;
        int comWidth = Util.getWidth(", ");
        String[] mTags = this.mCollection.getTags();
        for (max = 0; max < mTags.length && (curWidth += Util.getWidth(mTags[max]) + comWidth) < 290; ++max) {
        }
        MText last = tTags;
        for (int i = 0; i < max; ++i) {
            last = new MText(MPos.pos("[]<>p,||p", last)).text(mTags[i]);
            this.mTextComps.add(last);
            int finalI = i;
            SharedUtil.addLink(last, () -> ViewManager.SEARCH_MANAGER.searchTag(ViewManager.VIEW_SEARCH_RES, mTags[finalI]));
            if (i >= max - 1 || i == max - 1 && max == mTags.length) continue;
            last = new MText(MPos.pos("[]<>p,||p", last)).text(i < max - 1 ? ", " : "...");
        }
        String str = MLangManager.get("te.strs") + ": ";
        for (int i = 0; i < this.mCollection.getStructures().size(); ++i) {
            if (i > 0) {
                str = str + ", ";
            }
            str = str + this.mCollection.getName(i);
        }
        MText tStrs = new MText(MPos.pos("[]<20>m,[]<14>m", this.mThumb, tTags)).text(str);
        this.mTextComps.add(tStrs);
        ResSearch.buttonMore(panel, SharedUtil.moreStr(this.mCollection, panel, true, this.mIsCreatorView));
    }

    @Override
    public List<JTextComponent> highlightText() {
        return this.mTextComps;
    }
}

