/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.results;

import de.maggicraft.ism.analytics.util.EUTMExternal;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.CStrGui;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.results.ResSearch;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.menu.MMenuItem;
import de.maggicraft.mgui.menu.MPopupMenu;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.view.MPanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class ResCre
extends ResSearch {
    private LinkedList<JTextComponent> mTextComps;
    private ImageIcon mIcon = MData.ICON_DEFAULT_AVATAR;
    private ICreator mCreator;

    ResCre(int pCID) {
        super(pCID);
    }

    @Override
    public void initInfo() {
        this.mCreator = MData.getCreator(this.mUnit);
    }

    @Override
    public void resInit() {
        this.mIcon = this.mCreator.getAvatar();
        if (this.mIcon != MData.ICON_DEFAULT_AVATAR) {
            this.mThumb.setIcon(this.mIcon);
        }
    }

    @Override
    public void resDetail() {
        this.mTextComps = new LinkedList();
        MPanel panel = new MPanel(MPos.pos(sPanel, "||p,||p"), COLOR_BACKGROUND);
        panel.setPreferredSize(new Dimension(256, 120));
        this.mThumb = new MButton((MMPos)MPos.pos(panel, "[[<>120<>,[[<>120<>"), (Icon)this.mIcon).addAction(pEvent -> ViewManager.displayDetail(this.mCreator));
        this.mThumb.setCursor(CSharedCon.CURSOR_HAND);
        MText title = new MText(MPos.pos("H[]<20>p,[[p", this.mThumb)).text(this.mCreator.getName());
        title.setLineWrap(false);
        this.mTextComps.add(title);
        String sort = "";
        if (sSort >= 3 && sSort <= 7) {
            sort = sort + CommonUtil.decMark(MData.total(CStrGui.SORT_TO_COMPR[sSort], this.mCreator.getStrPIDs()));
        } else if (sSort == 0 || sSort == 1) {
            sort = sort + CommonUtil.decMark(this.mCreator.getBlocks());
        } else if (sSort == 2) {
            int area = 0;
            for (int unit : this.mCreator.getStrPIDs()) {
                String[] structures;
                for (String str : structures = MData.projectStructures(unit)) {
                    String part = str.split("\ufffb")[1];
                    area += part.charAt(0) * part.charAt(2);
                }
            }
            sort = sort + CommonUtil.decMark(area);
        } else if (sSort == 9 || sSort == 8) {
            for (int unit : this.mCreator.getStrPIDs()) {
                if (sort.length() > 0) {
                    sort = sort + ", ";
                }
                sort = sSort == 9 ? sort + MData.projectUpdatedFormatted(unit) : sort + MData.projectPostedFormatted(unit);
            }
        }
        sort = sSort != 9 && sSort != 8 ? sort + ' ' + MLangManager.get(CStrGui.SORT_TITLES[sSort]) + ' ' + MLangManager.get("i.all") : MLangManager.get(sSort == 9 ? "i.pst" : "i.udt") + ": " + sort;
        MText tSort = new MText(MPos.pos("[]<20>p,[]<15>p", this.mThumb, title)).text(sort);
        tSort.setLineWrap(false);
        String stats = MLangManager.get("i.lvl") + ' ' + this.mCreator.getLevels() + '\t' + CommonUtil.decMark(this.mCreator.getSubs()) + ' ' + (this.mCreator.getSubs() == 1 ? MLangManager.get("i.sub") : MLangManager.get("i.subs"));
        new MText(MPos.pos("[]<20>m,[]<15>p", this.mThumb, tSort)).text(stats);
        tSort.setLineWrap(false);
        ResSearch.buttonMore(panel, this.moreCreator(panel));
    }

    @Override
    public void resMinimal() {
        this.mTextComps = new LinkedList();
        MPanel panel = new MPanel(MPos.pos(sPanel, "||p,||p"), COLOR_BACKGROUND);
        panel.setPreferredSize(new Dimension(256, 120));
        panel.setBackground(MCon.colorSpoilerBackground().brighter().brighter());
        panel.setCursor(CSharedCon.CURSOR_HAND);
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent pEvent) {
                ViewManager.displayDetail(ResCre.this.mCreator);
            }
        });
        MText tCreator = new MText(MPos.pos(panel, "||p,[[<5>p")).text(this.mCreator.getName());
        this.mTextComps.add(tCreator);
        this.mThumb = new MButton((MMPos)MPos.pos(panel, "||120,]]<>120<>"), (Icon)this.mIcon).addAction(pEvent -> ViewManager.displayDetail(this.mCreator));
        this.mThumb.setCursor(CSharedCon.CURSOR_HAND);
        this.moreCreator(panel);
    }

    @NotNull
    private MPopupMenu moreCreator(@NotNull Container pCon) {
        MPopupMenu menu = new MPopupMenu();
        menu.add(new MMenuItem(pEvent -> SharedUtil.openCreator(this.mCreator, EUTMExternal.EXT_MENU_CRE)).text(MLangManager.get("me.openCre1") + ' ' + this.mCreator.getName() + MLangManager.get("me.openCre2")));
        menu.add(new MMenuItem(pEvent -> ViewManager.displayDetail(this.mCreator)).text(MLangManager.get("me.goCre") + ' ' + this.mCreator.getName()));
        menu.addToContainer(pCon);
        return menu;
    }

    @Override
    public List<JTextComponent> highlightText() {
        return this.mTextComps;
    }
}

