/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.results;

import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.local.ILocal;
import de.maggicraft.ism.results.ResSearch;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.menu.MMenuItem;
import de.maggicraft.mgui.menu.MPopupMenu;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.view.MPanel;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.JTextComponent;

public class ResLoc
extends ResSearch {
    private final ILocal mStr;
    private LinkedList<JTextComponent> mTextComps;

    ResLoc(ILocal pStr) {
        super(-1);
        this.mStr = pStr;
    }

    @Override
    public void initInfo() {
    }

    @Override
    public void resInit() {
    }

    @Override
    public void resDetail() {
        this.res(true);
    }

    @Override
    public void resMinimal() {
        this.res(false);
    }

    private void res(boolean pDetail) {
        this.mTextComps = new LinkedList();
        MPanel panel = new MPanel(MPos.pos(sPanel, "||p,||p"), COLOR_BACKGROUND);
        panel.setPreferredSize(new Dimension(256, 150));
        MText tFileName = new MText(MPos.pos(panel, "[[<20>p,[[<14>p")).text(this.mStr.getFileName());
        tFileName.setLineWrap(false);
        this.mTextComps.add(tFileName);
        SharedUtil.addLink(tFileName, () -> {
            try {
                ViewManager.displayPlaceStr(this.mStr);
            }
            catch (StorageException pE) {
                StorageUtil.handleStorageException(pE);
            }
        });
        IDim dim = this.mStr.getDim();
        String area = MLangManager.rep("te.blocksArea", CommonUtil.decMark(this.mStr.getBlocks()), CommonUtil.decMark(dim.getX()), CommonUtil.decMark(dim.getY()), CommonUtil.decMark(dim.getZ()));
        MText tBlocks = new MText(MPos.pos("V[[<20>p,[]<14>p", tFileName)).text(area);
        tBlocks.setLineWrap(false);
        MText tDate = new MText(MPos.pos("V[[<20>p,[]<14>p", tBlocks)).rep("addOn", SharedUtil.formatDate(this.mStr.getDateAdded()));
        tDate.setLineWrap(false);
        String placed = this.mStr.getPlaced() == 1 ? MLangManager.get("te.placedOnce") : MLangManager.rep("te.placedTimes", this.mStr.getPlaced());
        new MText(MPos.pos("V[[<20>p,[]<14>p", tDate)).text(placed);
        MPopupMenu menu = new MPopupMenu();
        ActionListener openStr = pEvent -> {
            try {
                ViewManager.displayPlaceStr(this.mStr);
            }
            catch (StorageException pE) {
                StorageUtil.handleStorageException(pE);
            }
        };
        menu.add(new MMenuItem(openStr).title("place"));
        menu.addToContainer(panel);
        if (pDetail) {
            MButton bPlace = new MButton(MPos.pos(panel, "]]p,||p"), SharedUtil.ICON_PLACE, SharedUtil.ICON_PLACE_HOVER, SharedUtil.ICON_PLACE_PRESSED).addAction(openStr);
            ViewUtil.roundButtonLabel(bPlace, "plcStrRound", ViewUtil.LabelAlign.LEFT);
        } else {
            ResSearch.buttonMore(MPos.pos(panel, "]]p,||p"), menu);
        }
    }

    @Override
    public List<JTextComponent> highlightText() {
        return this.mTextComps;
    }
}

