/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.results;

import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.placed.IPlaced;
import de.maggicraft.ism.results.ResSearch;
import de.maggicraft.ism.views.EChangeType;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.menu.MMenuItem;
import de.maggicraft.mgui.menu.MPopupMenu;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MLayered;
import de.maggicraft.mgui.view.MPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NotNull;

public class ResPlacedLocal
extends ResSearch {
    private static final ImageIcon ICON_REPOS = ImgUtil.getAppIcon("repos");
    private static final ImageIcon ICON_REPOS_HOVER = ImgUtil.getAppIcon("repos_hover");
    private static final ImageIcon ICON_REPOS_PRESSED = ImgUtil.getAppIcon("repos_pressed");
    private static final ImageIcon ICON_REMOVE = ImgUtil.getAppIcon("remove");
    private static final ImageIcon ICON_REMOVE_HOVER = ImgUtil.getAppIcon("remove_hover");
    private static final ImageIcon ICON_REMOVE_PRESSED = ImgUtil.getAppIcon("remove_pressed");
    @NotNull
    private final IPlaced mPlaced;
    @NotNull
    private final EChangeType mType;
    private LinkedList<JTextComponent> mTextComps;
    private final Icon mThumbnail = CSharedCon.ICON_THUMBNAIL;

    ResPlacedLocal(@NotNull IPlaced pPlaced, @NotNull EChangeType pType) {
        super(-1);
        this.mPlaced = pPlaced;
        this.mType = pType;
    }

    @Override
    public void initInfo() {
    }

    @Override
    public void resInit() {
    }

    @Override
    public void resDetail() {
        this.mTextComps = new LinkedList();
        int gr1 = 2 * MCon.defaultGap();
        int gr2 = 0;
        if (this.mType == EChangeType.TYPE_REPOS) {
            gr2 = (gr1 += ICON_REPOS.getIconWidth()) + MCon.defaultGap() + Util.getWidth(MCon.fontText(), MLangManager.get("te.repos"));
        } else if (this.mType == EChangeType.TYPE_REMOVE) {
            gr2 = (gr1 += ICON_REMOVE.getIconWidth()) + MCon.defaultGap() + Util.getWidth(MCon.fontText(), MLangManager.get("te.remove"));
        } else if (this.mType == EChangeType.TYPE_PLACED) {
            gr2 = gr1 + ICON_DOTS.getIconWidth();
        }
        MPanel panel = new MPanel(MPos.pos(sPanel, "||p,||p"), COLOR_BACKGROUND);
        panel.setPreferredSize(new Dimension(256, 150));
        this.mThumb = new MButton((MMPos)MPos.pos(panel, "[[<>256<>,[[<>150<>"), this.mThumbnail);
        this.mThumb.setCursor(CSharedCon.CURSOR_HAND);
        MText tSrc = new MText(MPos.pos("H[]<20>m<" + gr1 + ">,[[<15>p", this.mThumb)).rep("aLoc", this.mPlaced.getStructureName());
        tSrc.setLineWrap(false);
        this.mTextComps.add(tSrc);
        IDim dim = this.mPlaced.getDim();
        String area = MLangManager.rep("te.blocksArea", CommonUtil.decMark(this.mPlaced.getBlocks()), dim.getX(), dim.getY(), dim.getZ());
        MText tBlocks = new MText(MPos.pos("[[<>m<" + gr2 + ">,[]<15>p", tSrc)).text(area);
        tBlocks.setLineWrap(false);
        IPos pos = this.mPlaced.getCenter();
        MText tPos = new MText(MPos.pos("H[]<20>m<" + gr1 + ">,]]p", this.mThumb)).rep("pos1", pos.getX(), pos.getY(), pos.getZ());
        tPos.setLineWrap(false);
        String[] types = new String[]{"plc", "rep", "rem"};
        MText tPlaced = new MText(MPos.pos("[[<>p,][p", tPos)).rep(types[this.mPlaced.getType().getUID()], SharedUtil.formatExactDate(this.mPlaced.getDatePlaced()));
        tPlaced.setLineWrap(false);
        MText tWorld = new MText(MPos.pos("[]<>m<" + gr2 + ">,||<>p<>", tPlaced)).text(this.mPlaced.getWorldName());
        tWorld.setLineWrap(false);
        this.mTextComps.add(tWorld);
        MPopupMenu menu = this.more();
        menu.addToContainer(panel);
        if (this.mType == EChangeType.TYPE_PLACED) {
            ResSearch.buttonMore(panel, menu);
        } else if (this.mType == EChangeType.TYPE_REPOS) {
            MButton button = new MButton(MPos.pos(panel, "]]p,||p"), ICON_REPOS, ICON_REPOS_HOVER, ICON_REPOS_PRESSED);
            button.addAction(pEvent -> {
                ViewManager.VIEW_REPOS_STRUCTURE.setPlaced(this.mPlaced);
                ViewManager.displayLeftMenu(ViewManager.VIEW_REPOS_STRUCTURE);
            });
            ViewUtil.roundButtonLabel(button, "repos", ViewUtil.LabelAlign.LEFT);
        } else if (this.mType == EChangeType.TYPE_REMOVE) {
            MButton button = new MButton(MPos.pos(panel, "]]p,||p"), ICON_REMOVE, ICON_REMOVE_HOVER, ICON_REMOVE_PRESSED);
            button.addAction(pEvent -> {
                ViewManager.VIEW_REMOVE_STRUCTURE.setPlaced(this.mPlaced);
                ViewManager.displayLeftMenu(ViewManager.VIEW_REMOVE_STRUCTURE);
            });
            ViewUtil.roundButtonLabel(button, "remove", ViewUtil.LabelAlign.LEFT);
        }
    }

    @Override
    public void resMinimal() {
        this.mTextComps = new LinkedList();
        MLayered panel = new MLayered(MPos.pos(sPanel, "||p,||p"));
        panel.setBackground(COLOR_BACKGROUND);
        this.mThumb = new MButton((MMPos)MPos.pos(panel, "[[<>256<>,[[<>150<>"), this.mThumbnail);
        this.mThumb.setCursor(CSharedCon.CURSOR_HAND);
        panel.setLayer(this.mThumb, 0);
        JTextPane textPane = new JTextPane();
        textPane.setFont(MCon.fontText());
        textPane.setText(this.mPlaced.getStructureName());
        textPane.setForeground(MCon.colorText());
        textPane.setBackground(new Color(0, 0, 0, 175));
        textPane.setBounds(0, 10, 256, 10);
        int height = textPane.getPreferredSize().height;
        textPane.setBounds(0, 150 - height, 256, height);
        panel.add((Component)textPane, 1);
        StyledDocument doc = textPane.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        this.mTextComps.add(textPane);
        this.more().addToContainer(panel);
    }

    @NotNull
    private MPopupMenu more() {
        MPopupMenu menu = new MPopupMenu();
        boolean changeable = this.mPlaced.isChangeable();
        if (changeable) {
            menu.add(new MMenuItem(pEvent -> {
                ViewManager.VIEW_REPOS_STRUCTURE.setPlaced(this.mPlaced);
                ViewManager.displayLeftMenu(ViewManager.VIEW_REPOS_STRUCTURE);
            }).title("repos"));
            menu.add(new MMenuItem(pEvent -> {
                ViewManager.VIEW_REMOVE_STRUCTURE.setPlaced(this.mPlaced);
                ViewManager.displayLeftMenu(ViewManager.VIEW_REMOVE_STRUCTURE);
            }).title("remove"));
        }
        menu.add(new MMenuItem(pEvent -> ViewManager.displayLeftMenu(ViewManager.VIEW_LOCAL_STRUCTURES)).title("goProj"));
        return menu;
    }

    @Override
    public List<JTextComponent> highlightText() {
        return this.mTextComps;
    }
}

