/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.results;

import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.IStructure;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.CStrGui;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.results.ResSearch;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MLayered;
import de.maggicraft.mgui.view.MPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.annotations.NotNull;

public class ResProject
extends ResSearch {
    protected final boolean mIsCreatorView;
    @NotNull
    protected ImageIcon mIcon = CSharedCon.ICON_THUMBNAIL;
    protected IProject mProject;
    protected LinkedList<JTextComponent> mTextComps;

    public ResProject(int pPID, boolean pIsCreatorView) {
        super(pPID);
        this.mUnit = pPID;
        this.mIsCreatorView = pIsCreatorView;
    }

    @Override
    public void initInfo() {
        this.mProject = MData.getProject(this.mUnit);
    }

    @Override
    public void resInit() {
        Optional<BufferedImage> img = SharedUtil.loadThumbnail(this.mProject.getImgURLs()[0]);
        if (img.isPresent()) {
            this.mIcon = ImgUtil.getImg(img.get());
            this.mThumb.setIcon(this.mIcon);
        }
    }

    @Override
    public void resDetail() {
        int max;
        this.mTextComps = new LinkedList();
        MPanel panel = new MPanel(MPos.pos(sPanel, "||p,||p"), COLOR_BACKGROUND);
        panel.setPreferredSize(new Dimension(256, 150));
        this.mThumb = new MButton((MMPos)MPos.pos(panel, "[[<>256<>,[[<>150<>"), (Icon)this.mIcon).addAction(pEvent -> ViewManager.displayDetail(this.mProject));
        this.mThumb.setCursor(CSharedCon.CURSOR_HAND);
        MText title = new MText(MPos.pos("H[]<20>p,[[<14>p", this.mThumb)).text(this.mProject.getTitle());
        title.setLineWrap(false);
        this.mTextComps.add(title);
        MText creator = null;
        if (sShowCreator) {
            creator = new MText(MPos.pos("[]<20>p,[]<14>p", this.mThumb, title)).text(MLangManager.get("i.cre") + ": ");
            MText creCon = new MText(MPos.pos("[]<>p,||p", creator)).text(this.mProject.getCreator().getName());
            creCon.setLineWrap(false);
            this.mTextComps.add(creCon);
            SharedUtil.addLink(creCon, () -> ViewManager.displayDetail(this.mProject.getCreator()));
        }
        MPos posTag = MPos.pos("[]<20>p,[]<14>p", this.mThumb, sShowCreator ? creator : title);
        MText tTags = new MText(posTag).text(MLangManager.get("i.tag") + ": ");
        int curWidth = 0;
        int comWidth = Util.getWidth(", ");
        String[] tags = this.mProject.getTags();
        for (max = 0; max < tags.length && (curWidth += Util.getWidth(tags[max]) + comWidth) < 290; ++max) {
        }
        MText last = tTags;
        for (int i = 0; i < max; ++i) {
            last = new MText(MPos.pos("[]<>p,||p", last)).text(tags[i]);
            this.mTextComps.add(last);
            int finalI = i;
            SharedUtil.addLink(last, () -> ViewManager.SEARCH_MANAGER.searchTag(ViewManager.VIEW_SEARCH_RES, tags[finalI]));
            if (i >= max - 1 || i == max - 1 && max == tags.length) continue;
            last = new MText(MPos.pos("[]<>p,||p", last)).text(i < max - 1 ? ", " : "...");
        }
        IStructure str = this.mProject.getStructures().get(0);
        MText blocks = null;
        if (!sShowCreator) {
            blocks = new MText(MPos.pos("[]<20>p,[]<14>p", this.mThumb, tTags));
            blocks.text(SharedUtil.lang("i.blk", CommonUtil.decMark(str.getBlocks())));
            this.mTextComps.add(blocks);
            if (sSort == 1 || sSort == 0) {
                sSort = 2;
            }
        }
        String sort = ": ";
        if (sSort >= 3 && sSort <= 7) {
            sort = sort + CommonUtil.decMark(MData.get(CStrGui.SORT_TO_COMPR[sSort], this.mUnit));
        } else if (sSort == 0 || sSort == 1 || sSort == 2) {
            IStructure structure = this.mProject.getStructures().get(0);
            if (sSort == 2) {
                IDim dim = structure.getDim();
                sort = sort + CommonUtil.decMark(dim.getX()) + 'x' + CommonUtil.decMark(dim.getZ()) + ", " + CommonUtil.decMark(dim.getArea()) + ' ' + MLangManager.get("i.sqm");
            } else {
                sort = sort + CommonUtil.decMark(structure.getBlocks());
            }
        } else if (sSort == 9 || sSort == 8) {
            sort = sSort == 9 || !this.mProject.hasUpdate() ? sort + this.mProject.getDatePosted() : sort + this.mProject.getDateUpdated();
        } else {
            throw new IllegalArgumentException();
        }
        MPos pos = MPos.pos("[]<20>p,[]<14>p", this.mThumb, blocks == null ? tTags : blocks);
        MText tSort = new MText(pos).text(MLangManager.get(CStrGui.SORT_TITLES[sSort]) + sort);
        tSort.setLineWrap(false);
        ResSearch.buttonMore(panel, SharedUtil.moreStr(this.mProject, panel, true, this.mIsCreatorView));
    }

    @Override
    public void resMinimal() {
        this.mTextComps = new LinkedList();
        MLayered layered = new MLayered(MPos.pos(sPanel, "||p,||p"));
        layered.setBackground(COLOR_BACKGROUND);
        this.mThumb = new MButton((MMPos)MPos.pos(layered, "[[<>256<>,[[<>150<>"), (Icon)this.mIcon).addAction(pEvent -> ViewManager.displayDetail(this.mProject));
        this.mThumb.setCursor(CSharedCon.CURSOR_HAND);
        layered.setLayer(this.mThumb, 0);
        JTextPane textPane = new JTextPane();
        textPane.setFont(MCon.fontText());
        textPane.setText(this.mProject.getTitle());
        textPane.setForeground(MCon.colorTitleText());
        textPane.setBackground(new Color(0, 0, 0, 205));
        textPane.setBounds(0, 10, 256, 10);
        int height = textPane.getPreferredSize().height + 6;
        textPane.setBounds(0, 150 - height, 256, height);
        layered.add((Component)textPane, new Integer(1));
        this.mTextComps.add(textPane);
        StyledDocument doc = textPane.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setSpaceAbove(center, 3.0f);
        StyleConstants.setLeftIndent(center, 10.0f);
        StyleConstants.setRightIndent(center, 10.0f);
        doc.setParagraphAttributes(0, doc.getLength(), center, false);
        SharedUtil.moreStr(this.mProject, layered, true, this.mIsCreatorView);
    }

    @Override
    public List<JTextComponent> highlightText() {
        return this.mTextComps;
    }
}

