/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.results;

import de.maggicraft.ism.search.IResSearch;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.menu.MPopupMenu;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MPanel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ResSearch
implements IResSearch {
    @NotNull
    public static final Color COLOR_BACKGROUND = MCon.colorButtonNormal().darker();
    @NotNull
    public static final ImageIcon ICON_DOTS = ImgUtil.getAppIcon("dots");
    @NotNull
    private static final ImageIcon ICON_DOTS_HOVER;
    static MPanel sPanel;
    static int sSort;
    static boolean sShowCreator;
    protected int mUnit;
    MButton mThumb;

    protected ResSearch(int pUnit) {
        this.mUnit = pUnit;
        this.initInfo();
    }

    static void setInfo(MPanel pPanel, int pSort, boolean pShowCreator) {
        sPanel = pPanel;
        sSort = pSort;
        sShowCreator = pShowCreator;
    }

    static void buttonMore(@NotNull MPanel pPanel, @NotNull MPopupMenu pMenu) {
        ResSearch.buttonMore(MPos.pos(pPanel, "]]p<30>,||p"), pMenu);
    }

    static void buttonMore(@NotNull MPos pPos, @NotNull MPopupMenu pMenu) {
        MTip tip = new MTip(MLangManager.get("tt.more"));
        MButton bMenu = new MButton((MMPos)pPos, (Icon)ICON_DOTS).tip(tip);
        bMenu.setRolloverIcon(ICON_DOTS_HOVER);
        bMenu.addActionListener(pEvent -> pMenu.show(bMenu, 0, 0));
    }

    public abstract void initInfo();

    @Override
    public abstract void resInit();

    @Override
    public abstract void resDetail();

    @Override
    public void mark(@NotNull String pText) {
        for (JTextComponent comp : this.highlightText()) {
            Util.removeHighlight(comp);
            Util.highlightText(comp, pText);
        }
    }

    public List<JTextComponent> highlightText() {
        return new LinkedList<JTextComponent>();
    }

    @Override
    public abstract void resMinimal();

    public int getUnit() {
        return this.mUnit;
    }

    static {
        Optional<BufferedImage> circle = ImgUtil.getAppBuffered("circle_35");
        Optional<BufferedImage> dots = ImgUtil.getAppBuffered("dots");
        if (!circle.isPresent() || !dots.isPresent()) {
            throw new NullPointerException();
        }
        BufferedImage background = ImgUtil.makeColorChanged(circle.get(), MCon.colorFrame().darker());
        ICON_DOTS_HOVER = ImgUtil.getImg(ImgUtil.makeCombined(true, background, dots.get()));
    }
}

