/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.results;

import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.local.ILocal;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.results.ResLoc;
import de.maggicraft.ism.results.ViewRes;
import de.maggicraft.ism.search.IResSearch;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.view.MScroll;
import de.maggicraft.mioutil.compr.Compressed;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class ViewLocal
extends ViewRes {
    protected ViewLocal(@NotNull MPos pPos, MScroll pScroll) {
        super(pPos, pScroll, CSettings.SETTING_VIEW_LOCALS, true);
        this.mResPerPage = (Integer)CSettings.SETTING_RES_QUANTITY.getValue();
    }

    @Override
    public void displayResPage() {
        List<ILocal> mRes = ISMContainer.getLocalManager().getLocals();
        this.mBPrevPage.setEnabled(this.mPage != 0);
        this.mBNextPage.setEnabled((this.mPage + 1) * this.mResPerPage < mRes.size());
        LinkedList<IResSearch> res = new LinkedList<IResSearch>();
        int i = 0;
        while (this.mPage * this.mResPerPage + i < mRes.size() && res.size() < this.mResPerPage) {
            if (this.mFiltered == null || this.mFiltered.get(i) == 1) {
                res.add(new ResLoc(mRes.get(i)));
            }
            ++i;
        }
        this.init(res, 0);
        this.mPages.text(MLangManager.rep("te.page", this.mPage + 1, (int)Math.ceil((double)mRes.size() / (double)this.mResPerPage)));
        this.mScroll.update();
        SwingUtilities.invokeLater(this.mScroll::scrollToTop);
    }

    @Override
    public boolean filter(@NotNull String pContent) {
        boolean filteredBefore = this.mFiltered != null;
        Compressed old = this.mFiltered;
        List<ILocal> strs = ISMContainer.getLocalManager().getLocals();
        this.mFiltered = new Compressed(strs.size(), 1);
        pContent = pContent.toLowerCase();
        int i = 0;
        for (ILocal str : strs) {
            boolean matches = str.getFileName().toLowerCase().contains(pContent);
            this.mFiltered.set(i, matches ? 1 : 0);
            ++i;
        }
        if (filteredBefore) {
            return !this.mFiltered.equals(old);
        }
        for (int j = 0; j < strs.size(); ++j) {
            if (this.mFiltered.get(i) != 0) continue;
            return true;
        }
        return false;
    }
}

