/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.results;

import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.results.MResLayout;
import de.maggicraft.ism.results.ResCol;
import de.maggicraft.ism.results.ResCre;
import de.maggicraft.ism.results.ResProject;
import de.maggicraft.ism.results.ResSearch;
import de.maggicraft.ism.search.IResSearch;
import de.maggicraft.ism.search.MFilterRes;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.settings.ISetting;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MRadio;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mgui.view.MScroll;
import de.maggicraft.mioutil.compr.Compressed;
import de.maggicraft.mthread.MasterThread;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ViewRes
extends MPanel {
    protected final MScroll mScroll;
    @NotNull
    private final MResLayout mLayout;
    @NotNull
    private final ISetting<Boolean> mLayoutID;
    private final boolean mShowCre;
    @Nullable
    protected Compressed mFiltered;
    protected MButton mBPrevPage;
    protected MButton mBNextPage;
    protected MText mPages;
    protected int mPage;
    protected int mResPerPage;
    private List<IResSearch> mSearchRes;
    private Compressed mRes;
    private Compressed mResType;
    private String mHighlightText;
    private int mWidth;
    private int mHeight;
    private int mCreQuan;
    private int mParentWidth;
    private boolean mCurLayout;
    private boolean mFilterActivated = true;

    public ViewRes(@NotNull MPos pPos, MScroll pScroll, @NotNull ISetting<Boolean> pLayoutID, boolean pShowCre) {
        super(pPos, MCon.colorFrame());
        this.mScroll = pScroll;
        this.mScroll.setMaximumSize(new Dimension(2000, 40000));
        this.mLayoutID = pLayoutID;
        this.mCurLayout = pLayoutID.getValue();
        this.mLayout = new MResLayout(this.mCurLayout);
        this.mShowCre = pShowCre;
        this.setLayout(this.mLayout);
    }

    public void init(Compressed pRes, Compressed pResType) {
        this.mRes = pRes;
        this.mResType = pResType;
        this.mResPerPage = (Integer)CSettings.SETTING_RES_QUANTITY.getValue();
        this.mPage = 0;
        this.displayResPage();
    }

    public void init(@NotNull List<IResSearch> pSearchRes, int pCreQuan) {
        this.mSearchRes = pSearchRes;
        this.mCreQuan = pCreQuan;
        MasterThread thread = new MasterThread("str-loader", 7);
        for (IResSearch res : pSearchRes) {
            thread.add(res::resInit);
        }
        this.initLayout(this.mCurLayout);
        thread.start();
    }

    private void showView(boolean pLayout) {
        if (pLayout == this.mCurLayout) {
            return;
        }
        this.initLayout(pLayout);
    }

    private void initLayout(boolean pLayout) {
        this.mScroll.setViewActivated(false);
        this.mCurLayout = pLayout;
        this.mLayoutID.setValue(this.mCurLayout);
        this.removeComps();
        this.mLayout.setResType(this.mCreQuan, pLayout);
        ResSearch.setInfo(this, this.getSort(), this.mShowCre);
        if (this.mCurLayout) {
            for (IResSearch str : this.mSearchRes) {
                str.resDetail();
            }
        } else {
            for (IResSearch str : this.mSearchRes) {
                str.resMinimal();
            }
        }
        this.actPref();
        if (this.mFiltered != null) {
            for (IResSearch res : this.mSearchRes) {
                res.mark(this.mHighlightText);
            }
        }
        this.highlight(this.mSearchRes);
        SwingUtilities.invokeLater(() -> {
            this.mScroll.setViewActivated(true);
            this.repaint();
        });
    }

    @Override
    public void setBounds(int pX, int pY, int pWidth, int pHeight) {
        super.setBounds(pX, pY, pWidth, pHeight);
        if (pWidth != this.mParentWidth) {
            this.mParentWidth = pWidth;
            this.actDim();
        }
    }

    private void actDim() {
        Dimension dim = this.mLayout.minimumLayoutSize(this);
        if (dim.width != this.mWidth || dim.height != this.mHeight) {
            this.mWidth = dim.width;
            this.mHeight = dim.height;
            if (this.getPos() != null) {
                this.getPos().setPrefHeight(this.mHeight);
            }
            this.actPrefDim(dim.width, dim.height);
        }
    }

    public void actPref() {
        Dimension dim = this.mLayout.minimumLayoutSize(this);
        this.mWidth = dim.width;
        this.mHeight = dim.height;
        if (this.getPos() != null) {
            this.getPos().setPrefHeight(this.mHeight);
        }
        this.actPrefDim(dim.width, dim.height);
    }

    protected abstract void actPrefDim(int var1, int var2);

    protected abstract int getSort();

    @Override
    public void update() {
    }

    public void buttonsResType(@NotNull MPos pPos) {
        ButtonGroup group = new ButtonGroup();
        MRadio[] buttons = new MRadio[2];
        buttons[0] = new MRadio(pPos, group){

            @Override
            public void setSelected() {
            }
        };
        buttons[0].setIcon(ViewUtil.ICON_MINIMAL_DISABLED);
        buttons[0].setSelectedIcon(ViewUtil.ICON_MINIMAL_PRESSED);
        buttons[0].setRolloverIcon(ViewUtil.ICON_MINIMAL_ROLLOVER);
        buttons[0].setDisabledIcon(ViewUtil.ICON_MINIMAL_DISABLED);
        buttons[0].setDisabledSelectedIcon(ViewUtil.ICON_MINIMAL_ENABLED);
        buttons[0].setSelected(!this.mCurLayout);
        buttons[0].addItemListener(pEvent -> this.showView(false));
        buttons[1] = new MRadio(MPos.pos("][p<5>,||<>p<>", buttons[0]), group){

            @Override
            public void setSelected() {
            }
        };
        buttons[1].setIcon(ViewUtil.ICON_DETAILED_DISABLED);
        buttons[1].setSelectedIcon(ViewUtil.ICON_DETAILED_PRESSED);
        buttons[1].setRolloverIcon(ViewUtil.ICON_DETAILED_ROLLOVER);
        buttons[1].setDisabledIcon(ViewUtil.ICON_DETAILED_DISABLED);
        buttons[1].setDisabledSelectedIcon(ViewUtil.ICON_DETAILED_ENABLED);
        buttons[1].setSelected(this.mCurLayout);
        buttons[1].addItemListener(pEvent -> this.showView(true));
        for (int i = 0; i < 2; ++i) {
            buttons[i].setBorder(new EmptyBorder(0, 0, 0, 0));
        }
    }

    public void buttonsPage(@NotNull MPos pPos) {
        this.mPages = new MText(pPos);
        this.mBPrevPage = new MButton(MPos.pos("][p,||p", this.mPages), ViewUtil.ICON_LEFT_ENABLED, ViewUtil.ICON_LEFT_ROLLOVER, ViewUtil.ICON_LEFT_PRESSED).addAction(pEvent -> {
            --this.mPage;
            this.displayResPage();
        });
        this.mBPrevPage.setDisabledIcon(ViewUtil.ICON_LEFT_DISABLED);
        this.mBNextPage = new MButton(MPos.pos("[]p,||p", this.mPages), ViewUtil.ICON_RIGHT_ENABLED, ViewUtil.ICON_RIGHT_ROLLOVER, ViewUtil.ICON_RIGHT_PRESSED).addAction(pEvent -> {
            ++this.mPage;
            this.displayResPage();
        });
        this.mBNextPage.setDisabledIcon(ViewUtil.ICON_RIGHT_DISABLED);
    }

    public void displayResPage() {
        int creQuan = 0;
        LinkedList<IResSearch> res = new LinkedList<IResSearch>();
        int i = 0;
        while (this.mPage * this.mResPerPage + i < this.mRes.size() && res.size() < this.mResPerPage) {
            if (this.mFiltered == null || this.mFiltered.get(i) == 1) {
                int resType;
                boolean isCre;
                int gunit = this.mPage * this.mResPerPage + i;
                int unit = this.mRes.get(gunit);
                boolean bl = isCre = this.mResType != null && this.mResType.get(gunit) == 1;
                if (isCre) {
                    ++creQuan;
                }
                int n = resType = isCre ? 2 : MData.projectType(unit);
                if (resType == 0) {
                    res.add(new ResProject(unit, false));
                } else if (resType == 1) {
                    res.add(new ResCol(unit, false));
                } else {
                    res.add(new ResCre(unit));
                }
            }
            ++i;
        }
        this.init(res, creQuan);
        int results = 0;
        if (this.mFiltered == null) {
            results = this.mRes.size();
        } else {
            for (int i2 = 0; i2 < this.mFiltered.size(); ++i2) {
                if (this.mFiltered.get(i2) != 1) continue;
                ++results;
            }
        }
        if (results == 0) {
            this.showNoResults();
        } else {
            this.showResults();
        }
        this.highlight(res);
        this.mBPrevPage.setEnabled(this.mPage != 0);
        this.mBNextPage.setEnabled((this.mPage + 1) * this.mResPerPage < results);
        int maxPage = (int)Math.ceil((double)results / (double)this.mResPerPage);
        this.mPages.text(MLangManager.rep("te.page", this.mPage + 1, maxPage));
        this.mScroll.update();
        SwingUtilities.invokeLater(this.mScroll::scrollToTop);
    }

    protected void showNoResults() {
    }

    protected void showResults() {
    }

    protected void highlight(List<IResSearch> pSearchRes) {
    }

    public boolean filter(@NotNull String pContent) {
        Compressed old = this.mFiltered == null ? this.mRes : this.mFiltered;
        this.mFiltered = MFilterRes.filter(pContent, this.mRes);
        return !this.mFiltered.equals(old);
    }

    public void setPage(int pPage) {
        this.mPage = pPage;
    }

    public String getHighlightText() {
        return this.mHighlightText;
    }

    public void setHighlightText(String pHighlightText) {
        this.mHighlightText = pHighlightText;
    }

    public List<IResSearch> getSearchRes() {
        return this.mSearchRes;
    }

    public Compressed getRes() {
        return this.mRes;
    }

    public void resetFilter() {
        this.mFiltered = null;
    }

    public boolean isFilterActivated() {
        return this.mFilterActivated;
    }

    public void setFilterActivated(boolean pFilterActivated) {
        this.mFilterActivated = pFilterActivated;
    }
}

