/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.scan_creators;

import de.maggicraft.ism.scan_creators.IScanCreator;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public class ScanCreator
implements IScanCreator {
    @NotNull
    private final String mName;
    @NotNull
    private final String mURL;

    public ScanCreator(@NotNull String pName, @NotNull String pURL) {
        this.mName = pName;
        this.mURL = pURL;
    }

    public ScanCreator(@NotNull JSONObject pJSON) {
        this.mName = ReadableUtil.getString(pJSON, EStructureKeys.NAME);
        this.mURL = ReadableUtil.getString(pJSON, EStructureKeys.URL);
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        StorableUtil.put(json, (IUniqueID<String>)EStructureKeys.NAME, this.mName);
        StorableUtil.put(json, (IUniqueID<String>)EStructureKeys.URL, this.mURL);
        return json;
    }

    public String toString() {
        return "ScanCreator{mName='" + this.mName + '\'' + ", mURL='" + this.mURL + '\'' + '}';
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        ScanCreator that = (ScanCreator)pO;
        return this.mName.equals(that.mName) && this.mURL.equals(that.mURL);
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mURL);
    }

    @Override
    @NotNull
    public String getName() {
        return this.mName;
    }

    @Override
    @NotNull
    public String getURL() {
        return this.mURL;
    }

    public static enum EStructureKeys implements IUID
    {
        NAME("nme"),
        URL("url");

        @NotNull
        private final String mUID;

        private EStructureKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

