/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.scan_creators;

import de.maggicraft.ism.scan_creators.IScanCreator;
import de.maggicraft.ism.scan_creators.IScanCreatorsManager;
import de.maggicraft.ism.scan_creators.ScanCreator;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mioutil.json.IReadableManager;
import de.maggicraft.mioutil.json.IStorableManager;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ScanCreatorManager
implements IStorableManager<IScanCreator>,
IScanCreatorsManager,
IReadableManager {
    @NotNull
    protected static final String FILE_JSON = "creators.json";
    private static final String VERSION = "1";
    protected List<IScanCreator> mCreators;
    protected List<Runnable> mActions;
    protected File mFile;

    @Override
    public void initialize() {
        this.mFile = new File(MCon.appFolder(), FILE_JSON);
        if (this.mFile.exists()) {
            this.read();
        } else {
            this.mCreators = new ArrayList<IScanCreator>(2);
        }
        this.mActions = new LinkedList<Runnable>();
    }

    @Override
    public void readEntities(@NotNull JSONArray pJSONArray) {
        this.mCreators = new ArrayList<IScanCreator>(pJSONArray.size() + 2);
        for (Object object : pJSONArray) {
            ScanCreator creator = new ScanCreator((JSONObject)object);
            this.mCreators.add(creator);
        }
    }

    @Override
    public void storeHeader(@NotNull JSONObject pJSON) {
        StorableUtil.put(pJSON, (IUniqueID<String>)EKeysScanCreators.VERSION, VERSION);
    }

    @Override
    public void readHeader(@NotNull JSONObject pJSON) {
        String version = ReadableUtil.getString(pJSON, EKeysScanCreators.VERSION);
        if (!version.equals(VERSION)) {
            throw new IllegalArgumentException("version \"" + version + "\" not support");
        }
    }

    @Override
    public void addCreator(@NotNull IScanCreator pCreator) {
        this.mCreators.add(pCreator);
        for (Runnable action : this.mActions) {
            action.run();
        }
        this.store();
    }

    @Override
    public void editCreator(int pIndex, @NotNull String pName, @NotNull String pURL) {
        this.mCreators.set(pIndex, new ScanCreator(pName, pURL));
        this.store();
    }

    @Override
    public void remove(int pIndex) {
        this.mCreators.remove(pIndex);
        for (Runnable action : this.mActions) {
            action.run();
        }
        this.store();
    }

    @Override
    @NotNull
    public String[] comboNames() {
        String[] names = new String[this.mCreators.size() + 1];
        names[0] = MLangManager.get("choCre");
        int i = 1;
        for (IScanCreator creator : this.mCreators) {
            names[i] = creator.getName();
            ++i;
        }
        return names;
    }

    @Override
    @NotNull
    public String[] getNames() {
        String[] names = new String[this.mCreators.size()];
        int i = 0;
        for (IScanCreator creator : this.mCreators) {
            names[i] = creator.getName();
            ++i;
        }
        return names;
    }

    @Override
    public void addAction(@NotNull Runnable pAction) {
        this.mActions.add(pAction);
    }

    @Override
    public void removeAction(@NotNull Runnable pAction) {
        this.mActions.remove(pAction);
    }

    @Override
    public void clearActions() {
        this.mActions = new LinkedList<Runnable>();
    }

    @Override
    @NotNull
    public IScanCreator get(int pIndex) {
        return this.mCreators.get(pIndex);
    }

    @Override
    public int size() {
        return this.mCreators.size();
    }

    @Override
    public boolean contains(@NotNull String pCreatorName) {
        for (IScanCreator creator : this.mCreators) {
            if (!creator.getName().equals(pCreatorName)) continue;
            return true;
        }
        return false;
    }

    public List<IScanCreator> getCreators() {
        return this.mCreators;
    }

    @Override
    @NotNull
    public Collection<IScanCreator> getStorables() {
        return this.mCreators;
    }

    @Override
    @NotNull
    public File getFile() {
        return this.mFile;
    }

    public static enum EKeysScanCreators implements IUID
    {
        VERSION("vers");

        @NotNull
        private final String mUID;

        private EKeysScanCreators(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

