/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.search;

import de.maggicraft.ism.database.MData;
import de.maggicraft.mioutil.compr.Compressed;
import org.jetbrains.annotations.NotNull;

public final class MFilterRes {
    private MFilterRes() {
    }

    @NotNull
    public static Compressed filter(@NotNull String pContent, @NotNull Compressed pPIDs) {
        if (pContent.isEmpty()) {
            return pPIDs;
        }
        pContent = pContent.toLowerCase();
        Compressed compressed = new Compressed(pPIDs.size(), 1);
        for (int i = 0; i < pPIDs.size(); ++i) {
            compressed.set(i, MFilterRes.matches(pContent, pPIDs.get(i)) ? 1 : 0);
        }
        return compressed;
    }

    private static boolean matches(@NotNull String pContent, int pCID) {
        return MFilterRes.matchesTitle(pContent, pCID) || MFilterRes.matchesCreator(pContent, pCID) || MFilterRes.matchesTag(pContent, pCID) || MFilterRes.matchesURL(pContent, pCID);
    }

    private static boolean matchesTitle(@NotNull String pContent, int pCID) {
        return MData.projectTitle(pCID).toLowerCase().contains(pContent);
    }

    private static boolean matchesCreator(@NotNull String pContent, int pCID) {
        return MData.creatorName(MData.creatorUnitByProject(pCID)).toLowerCase().contains(pContent);
    }

    private static boolean matchesTag(@NotNull String pContent, int pCID) {
        return MData.projectTags(pCID).contains(pContent);
    }

    private static boolean matchesURL(@NotNull String pContent, int pCID) {
        return MData.projectURL(pCID).toLowerCase().contains(pContent);
    }
}

