/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.search;

import de.maggicraft.ism.analytics.util.ESearchMode;
import de.maggicraft.ism.database.DataProjects;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.search.FillList;
import de.maggicraft.ism.search.SearchManager;
import de.maggicraft.ism.search.SearchUtil;
import de.maggicraft.ism.search.SortEntry;
import de.maggicraft.mgui.listener.CompBool;
import de.maggicraft.mgui.listener.CompInt;
import de.maggicraft.mioutil.compr.Compressed;
import de.maggicraft.mioutil.compr.CompressedText;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Search {
    private static final int[] BLOCKS = new int[]{0, 1000, 10000, 100000, 1000000, 10000000, Integer.MAX_VALUE};
    private static final int[] AREA = new int[]{0, 100, 750, 2500, 10000, 100000, Integer.MAX_VALUE};
    private static final int[] DIMENSION = new int[]{0, 13, 37, 67, 134, 424, Integer.MAX_VALUE};
    private static final float STRS_MEAN = 2.0f;
    private static final int RDM_RES_QUAN = 2500;
    private static final FillList[] SORT = new FillList[]{pPID -> pPID, pPID -> {
        String[] structures;
        int blocks = 0;
        for (String str : structures = MData.projectStructures(pPID)) {
            blocks += Integer.parseInt(str.split("\ufffb")[0]);
        }
        return blocks / structures.length;
    }, pPID -> {
        String[] structures;
        int area = 0;
        for (String str : structures = MData.projectStructures(pPID)) {
            String part = str.split("\ufffb")[1];
            area += part.charAt(0) * part.charAt(2);
        }
        return area / structures.length;
    }, MData::projectDownloads, MData::projectViews, MData::projectFavorites, MData::projectDiamonds, MData::projectComments, pPID -> Integer.parseInt(MData.projectUpdatedRaw(pPID)), pPID -> Integer.parseInt(MData.projectPostedRaw(pPID))};

    private Search() {
    }

    public static void search(@NotNull SearchManager pManager, @NotNull String pText, @NotNull CompInt pSource, @NotNull ESearchMode pSearchMode, @NotNull CompInt pBlocks, @NotNull CompInt pArea, @NotNull CompInt pSort, @NotNull CompBool pDesc) {
        List<Integer> strs;
        List<Integer> cres;
        boolean sCre = pText.startsWith("[creator]");
        boolean sTag = pText.startsWith("[tag]");
        if ((sCre || sTag) && !(pText = sCre ? pText.substring("[creator]".length()) : pText.substring("[tag]".length())).isEmpty()) {
            int i;
            if (pText.charAt(0) == ':') {
                pText = pText.substring(1);
            }
            for (i = 0; i < pText.length() && pText.charAt(i) == ' '; ++i) {
            }
            if (i > 0) {
                pText = pText.substring(i);
            }
        }
        boolean sAll = pText.startsWith("[all]");
        boolean sRdm = pText.startsWith("[random]");
        pText = sAll || sRdm ? null : pText.toLowerCase();
        if (sCre) {
            cres = Search.searchCres(pText, ESearchMode.SEARCH_CRES, true, false, -1);
            strs = Search.searchCresStrs(cres, pSearchMode, pBlocks.getValue(), pArea.getValue());
            if (pSearchMode != ESearchMode.SEARCH_CRES && pSearchMode != ESearchMode.SEARCH_ALL) {
                cres = new LinkedList<Integer>();
            }
        } else if (sTag) {
            strs = Search.search(pText, pSearchMode, pBlocks.getValue(), pArea.getValue(), false, DataProjects.getTags());
            cres = new LinkedList<Integer>();
        } else {
            strs = Search.search(pText, pSource.getValue(), pSearchMode, pBlocks.getValue(), pArea.getValue(), sAll, sRdm);
            int strsPool = strs.size();
            if (sRdm) {
                strs = Search.rdmStrs(strs, pSearchMode);
            }
            cres = Search.searchCres(pText, pSearchMode, sAll, sRdm, strsPool);
        }
        strs = Search.sortStrs(strs, pSort.getValue(), pDesc.isValue(), sRdm);
        cres = Search.sortCres(cres, pSort.getValue(), pDesc.isValue());
        Search.merge(pManager, strs, cres);
    }

    @NotNull
    private static List<Integer> searchCres(String pText, ESearchMode pSearchMode, boolean pAll, boolean pRdm, int pStrsPool) {
        if (pRdm && pAll) {
            throw new IllegalArgumentException();
        }
        if (pSearchMode == ESearchMode.SEARCH_STRS || pSearchMode == ESearchMode.SEARCH_COLS) {
            return new LinkedList<Integer>();
        }
        if (pRdm) {
            int quan = (int)Math.round((double)MData.creatorQuantity() / (double)(2.0f * (float)pStrsPool + (float)MData.creatorQuantity()) * 2500.0);
            int[] distr = SearchUtil.shuffledDistribution(quan, MData.creatorQuantity());
            ArrayList<Integer> list = new ArrayList<Integer>(quan);
            for (int i : distr) {
                list.add(i);
            }
            return list;
        }
        if (pAll) {
            ArrayList<Integer> creators = new ArrayList<Integer>();
            for (int i = 0; i < MData.creatorQuantity(); ++i) {
                creators.add(i);
            }
            return creators;
        }
        LinkedList<Integer> units = new LinkedList<Integer>();
        for (int i = 0; i < MData.creatorQuantity(); ++i) {
            if (!MData.creatorName(i).toLowerCase().contains(pText)) continue;
            units.add(i);
        }
        return units;
    }

    @NotNull
    private static LinkedList<Integer> searchCresStrs(@NotNull List<Integer> pCre, @NotNull ESearchMode pSearchMode, int pBlocks, int pArea) {
        int[] minMax = Search.minMaxBlocks(pBlocks);
        LinkedList<Integer> pStrs = new LinkedList<Integer>();
        int[] area = Search.minMaxArea(pArea);
        for (Integer cre : pCre) {
            int[] strUnits;
            for (int strUnit : strUnits = MData.creatorStructuresArr(cre)) {
                if (!Search.matchesSearchMode(strUnit, pSearchMode) || !Search.matchesBlocks(strUnit, minMax[0], minMax[1]) || !Search.matchesArea(strUnit, area[0], area[1], area[2], area[3])) continue;
                pStrs.add(strUnit);
            }
        }
        return pStrs;
    }

    @NotNull
    private static LinkedList<Integer> search(String pText, @NotNull ESearchMode pSearchMode, int pBlocks, int pArea, boolean pAll, CompressedText ... pSrc) {
        int[] minMax = Search.minMaxBlocks(pBlocks);
        LinkedList<Integer> pids = new LinkedList<Integer>();
        block0: for (int i = 0; i < MData.projectQuantity(); ++i) {
            int[] area = Search.minMaxArea(pArea);
            if (!Search.matchesSearchMode(i, pSearchMode) || !Search.matchesBlocks(i, minMax[0], minMax[1]) || !Search.matchesArea(i, area[0], area[1], area[2], area[3])) continue;
            if (pAll) {
                pids.add(i);
                continue;
            }
            for (CompressedText compr : pSrc) {
                if (!compr.get(i).toLowerCase().contains(pText)) continue;
                pids.add(i);
                continue block0;
            }
        }
        return pids;
    }

    private static List<Integer> search(String pText, int pSource, @NotNull ESearchMode pSearchMode, int pBlocks, int pArea, boolean pAll, boolean pRdm) {
        LinkedList<Integer> pids;
        if (pSearchMode == ESearchMode.SEARCH_CRES) {
            return new LinkedList<Integer>();
        }
        pAll |= pRdm;
        if (pSource == 0) {
            pids = Search.search(pText, pSearchMode, pBlocks, pArea, pAll, DataProjects.getTitles(), DataProjects.getTags(), DataProjects.getURL());
        } else if (pSource == 1) {
            pids = Search.search(pText, pSearchMode, pBlocks, pArea, pAll, DataProjects.getTitles());
        } else if (pSource == 2) {
            pids = Search.search(pText, pSearchMode, pBlocks, pArea, pAll, DataProjects.getTags());
        } else if (pSource == 3) {
            pids = Search.search(pText, pSearchMode, pBlocks, pArea, pAll, DataProjects.getURL());
        } else {
            throw new IllegalArgumentException("unknown source");
        }
        return pids;
    }

    @NotNull
    private static List<Integer> rdmStrs(@NotNull List<Integer> pList, ESearchMode pSearchMode) {
        int quan = pSearchMode == ESearchMode.SEARCH_STRS || pSearchMode == ESearchMode.SEARCH_COLS ? 2500 : (int)Math.round(2.0 * (double)pList.size() / (double)(2.0f * (float)pList.size() + (float)MData.creatorQuantity()) * 2500.0);
        quan = Math.min(quan, pList.size());
        int[] distr = SearchUtil.shuffledDistribution(quan, pList.size());
        ArrayList<Integer> strs = new ArrayList<Integer>(distr.length);
        for (int i : distr) {
            strs.add(pList.get(i));
        }
        return strs;
    }

    @NotNull
    private static List<Integer> sortStrs(@NotNull List<Integer> pList, int pSort, boolean pDesc, boolean pRdm) {
        if (pRdm) {
            return pList;
        }
        if (pSort == 0) {
            if (pDesc) {
                return pList;
            }
            pDesc = true;
        }
        ArrayList<SortEntry> sorted = new ArrayList<SortEntry>(pList.size());
        for (Integer unit : pList) {
            sorted.add(new SortEntry(unit, SORT[pSort].get(unit)));
        }
        return Search.sortConvert(sorted, pDesc);
    }

    @NotNull
    private static List<Integer> sortCres(@NotNull List<Integer> pList, int pSort, boolean pDesc) {
        if (pSort == 0) {
            if (pDesc) {
                return pList;
            }
            pDesc = true;
        }
        ArrayList<SortEntry> sorted = new ArrayList<SortEntry>(pList.size());
        for (Integer unit : pList) {
            int[] strUnits = MData.creatorStructuresArr(unit);
            int value = 0;
            for (int strUnit : strUnits) {
                value += SORT[pSort].get(strUnit);
            }
            sorted.add(new SortEntry(unit, value));
        }
        return Search.sortConvert(sorted, pDesc);
    }

    private static void merge(@NotNull SearchManager pManager, @NotNull List<Integer> pStrs, @NotNull List<Integer> pCres) {
        int resQuan = pStrs.size() + pCres.size();
        int max = 0;
        for (Integer str : pStrs) {
            if (str <= max) continue;
            max = str;
        }
        for (Integer cre : pCres) {
            if (cre <= max) continue;
            max = cre;
        }
        Compressed res = new Compressed(resQuan, Integer.toBinaryString(max).length());
        Compressed resType = new Compressed(resQuan, 1);
        double ratStrs = (double)pStrs.size() / (double)resQuan;
        double ratCres = (double)pCres.size() / (double)resQuan;
        int addedStr = 0;
        int addedCre = 0;
        int added = 0;
        int i = 0;
        while (added < resQuan) {
            if ((double)(++i - addedStr) * ratStrs < (double)(i - addedCre) * ratCres) {
                res.set(added, (int)pCres.get(addedCre));
                resType.set(added, 1);
                ++addedCre;
                ++added;
                continue;
            }
            res.set(added, (int)pStrs.get(addedStr));
            resType.set(added, 0);
            ++addedStr;
            ++added;
        }
        pManager.setSearchRes(res, resType);
    }

    @NotNull
    private static int[] minMaxBlocks(int pBlocks) {
        if (pBlocks == 0) {
            return new int[]{BLOCKS[0], BLOCKS[BLOCKS.length - 1]};
        }
        return new int[]{BLOCKS[pBlocks - 1], BLOCKS[pBlocks]};
    }

    @NotNull
    private static int[] minMaxArea(int pArea) {
        if (pArea == 0) {
            return new int[]{AREA[0], AREA[AREA.length - 1], DIMENSION[0], DIMENSION[DIMENSION.length - 1]};
        }
        return new int[]{AREA[pArea - 1], AREA[pArea], DIMENSION[pArea - 1], DIMENSION[pArea]};
    }

    private static boolean matchesSearchMode(int pPID, @NotNull ESearchMode pSearchMode) {
        return pSearchMode == ESearchMode.SEARCH_ALL || pSearchMode.getUID() - 1 == MData.projectType(pPID);
    }

    private static boolean matchesBlocks(int pPID, int pMin, int pMax) {
        String[] structures;
        if (pMin == BLOCKS[0] && pMax == BLOCKS[BLOCKS.length - 1]) {
            return true;
        }
        for (String str : structures = MData.projectStructures(pPID)) {
            int blocks = Integer.parseInt(str.split("\ufffb")[0]);
            if (pMin > blocks || blocks >= pMax) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesArea(int pPID, int pMinArea, int pMaxArea, int pMinDim, int pMaxDim) {
        String[] structures;
        if (pMinArea == AREA[0] && pMaxArea == AREA[AREA.length - 1] && pMinDim == DIMENSION[0] && pMaxDim == DIMENSION[DIMENSION.length - 1]) {
            return true;
        }
        for (String str : structures = MData.projectStructures(pPID)) {
            char length;
            String part = str.split("\ufffb")[1];
            char width = part.charAt(0);
            int area = width * (length = part.charAt(2));
            if (!(pMinArea <= area && area < pMaxArea || pMinDim <= width && width < pMaxDim) && (pMinDim > length || length >= pMaxDim)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<Integer> sortConvert(@NotNull ArrayList<SortEntry> pSorted, boolean pDesc) {
        pSorted.sort(pDesc ? SortEntry.compIntDesc() : SortEntry.compIntAsc());
        ArrayList<Integer> sortedUnits = new ArrayList<Integer>(pSorted.size());
        for (SortEntry sortEntry : pSorted) {
            sortedUnits.add(sortEntry.getUnit());
        }
        return sortedUnits;
    }

    public static void rdmSearch(@NotNull String pText, @NotNull CompInt pSource, @NotNull CompInt pBlocks, @NotNull CompInt pArea) {
        int unit;
        boolean cre;
        int rdm = SearchUtil.RDM.nextInt(MData.creatorQuantity() + MData.projectQuantity());
        boolean bl = cre = rdm < MData.creatorQuantity();
        if (pText.isEmpty()) {
            unit = SearchUtil.RDM.nextInt(cre ? MData.creatorQuantity() : MData.projectQuantity());
        } else {
            List<Integer> result = cre ? Search.searchCres(pText, ESearchMode.SEARCH_CRES, false, false, -1) : Search.search(pText, pSource.getValue(), ESearchMode.SEARCH_ALL, pBlocks.getValue(), pArea.getValue(), false, false);
            unit = result.get(SearchUtil.RDM.nextInt(result.size()));
        }
        if (cre) {
            ViewManager.displayDetail(MData.getCreator(unit));
        } else {
            IProject project = MData.projectIsCollection(unit) ? MData.getCollection(unit) : MData.getProject(unit);
            ViewManager.displayDetail(project);
        }
    }
}

