/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.search;

import de.maggicraft.ism.analytics.trackers.TrackSearch;
import de.maggicraft.ism.analytics.util.ESearchMode;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.search.Search;
import de.maggicraft.ism.views.MViewSearchRes;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.listener.CompBool;
import de.maggicraft.mgui.listener.CompInt;
import de.maggicraft.mioutil.compr.Compressed;
import org.jetbrains.annotations.NotNull;

public class SearchManager {
    public final CompInt mSetSrc = new CompInt(0);
    public final CompInt mSetBlocks = new CompInt(0);
    public final CompInt mSetArea = new CompInt(0);
    public final CompInt mSetSort = new CompInt(0);
    public final CompBool mSetSortDesc = new CompBool(true);
    private ESearchMode mMode;
    private Compressed mRes;
    private Compressed mResType;
    private String mLastTag;
    private String mQuery;

    public void searchTag(@NotNull MViewSearchRes pView, @NotNull String pTag) {
        this.mLastTag = pTag;
        this.mQuery = pTag;
        this.preSearch(pView, ESearchMode.SEARCH_ALL);
        this.mMode = ESearchMode.SEARCH_ALL;
        this.mSetSrc.setValue(2);
        this.mSetBlocks.setValue(0);
        this.mSetArea.setValue(0);
        long time = System.currentTimeMillis();
        Search.search(this, this.mQuery, this.mSetSrc, this.mMode, this.mSetBlocks, this.mSetArea, this.mSetSort, this.mSetSortDesc);
        time = System.currentTimeMillis() - time;
        this.postSearch(pView, time);
        TrackSearch.trackSearch(pTag, this.mMode, true, this.mSetSrc.getValue(), this.mSetBlocks.getValue(), this.mSetArea.getValue(), this.mSetSort.getValue(), this.mSetSortDesc.isValue(), this.mRes.size(), (int)time);
    }

    public void search(@NotNull MViewSearchRes pView, @NotNull String pQuery, @NotNull ESearchMode pMode) {
        this.mQuery = pQuery;
        this.mMode = pMode;
        this.preSearch(pView, pMode);
        long time = System.currentTimeMillis();
        Search.search(this, this.mQuery, this.mSetSrc, this.mMode, this.mSetBlocks, this.mSetArea, this.mSetSort, this.mSetSortDesc);
        time = System.currentTimeMillis() - time;
        this.postSearch(pView, time);
        TrackSearch.trackSearch(pQuery, pMode, pQuery.equals(this.mLastTag), this.mSetSrc.getValue(), this.mSetBlocks.getValue(), this.mSetArea.getValue(), this.mSetSort.getValue(), this.mSetSortDesc.isValue(), this.mRes.size(), (int)time);
    }

    private void preSearch(@NotNull MViewSearchRes pView, @NotNull ESearchMode pMode) {
        ViewManager.displayLeftMenu(pView, pMode.getUID());
        pView.getFieldSearch().text(this.mQuery);
        if (pView.getNoResults() != null) {
            pView.setVisible(true);
        }
        MField field = ISMContainer.getStrExplorer().getMainMenu().getSearchField();
        field.setText(this.mQuery);
        field.updatePrefWidth();
    }

    private void postSearch(@NotNull MViewSearchRes pView, long pTime) {
        pView.getResStats().text(MLangManager.rep("te.stats", CommonUtil.decMark(this.mRes.size()), (double)pTime / 1000.0));
        pView.getSearchRes().init(this.mRes, this.mResType);
    }

    public void resetSettings() {
        this.mMode = ESearchMode.SEARCH_ALL;
        this.mSetSrc.setValue(0);
        this.mSetBlocks.setValue(0);
        this.mSetArea.setValue(0);
        this.mSetSort.setValue(0);
        this.mSetSortDesc.setValue(true);
    }

    void setSearchRes(Compressed pRes, Compressed pResType) {
        this.mRes = pRes;
        this.mResType = pResType;
    }

    public String getQuery() {
        return this.mQuery;
    }

    public ESearchMode getMode() {
        return this.mMode;
    }
}

