/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.search;

import java.util.Random;
import org.jetbrains.annotations.NotNull;

public final class SearchUtil {
    @NotNull
    public static final Random RDM = new Random();
    private static final double LAMBDA = 3.0;
    private static final int SHUFFLE_WEIGHT = 10;

    private SearchUtil() {
    }

    @NotNull
    public static int[] shuffledDistribution(int pQuan, int pPool) {
        int[] distr = SearchUtil.distribution(pQuan, pPool);
        SearchUtil.weightedShuffle(distr);
        return distr;
    }

    @NotNull
    public static int[] distribution(int pQuan, int pPool) {
        if (pQuan > pPool) {
            throw new IllegalArgumentException("more requested values than possible ones");
        }
        boolean[] distr = new boolean[pPool];
        for (int i = 0; i < pQuan; ++i) {
            int rdm = SearchUtil.nextExp(pPool, RDM.nextDouble());
            while (distr[rdm % distr.length]) {
                ++rdm;
            }
            distr[rdm % distr.length] = true;
        }
        int[] distrExp = new int[pQuan];
        int j = 0;
        for (int i = 0; i < distr.length; ++i) {
            if (!distr[i]) continue;
            distrExp[j] = i;
            ++j;
        }
        return distrExp;
    }

    public static int nextExp(double pPool, double pRdm) {
        return (int)Math.round(pPool * -Math.log(1.0 - (1.0 - Math.exp(-3.0)) * pRdm) / 3.0);
    }

    public static void weightedShuffle(@NotNull int[] pArr) {
        for (int i = pArr.length - 1; i > 0; --i) {
            int index = (i + RDM.nextInt(10)) % pArr.length;
            int a = pArr[index];
            pArr[index] = pArr[i];
            pArr[i] = a;
        }
    }
}

