/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.storage;

import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mcommons.util.EOSType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.SSLHandshakeException;
import org.jetbrains.annotations.NotNull;

public final class Converter {
    private Converter() {
    }

    public static void downloadFile(@NotNull File pFile, @NotNull URL pURL) throws StorageException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)pURL.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.76");
            Converter.processDownload(pFile, connection);
        }
        catch (SSLHandshakeException pE) {
            Converter.handleSSLHandshakeException(pFile, pURL, pE);
        }
        catch (UnknownHostException pE) {
            Converter.handleUnknownHostException(pURL, pE);
        }
        catch (Exception pE) {
            throw new StorageException(EStorageException.CONVERT_DEFAULT, "unknown exception", pE);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static void processDownload(@NotNull File pFile, @NotNull HttpURLConnection pConnection) throws IOException {
        pFile.getParentFile().mkdirs();
        try (InputStream inputStream = pConnection.getInputStream();
             FileOutputStream outputStream = new FileOutputStream(pFile);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
        }
    }

    private static void handleSSLHandshakeException(@NotNull File pFile, @NotNull URL pURL, @NotNull SSLHandshakeException pE) throws StorageException {
        if (EOSType.getOperatingSystem() == EOSType.OS_WINDOWS) {
            ISMContainer.getLogger().log("treated: ", pE);
            try {
                String execute = "Invoke-WebRequest " + pURL + " -O " + '\"' + pFile.getAbsolutePath() + '\"';
                Converter.execute("powershell", execute);
            }
            catch (IOException | InterruptedException pE1) {
                ISMContainer.getLogger().log("download with cmd failed: ", pE1);
                String message = "treated - no certificate: " + pURL;
                throw new StorageException(EStorageException.CONVERT_NO_CERTIFICATE, message, pE1);
            }
        } else {
            ISMContainer.getLogger().log("not treated: ", pE);
            String message = "not treated - no certificate: " + pURL;
            throw new StorageException(EStorageException.CONVERT_NO_CERTIFICATE, message, pE);
        }
    }

    private static void execute(String ... pCommands) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(new String[]{"cmd"});
        try (PrintWriter exec = new PrintWriter(process.getOutputStream());){
            for (String command : pCommands) {
                exec.println(command);
            }
        }
        process.waitFor();
    }

    private static void handleUnknownHostException(@NotNull URL pURL, @NotNull UnknownHostException pE) throws StorageException {
        ISMContainer.getLogger().log(pE);
        try {
            Process process = Runtime.getRuntime().exec("ping instant-structures-mod.com");
            int result = process.waitFor();
            if (result == 0) {
                throw new StorageException(EStorageException.CONVERT_NO_ACCESS, "no access to: " + pURL);
            }
            String message = "no internet connection: ";
            throw new StorageException(EStorageException.CONVERT_NO_INTERNET_CONNECTION, message);
        }
        catch (IOException | InterruptedException pE1) {
            ISMContainer.getLogger().log(pE1);
            throw new StorageException(EStorageException.CONVERT_DEFAULT, "no access check exception", pE1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Set<String> decompress(@NotNull File pFolder, @NotNull File pZip) throws StorageException {
        if (!pFolder.exists()) {
            pFolder.mkdirs();
        }
        try (ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(pZip)));){
            ZipEntry ze;
            HashSet<String> map = new HashSet<String>();
            while ((ze = zin.getNextEntry()) != null) {
                Optional<String> name = Converter.getName(ze.getName());
                if (!name.isPresent()) continue;
                File output = new File(pFolder, name.get() + ".schematic");
                Converter.decompress(zin, output);
                map.add(name.get());
            }
            HashSet<String> hashSet = map;
            return hashSet;
        }
        catch (IOException pE) {
            ISMContainer.getLogger().log(pE);
            throw new StorageException(EStorageException.ZIP_EXCEPTION, "folder: " + pFolder.getName(), pE);
        }
    }

    @NotNull
    private static Optional<String> getName(@NotNull String pRawName) {
        if (pRawName.endsWith(".schematic")) {
            String name = pRawName;
            name = name.substring(name.lastIndexOf(47) + 1);
            if (pRawName.startsWith("__MACOSX") && name.startsWith("._")) {
                return Optional.empty();
            }
            return Optional.of(MFilter.validateFilename(Converter.removeSchematic(name)));
        }
        return Optional.empty();
    }

    private static void decompress(@NotNull ZipInputStream pZip, @NotNull File pOutput) throws StorageException {
        try (FileOutputStream out = new FileOutputStream(pOutput);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = pZip.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException pE) {
            ISMContainer.getLogger().log(pE);
            throw new StorageException(EStorageException.DECOMPRESS_ZIP_FILE, "output: " + pOutput.getName(), pE);
        }
    }

    @NotNull
    private static String removeSchematic(@NotNull String pStr) {
        if (pStr.endsWith(".schematic")) {
            return pStr.substring(0, pStr.length() - ".schematic".length());
        }
        return pStr;
    }
}

