/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.storage;

import de.maggicraft.ism.analytics.trackers.IDownloadTracker;
import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.gui.MViewStatus;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.IStorageCollection;
import de.maggicraft.ism.storage.IStorageCreator;
import de.maggicraft.ism.storage.IStorageStructure;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageProjectBase;
import de.maggicraft.ism.storage.StorageStructure;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.mcommons.util.MTuple;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class StorageCollection
extends StorageProjectBase
implements IStorageCollection {
    @NotNull
    private final ConcurrentMap<String, IStorageStructure> mStructures;

    public StorageCollection(@NotNull IStorageCreator pCreator, @NotNull ICollection pProject) {
        super(pCreator, pProject);
        this.mStructures = new ConcurrentHashMap<String, IStorageStructure>(pProject.getQuan());
    }

    public StorageCollection(@NotNull IStorageCreator pCreator, @NotNull JSONObject pJSON) throws StorageException {
        super(pCreator, pJSON);
        JSONArray array = ReadableUtil.getArray(pJSON, StorageProjectBase.EStorageProjectBase.STRUCTURES);
        this.mStructures = new ConcurrentHashMap<String, IStorageStructure>(array.size());
        for (Object json : array) {
            StorageStructure structure = new StorageStructure((JSONObject)json, this);
            this.mStructures.put(structure.getName(), structure);
        }
    }

    @Override
    public void downloadConvert(@NotNull IDownloadTracker pTracker, @NotNull Set<String> pStructureNames) throws StorageException {
        MTuple<String, String> tuple = this.urlFileName();
        this.convertZIP(pTracker, tuple.getA(), tuple.getB(), pStructureNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initStrs(@NotNull IDownloadTracker pTracker, @NotNull Set<String> pMap, @NotNull File pFolderSchematics, @NotNull Set<String> pNames) throws StorageException {
        long timeConvert = System.currentTimeMillis();
        int converted = 1;
        HashSet<String> added = new HashSet<String>(pNames.size());
        for (String name : pNames) {
            try {
                if (!pMap.contains(name)) {
                    String message = "zip of project with PID " + this.getPID() + " doesn't contain a structure with name \"" + name + '\"';
                    throw new StorageException(EStorageException.NO_MATCHING_STRUCTURE, message);
                }
                this.processStr(pTracker, pFolderSchematics, name);
                ++converted;
            }
            finally {
                MViewStatus.downloadAdded();
                added.add(name);
            }
        }
        pNames.removeAll(added);
        StorageUtil.deleteRemaining(pNames, pFolderSchematics);
        pTracker.setStructuresConverted(converted);
        pTracker.setTimeConvert(System.currentTimeMillis() - timeConvert);
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        if (!super.equals(pO)) {
            return false;
        }
        StorageCollection that = (StorageCollection)pO;
        return this.mStructures.equals(that.mStructures);
    }

    @Override
    public String toString() {
        return "StorageCollection{mStructures=" + this.mStructures + "} " + super.toString();
    }

    @Override
    public void addStructure(@NotNull IStorageStructure pStructure) throws StorageException {
        if (this.mStructures.containsKey(pStructure.getName())) {
            String message = "project uid: " + this.getPID() + ", structure name: " + pStructure.getName();
            throw new StorageException(EStorageException.STRUCTURE_ADDED_TWICE, message);
        }
        this.mStructures.put(pStructure.getName(), pStructure);
    }

    @Override
    public boolean areStructuresAdded() {
        for (IStorageStructure value : this.mStructures.values()) {
            if (value.existsFile()) continue;
            return false;
        }
        return this.mStructures.size() > 0;
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        StorableUtil.put(json, (IUniqueID<String>)StorageProjectBase.EStorageProjectBase.STRUCTURES, this.mStructures.values());
        return json;
    }

    @Override
    @NotNull
    public Optional<IStorageStructure> getStructure(@NotNull String pName) {
        return Optional.ofNullable(this.mStructures.get(pName));
    }

    public List<IStorageStructure> getStructures() {
        return new LinkedList<IStorageStructure>(this.mStructures.values());
    }
}

