/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.storage;

import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.storage.EStorageObserverType;
import de.maggicraft.ism.storage.IStorageCreator;
import de.maggicraft.ism.storage.IStorageProjectBase;
import de.maggicraft.ism.storage.StorageCollection;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageProject;
import de.maggicraft.ism.storage.StorageProjectBase;
import de.maggicraft.mioutil.json.IStorable;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class StorageCreator
implements IStorageCreator,
IStorable {
    @NotNull
    private final ConcurrentMap<String, IStorageProjectBase> mProjects;
    @NotNull
    private final String mURL;
    @NotNull
    private final String mName;
    private final int mCID;
    private final int mSubscribers;
    private final int mLevels;

    public StorageCreator(@NotNull ICreator pCreator) {
        this.mProjects = new ConcurrentHashMap<String, IStorageProjectBase>();
        this.mCID = pCreator.getCID();
        this.mName = pCreator.getName();
        this.mURL = pCreator.getURL();
        this.mSubscribers = pCreator.getSubs();
        this.mLevels = pCreator.getLevels();
    }

    public StorageCreator(@NotNull JSONObject pJSON) throws StorageException {
        JSONArray array = ReadableUtil.getArray(pJSON, EStorageCreators.PROJECTS);
        this.mProjects = new ConcurrentHashMap<String, IStorageProjectBase>(array.size());
        boolean exception = false;
        for (Object object : array) {
            JSONObject json = (JSONObject)object;
            try {
                int pid = ReadableUtil.getInt(json, StorageProjectBase.EStorageProjectBase.PID);
                StorageProjectBase project = MData.projectIsCollection(pid) ? new StorageCollection((IStorageCreator)this, json) : new StorageProject((IStorageCreator)this, json);
                this.mProjects.put(project.getURL(), project);
            }
            catch (StorageException pE) {
                ISMContainer.getLogger().log(pE);
                exception = true;
            }
        }
        if (exception) {
            this.clear();
        }
        this.mURL = ReadableUtil.getString(pJSON, EStorageCreators.URL);
        this.mCID = MData.cidByURL(this.mURL, ReadableUtil.getInt(pJSON, EStorageCreators.CID));
        this.mName = ReadableUtil.getString(pJSON, EStorageCreators.NAME);
        this.mSubscribers = ReadableUtil.getInt(pJSON, EStorageCreators.SUBSCRIBERS);
        this.mLevels = ReadableUtil.getInt(pJSON, EStorageCreators.LEVELS);
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        StorageCreator creator = (StorageCreator)pO;
        return this.mCID == creator.mCID && this.mSubscribers == creator.mSubscribers && this.mLevels == creator.mLevels && this.mProjects.equals(creator.mProjects) && this.mURL.equals(creator.mURL) && this.mName.equals(creator.mName);
    }

    public int hashCode() {
        return Objects.hash(this.mURL, this.mName, this.mCID, this.mSubscribers, this.mLevels);
    }

    public String toString() {
        return "StorageCreator{mProjects=" + this.mProjects + ", mURL='" + this.mURL + '\'' + ", mName='" + this.mName + '\'' + ", mCID=" + this.mCID + ", mSubscribers=" + this.mSubscribers + ", mLevels=" + this.mLevels + '}';
    }

    @Override
    @NotNull
    public Optional<IStorageProjectBase> remove(@NotNull IProject pProject) {
        IStorageProjectBase storageProject = (IStorageProjectBase)this.mProjects.remove(pProject.getURL());
        if (storageProject == null) {
            return Optional.empty();
        }
        this.clear();
        ISMContainer.getStorageManager().notifyObservers(EStorageObserverType.PROJECT_COLLECTION_REMOVED, storageProject);
        if (storageProject.isCollection()) {
            ISMContainer.getStorageManager().notifyObservers(EStorageObserverType.COLLECTION_REMOVED, storageProject);
        } else {
            ISMContainer.getStorageManager().notifyObservers(EStorageObserverType.PROJECT_REMOVED, storageProject);
        }
        return Optional.of(storageProject);
    }

    private void clear() {
        if (this.mProjects.isEmpty()) {
            ISMContainer.getStorageManager().removeCreator(this);
        }
    }

    @Override
    @NotNull
    public IStorageProjectBase addProject(@NotNull IProject pProject) {
        Optional<IStorageProjectBase> optional = this.getProject(pProject);
        if (optional.isPresent()) {
            return optional.get();
        }
        StorageProjectBase project = pProject instanceof ICollection ? new StorageCollection((IStorageCreator)this, (ICollection)pProject) : new StorageProject((IStorageCreator)this, pProject);
        this.mProjects.put(project.getURL(), project);
        ISMContainer.getStorageManager().notifyObservers(EStorageObserverType.PROJECT_COLLECTION_ADDED, project);
        if (project.isCollection()) {
            ISMContainer.getStorageManager().notifyObservers(EStorageObserverType.COLLECTION_ADDED, project);
        } else {
            ISMContainer.getStorageManager().notifyObservers(EStorageObserverType.PROJECT_ADDED, project);
        }
        return project;
    }

    @Override
    @NotNull
    public Optional<IStorageProjectBase> getProject(@NotNull IProject pProject) {
        return Optional.ofNullable(this.mProjects.get(pProject.getURL()));
    }

    @Override
    @NotNull
    public Collection<IStorageProjectBase> getProjects() {
        return this.mProjects.values();
    }

    @Override
    @NotNull
    public ICreator toCreator() {
        return MData.getCreator(this.mCID);
    }

    @Override
    @NotNull
    public String getName() {
        return this.mName;
    }

    @Override
    @NotNull
    public String getURL() {
        return this.mURL;
    }

    @Override
    public int getCID() {
        return this.mCID;
    }

    public int getSubscribers() {
        return this.mSubscribers;
    }

    public int getLevels() {
        return this.mLevels;
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        StorableUtil.put(json, (IUniqueID<String>)EStorageCreators.PROJECTS, this.mProjects.values());
        StorableUtil.put(json, (IUniqueID<String>)EStorageCreators.URL, this.mURL);
        StorableUtil.put(json, (IUniqueID<String>)EStorageCreators.NAME, this.mName);
        StorableUtil.put(json, (IUniqueID<String>)EStorageCreators.CID, this.mCID);
        StorableUtil.put(json, (IUniqueID<String>)EStorageCreators.SUBSCRIBERS, this.mSubscribers);
        StorableUtil.put(json, (IUniqueID<String>)EStorageCreators.LEVELS, this.mLevels);
        return json;
    }

    public static enum EStorageCreators implements IUID
    {
        PROJECTS("projects"),
        URL("url"),
        NAME("nme"),
        CID("cid"),
        SUBSCRIBERS("subs"),
        LEVELS("lvl");

        @NotNull
        private final String mUID;

        private EStorageCreators(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

