/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.storage;

import de.maggicraft.ism.analytics.trackers.TrackAddProject;
import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.gui.MViewStatus;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.EStorageObserverType;
import de.maggicraft.ism.storage.IStorageCollection;
import de.maggicraft.ism.storage.IStorageCreator;
import de.maggicraft.ism.storage.IStorageManager;
import de.maggicraft.ism.storage.IStorageProject;
import de.maggicraft.ism.storage.IStorageProjectBase;
import de.maggicraft.ism.storage.IStorageStructure;
import de.maggicraft.ism.storage.StorageCompoundException;
import de.maggicraft.ism.storage.StorageCreator;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.mcommons.event.IObserver;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mioutil.compr.Compressed;
import de.maggicraft.mioutil.io.MIOUtil;
import de.maggicraft.mioutil.json.IReadableManager;
import de.maggicraft.mioutil.json.IStorable;
import de.maggicraft.mioutil.json.IStorableManager;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class StorageManager
implements IStorageManager,
IStorableManager<IStorageCreator>,
IReadableManager {
    public static final String VERSION = "1";
    public static final String FILE_STORAGE = "storage.json";
    @NotNull
    private final Map<EStorageObserverType, Collection<IObserver<IStorable>>> mObservers = new EnumMap<EStorageObserverType, Collection<IObserver<IStorable>>>(EStorageObserverType.class);
    private File mFileJSON;
    private ConcurrentMap<String, IStorageCreator> mCreators;

    public StorageManager() {
    }

    public StorageManager(@NotNull String pJSONPath) {
        this.mFileJSON = new File(pJSONPath);
    }

    @NotNull
    private static Compressed getUnits(@NotNull Collection<Integer> pUnits) {
        int unitRange = Integer.toBinaryString(MData.projectQuantity()).length();
        Compressed compressed = new Compressed(pUnits.size(), unitRange);
        int i = 0;
        for (Integer unit : pUnits) {
            compressed.set(i, (int)unit);
            ++i;
        }
        return compressed;
    }

    @Override
    @NotNull
    public IStorageStructure ensureStructure(@NotNull IProject pProject) throws StorageException {
        if (pProject.isCollection()) {
            throw new IllegalArgumentException("only for projects");
        }
        IStorageCreator creator = this.ensureCreator(pProject);
        Optional<IStorageProjectBase> optionalProject = creator.getProject(pProject);
        IStorageProject project = optionalProject.isPresent() ? (IStorageProject)optionalProject.get() : (IStorageProject)this.addProject(pProject);
        IStorageStructure structure = project.getStructure();
        if (structure.getDim().getVolume() == 0) {
            throw new StorageException(EStorageException.CONVERT_DEFAULT, "empty structure");
        }
        return structure;
    }

    @Override
    @NotNull
    public IStorageStructure ensureStructure(@NotNull ICollection pCollection, @NotNull String pStructure) throws StorageException {
        IStorageCreator creator = this.ensureCreator(pCollection);
        Optional<IStorageProjectBase> optionalProject = creator.getProject(pCollection);
        IStorageCollection project = optionalProject.isPresent() ? (IStorageCollection)optionalProject.get() : (IStorageCollection)this.addProject(pCollection);
        Optional<IStorageStructure> optStructure = project.getStructure(pStructure);
        if (optStructure.isPresent()) {
            IStorageStructure structure = optStructure.get();
            if (structure.getDim().getVolume() == 0) {
                throw new StorageException(EStorageException.CONVERT_DEFAULT, "empty structure");
            }
            return structure;
        }
        String message = "project uid: " + pCollection.getPID() + ", structure name: " + pStructure;
        throw new StorageException(EStorageException.NO_MATCHING_STRUCTURE, message);
    }

    @Override
    @NotNull
    public IStorageProjectBase addProject(@NotNull IProject pProject) throws StorageException {
        long timeTotal = System.currentTimeMillis();
        IStorageCreator creator = this.ensureCreator(pProject);
        if (creator.getProject(pProject).isPresent()) {
            throw new IllegalArgumentException("project \"" + pProject.getPID() + "\"already added");
        }
        IStorageProjectBase project = creator.addProject(pProject);
        TrackAddProject tracker = new TrackAddProject(pProject.getURL(), pProject.getPID());
        MViewStatus.downloadAdding(1);
        if (project.areStructuresAdded()) {
            this.store();
        } else {
            try {
                project.downloadConvert(tracker, pProject.getStructureNames());
                tracker.addTimeTotal(System.currentTimeMillis() - timeTotal);
                tracker.send();
            }
            catch (Exception pE) {
                creator.remove(pProject);
                throw pE;
            }
            finally {
                this.store();
            }
        }
        return project;
    }

    @Override
    @NotNull
    public Optional<IStorageProjectBase> removeProject(@NotNull IProject pProject) {
        IStorageCreator creator = this.ensureCreator(pProject);
        if (!creator.getProject(pProject).isPresent()) {
            throw new IllegalArgumentException("project \"" + pProject.getPID() + "\"is not added");
        }
        return creator.remove(pProject);
    }

    @Override
    public void initialize() {
        File folder;
        if (this.mFileJSON == null) {
            this.mFileJSON = new File(MCon.appFolder(), FILE_STORAGE);
        }
        if (!(folder = this.mFileJSON.getParentFile()).exists()) {
            folder.mkdirs();
        }
        if (this.mFileJSON.exists()) {
            this.read();
        } else {
            this.mCreators = new ConcurrentHashMap<String, IStorageCreator>(5);
        }
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        StorageManager manager = (StorageManager)pO;
        return this.mObservers.equals(manager.mObservers) && this.mFileJSON.equals(manager.mFileJSON) && Objects.equals(this.mCreators, manager.mCreators);
    }

    public int hashCode() {
        return Objects.hash(this.mFileJSON);
    }

    @Override
    public void storeHeader(@NotNull JSONObject pJSON) {
        StorableUtil.put(pJSON, (IUniqueID<String>)EStorageManagerKeys.VERSION, VERSION);
    }

    @Override
    public void readHeader(@NotNull JSONObject pJSON) {
        String version = ReadableUtil.getString(pJSON, EStorageManagerKeys.VERSION);
        if (!version.equals(VERSION)) {
            throw new IllegalArgumentException("version \"" + version + "\" not support");
        }
    }

    @Override
    public void readEntities(@NotNull JSONArray pJSONArray) {
        this.mCreators = new ConcurrentHashMap<String, IStorageCreator>(pJSONArray.size() + 5);
        StorageCompoundException exception = new StorageCompoundException("missing creator");
        for (Object object : pJSONArray) {
            JSONObject json = (JSONObject)object;
            try {
                StorageCreator creator = new StorageCreator(json);
                this.mCreators.put(creator.getURL(), creator);
            }
            catch (StorageException pE) {
                exception.addException(exception);
            }
        }
        if (exception.hasException()) {
            StorageUtil.handleStorageException(exception);
        }
    }

    @Override
    @NotNull
    public Collection<IStorageCreator> getStorables() {
        return this.mCreators.values();
    }

    @Override
    @NotNull
    public File getFile() {
        return this.mFileJSON;
    }

    @Override
    public synchronized void store() {
        MIOUtil.write(this.mFileJSON, this.toJSON().toJSONString());
    }

    @Override
    @NotNull
    public Optional<IStorageCreator> removeCreator(@NotNull IStorageCreator pCreator) {
        IStorageCreator creator = (IStorageCreator)this.mCreators.remove(pCreator.getURL());
        if (creator == null) {
            return Optional.empty();
        }
        this.notifyObservers(EStorageObserverType.CREATOR_REMOVED, pCreator);
        return Optional.of(creator);
    }

    @Override
    @NotNull
    public Optional<IStorageProjectBase> getProject(@NotNull IProject pProject) {
        Optional<IStorageCreator> creator = this.getCreator(pProject);
        if (creator.isPresent()) {
            return creator.get().getProject(pProject);
        }
        return Optional.empty();
    }

    @NotNull
    public IStorageCreator ensureCreator(@NotNull IProject pProject) {
        Optional<IStorageCreator> creator = this.getCreator(pProject);
        if (creator.isPresent()) {
            return creator.get();
        }
        StorageCreator storageCreator = new StorageCreator(pProject.getCreator());
        this.mCreators.put(storageCreator.getURL(), storageCreator);
        this.notifyObservers(EStorageObserverType.CREATOR_ADDED, storageCreator);
        return storageCreator;
    }

    public Optional<IStorageCreator> getCreator(@NotNull IProject pProject) {
        return Optional.ofNullable(this.mCreators.get(pProject.getCreatorURL()));
    }

    @Override
    public boolean isProjectAdded(@NotNull IProject pProject) {
        IStorageCreator creator = (IStorageCreator)this.mCreators.get(pProject.getCreatorURL());
        if (creator == null) {
            return false;
        }
        return creator.getProject(pProject).isPresent();
    }

    @Override
    @NotNull
    public Compressed getCIDs() {
        ArrayList<Integer> cids = new ArrayList<Integer>(this.mCreators.size());
        for (IStorageCreator value : this.mCreators.values()) {
            cids.add(value.getCID());
        }
        return StorageManager.getUnits(cids);
    }

    @Override
    @NotNull
    public Compressed getProjectIDs() {
        LinkedList<Integer> pids = new LinkedList<Integer>();
        for (IStorageCreator creator : this.mCreators.values()) {
            for (IStorageProjectBase project : creator.getProjects()) {
                if (project.isCollection()) continue;
                pids.add(project.getPID());
            }
        }
        return StorageManager.getUnits(pids);
    }

    @Override
    @NotNull
    public Compressed getCollectionIDs() {
        LinkedList<Integer> pids = new LinkedList<Integer>();
        for (IStorageCreator creator : this.mCreators.values()) {
            for (IStorageProjectBase project : creator.getProjects()) {
                if (!project.isCollection()) continue;
                pids.add(project.getPID());
            }
        }
        return StorageManager.getUnits(pids);
    }

    @Override
    @NotNull
    public Map<EStorageObserverType, Collection<IObserver<IStorable>>> getObservers() {
        return this.mObservers;
    }

    public static enum EStorageManagerKeys implements IUID
    {
        VERSION("vers");

        @NotNull
        private final String mUID;

        private EStorageManagerKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

