/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.storage;

import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.jetbrains.annotations.NotNull;

public class StorageManagerWrapper {
    public static void displayPlaceStructure(@NotNull ActionEvent pEvent, @NotNull ICollection pCollection, @NotNull String pStructure) {
        StorageManagerWrapper.run(() -> {
            try {
                ViewManager.displayPlaceStr(ISMContainer.getStorageManager().ensureStructure(pCollection, pStructure));
            }
            catch (StorageException pE) {
                StorageManagerWrapper.handleException(pEvent, pE);
            }
        });
    }

    public static void displayPlaceStructure(@NotNull ActionEvent pEvent, @NotNull IProject pProject) {
        StorageManagerWrapper.run(() -> {
            try {
                ViewManager.displayPlaceStr(ISMContainer.getStorageManager().ensureStructure(pProject));
            }
            catch (StorageException pE) {
                StorageManagerWrapper.handleException(pEvent, pE);
            }
        });
    }

    public static void toggleProject(ActionEvent pEvent, @NotNull IProject pProject) {
        if (ISMContainer.getStorageManager().isProjectAdded(pProject)) {
            StorageManagerWrapper.removeProject(pEvent, pProject);
        } else {
            StorageManagerWrapper.addProject(pEvent, pProject);
        }
    }

    private static void addProject(ActionEvent pEvent, @NotNull IProject pProject) {
        StorageManagerWrapper.run(() -> {
            try {
                ISMContainer.getStorageManager().addProject(pProject);
            }
            catch (StorageException pE) {
                StorageManagerWrapper.handleException(pEvent, pE);
            }
        });
    }

    private static void removeProject(ActionEvent pEvent, @NotNull IProject pProject) {
        StorageManagerWrapper.run(() -> {
            try {
                ISMContainer.getStorageManager().removeProject(pProject);
            }
            catch (StorageException pE) {
                StorageManagerWrapper.handleException(pEvent, pE);
            }
        });
    }

    private static void handleException(@NotNull ActionEvent pEvent, @NotNull StorageException pE) {
        if (pEvent.getSource() instanceof Component) {
            ((Component)pEvent.getSource()).setEnabled(false);
        }
        StorageUtil.handleStorageException(pE);
    }

    private static void run(Runnable pRunnable) {
        new Thread(pRunnable).start();
    }
}

