/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.storage;

import de.maggicraft.ism.analytics.trackers.IDownloadTracker;
import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.IStructure;
import de.maggicraft.ism.gui.MViewStatus;
import de.maggicraft.ism.manager.IISM;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.IStorageCreator;
import de.maggicraft.ism.storage.IStorageProject;
import de.maggicraft.ism.storage.IStorageStructure;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageProjectBase;
import de.maggicraft.ism.storage.StorageStructure;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.ism.str.ReadableStructure;
import de.maggicraft.ism.world.nbt.SchematicUtil;
import de.maggicraft.mcommons.util.MTuple;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public class StorageProject
extends StorageProjectBase
implements IStorageProject {
    private IStorageStructure mStructure;

    public StorageProject(@NotNull IStorageCreator pCreator, @NotNull IProject pProject) {
        super(pCreator, pProject);
        List<IStructure> structures = pProject.getStructures();
        if (pProject.isCollection() || pProject instanceof ICollection || structures.size() != 1) {
            throw new IllegalArgumentException("must not be a collection");
        }
    }

    public StorageProject(@NotNull IStorageCreator pCreator, @NotNull JSONObject pJSON) throws StorageException {
        super(pCreator, pJSON);
        this.mStructure = new StorageStructure((JSONObject)ReadableUtil.getObject(pJSON, StorageProjectBase.EStorageProjectBase.STRUCTURES), this);
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        if (!super.equals(pO)) {
            return false;
        }
        StorageProject that = (StorageProject)pO;
        return Objects.equals(this.mStructure, that.mStructure);
    }

    @Override
    public String toString() {
        return "StorageProject{mStructure=" + this.mStructure + "} " + super.toString();
    }

    @Override
    public void downloadConvert(@NotNull IDownloadTracker pTracker, @NotNull Set<String> pStructureNames) throws StorageException {
        MTuple<String, String> urlFileName = this.urlFileName();
        String url = urlFileName.getA();
        String fileName = urlFileName.getB();
        if (url.endsWith(".z")) {
            this.convertZIP(pTracker, url, fileName, pStructureNames);
        } else {
            String name = new LinkedList<String>(pStructureNames).get(0);
            this.convertSingle(pTracker, url, fileName, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertSingle(@NotNull IDownloadTracker pTracker, @NotNull String pUrl, @NotNull String pFileName, @NotNull String pName) throws StorageException {
        try {
            File folder = new File(MCon.appFolder(), IISM.PATH_STRS);
            File schematicFile = new File(folder, pFileName + ".schematic");
            URL url = StorageUtil.getURL("https://s3.amazonaws.com/static.planetminecraft.com/files/resource_media/schematic/" + pUrl + ".schematic");
            StorageUtil.downloadFile(pTracker, schematicFile, url);
            this.convertSingle(pTracker, schematicFile, pName);
        }
        finally {
            MViewStatus.downloadAdded();
        }
    }

    private void convertSingle(@NotNull IDownloadTracker pTracker, @NotNull File pSchematicFile, @NotNull String pName) throws StorageException {
        long timeConvert = System.currentTimeMillis();
        ReadableStructure strReadable = SchematicUtil.toReadableStructure(pSchematicFile);
        pTracker.setCountedBlocks(strReadable.getBlocks());
        this.addStructure(new StorageStructure(this, strReadable, pSchematicFile, pName));
        pTracker.setStructuresConverted(1);
        pTracker.setTimeConvert(System.currentTimeMillis() - timeConvert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initStrs(@NotNull IDownloadTracker pTracker, @NotNull Set<String> pMap, @NotNull File pFolder, @NotNull Set<String> pNames) throws StorageException {
        long timeConvert = System.currentTimeMillis();
        int converted = 1;
        String name = new LinkedList<String>(pMap).get(0);
        try {
            this.processStr(pTracker, pFolder, name);
        }
        finally {
            MViewStatus.downloadAdded();
        }
        pTracker.setStructuresConverted(++converted);
        pTracker.setTimeConvert(System.currentTimeMillis() - timeConvert);
    }

    @Override
    public void addStructure(@NotNull IStorageStructure pStructure) throws StorageException {
        if (this.mStructure != null) {
            String message = "project uid: " + this.getPID() + ", structure name: " + pStructure.getName();
            throw new StorageException(EStorageException.STRUCTURE_ADDED_TWICE, message);
        }
        this.mStructure = pStructure;
    }

    @Override
    public boolean areStructuresAdded() {
        return this.mStructure != null && this.mStructure.existsFile();
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        StorableUtil.put(json, (IUniqueID<String>)StorageProjectBase.EStorageProjectBase.STRUCTURES, this.mStructure.toJSON());
        return json;
    }

    @Override
    @NotNull
    public IStorageStructure getStructure() {
        return this.mStructure;
    }
}

