/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.storage;

import de.maggicraft.ism.analytics.trackers.IDownloadTracker;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.manager.IISM;
import de.maggicraft.ism.storage.Converter;
import de.maggicraft.ism.storage.IStorageCreator;
import de.maggicraft.ism.storage.IStorageProjectBase;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageStructure;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.ism.str.ReadableStructure;
import de.maggicraft.ism.world.nbt.SchematicUtil;
import de.maggicraft.mcommons.filter.types.MFilter;
import de.maggicraft.mcommons.util.MTuple;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mioutil.json.IStorable;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public abstract class StorageProjectBase
implements IStorageProjectBase,
IStorable {
    @NotNull
    private final IStorageCreator mCreator;
    @NotNull
    private final String[] mTags;
    @NotNull
    private final Date mDateAdded;
    @NotNull
    private final String mURL;
    @NotNull
    private final String mTitle;
    private final int mPID;

    protected StorageProjectBase(@NotNull IStorageCreator pCreator, @NotNull IProject pProject) {
        this.mDateAdded = new Date();
        this.mCreator = pCreator;
        this.mTags = pProject.getTags();
        this.mURL = pProject.getURL();
        this.mTitle = pProject.getTitle();
        this.mPID = pProject.getPID();
    }

    protected StorageProjectBase(@NotNull IStorageCreator pCreator, @NotNull JSONObject pJSON) throws StorageException {
        this.mCreator = pCreator;
        this.mDateAdded = ReadableUtil.getDate(pJSON, EStorageProjectBase.DATE_ADDED);
        this.mTags = ReadableUtil.getStringArray(pJSON, EStorageProjectBase.TAGS);
        this.mURL = ReadableUtil.getString(pJSON, EStorageProjectBase.URL);
        this.mTitle = ReadableUtil.getString(pJSON, EStorageProjectBase.TITLE);
        this.mPID = MData.pidByURL(this.mURL, ReadableUtil.getInt(pJSON, EStorageProjectBase.PID));
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        StorageProjectBase that = (StorageProjectBase)pO;
        return this.mPID == that.mPID && Arrays.equals(this.mTags, that.mTags) && this.mURL.equals(that.mURL) && this.mTitle.equals(that.mTitle);
    }

    public int hashCode() {
        int result = Objects.hash(this.mURL, this.mTitle, this.mPID, this.mDateAdded);
        result = 31 * result + Arrays.hashCode(this.mTags);
        return result;
    }

    public String toString() {
        return "StorageProjectBase{mCreator=" + this.mCreator.getName() + ", mTags=" + Arrays.toString(this.mTags) + ", mURL='" + this.mURL + '\'' + ", mTitle='" + this.mTitle + '\'' + ", mPID=" + this.mPID + '}';
    }

    public MTuple<String, String> urlFileName() {
        String url = MData.structureURL(this.mPID);
        String fileName = MFilter.validateURL(url.substring(url.lastIndexOf(47) + 1));
        return new MTuple<String, String>(url, fileName);
    }

    protected void convertZIP(@NotNull IDownloadTracker pTracker, @NotNull String pUrl, @NotNull String pFileName, @NotNull Set<String> pStructureNames) throws StorageException {
        File folderDownload = new File(MCon.appFolder(), IISM.PATH_STRS);
        pUrl = pUrl.substring(0, pUrl.length() - 2);
        File downloadedZIP = new File(folderDownload, MFilter.validateFilename(pUrl) + ".zip");
        URL url = StorageUtil.getURL("https://s3.amazonaws.com/static.planetminecraft.com/files/resource_media/schematic/" + pUrl + ".zip");
        StorageUtil.downloadFile(pTracker, downloadedZIP, url);
        if (pFileName.endsWith(".z")) {
            pFileName = pFileName.substring(0, pFileName.length() - 2);
        }
        Set<String> map = Converter.decompress(new File(folderDownload, pFileName), downloadedZIP);
        try {
            Files.deleteIfExists(downloadedZIP.toPath());
        }
        catch (IOException pE) {
            ISMContainer.getLogger().log(pE);
        }
        this.initStrs(pTracker, map, new File(folderDownload, pFileName), pStructureNames);
    }

    protected abstract void initStrs(@NotNull IDownloadTracker var1, @NotNull Set<String> var2, @NotNull File var3, @NotNull Set<String> var4) throws StorageException;

    protected void processStr(@NotNull IDownloadTracker pTracker, @NotNull File pFolder, @NotNull String pName) throws StorageException {
        File schematic = new File(pFolder, pName + ".schematic");
        ReadableStructure strReadable = SchematicUtil.toReadableStructure(schematic);
        pTracker.setCountedBlocks(strReadable.getBlocks());
        this.addStructure(new StorageStructure(this, strReadable, schematic, pName));
    }

    @Override
    @NotNull
    public String[] getTags() {
        return this.mTags;
    }

    @Override
    @NotNull
    public Date getDateAdded() {
        return this.mDateAdded;
    }

    @Override
    @NotNull
    public String getURL() {
        return this.mURL;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.mTitle;
    }

    @Override
    @NotNull
    public IProject toProject() {
        return MData.getProject(this.mPID);
    }

    @Override
    @NotNull
    public IStorageCreator getCreator() {
        return this.mCreator;
    }

    @Override
    public int getPID() {
        return this.mPID;
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        StorableUtil.put(json, (IUniqueID<String>)EStorageProjectBase.TAGS, this.mTags);
        StorableUtil.put(json, (IUniqueID<String>)EStorageProjectBase.DATE_ADDED, this.mDateAdded);
        StorableUtil.put(json, (IUniqueID<String>)EStorageProjectBase.URL, this.mURL);
        StorableUtil.put(json, (IUniqueID<String>)EStorageProjectBase.TITLE, this.mTitle);
        StorableUtil.put(json, (IUniqueID<String>)EStorageProjectBase.PID, this.mPID);
        return json;
    }

    public static enum EStorageProjectBase implements IUID
    {
        DATE_ADDED("dat"),
        TAGS("tags"),
        URL("url"),
        TITLE("tit"),
        PID("pid"),
        STRUCTURES("strs");

        @NotNull
        private final String mUID;

        private EStorageProjectBase(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

