/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.storage;

import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.IStorageProjectBase;
import de.maggicraft.ism.storage.IStorageStructure;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.storage.StorageUtil;
import de.maggicraft.ism.str.IReadableStructure;
import de.maggicraft.ism.world.util.Dim;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IOffset;
import de.maggicraft.ism.world.util.Offset;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mioutil.json.IStorable;
import de.maggicraft.mioutil.json.IUID;
import de.maggicraft.mioutil.json.IUniqueID;
import de.maggicraft.mioutil.json.ReadableUtil;
import de.maggicraft.mioutil.json.StorableUtil;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public class StorageStructure
implements IStorageStructure,
IStorable {
    @NotNull
    private final IStorageProjectBase mProject;
    @NotNull
    private final File mFile;
    @NotNull
    private final String mName;
    @NotNull
    private final IDim mDim;
    @NotNull
    private final IOffset mOffset;
    private final int mBlocks;
    private int mPlaced;

    public StorageStructure(@NotNull IStorageProjectBase pProject, @NotNull File pFile, @NotNull String pName, @NotNull IReadableStructure pStructure, int pPlaced) {
        this.mProject = pProject;
        this.mFile = pFile;
        this.mName = pName;
        this.mBlocks = pStructure.getBlocks();
        this.mDim = pStructure.getDim();
        this.mOffset = pStructure.getOffset();
        this.mPlaced = pPlaced;
    }

    public StorageStructure(@NotNull IStorageProjectBase pProject, @NotNull IReadableStructure pStructure, @NotNull File pFile, @NotNull String pName) throws StorageException {
        if (!pFile.exists()) {
            throw new StorageException(EStorageException.STRUCTURE_FILE_NOT_FOUND, "file: " + pFile.getAbsolutePath());
        }
        this.mFile = pFile;
        this.mName = pProject.isCollection() ? pName : pProject.getTitle();
        this.mProject = pProject;
        this.mBlocks = pStructure.getBlocks();
        this.mDim = pStructure.getDim();
        this.mOffset = pStructure.getOffset();
    }

    public StorageStructure(@NotNull JSONObject pJSON, @NotNull IStorageProjectBase pProject) throws StorageException {
        this.mProject = pProject;
        this.mFile = StorageStructure.toAbsoluteFile(ReadableUtil.getString(pJSON, EStorageStructureKeys.PATH));
        this.mName = ReadableUtil.getString(pJSON, EStorageStructureKeys.NAME);
        this.mPlaced = ReadableUtil.getInt(pJSON, EStorageStructureKeys.PLACED);
        this.mBlocks = ReadableUtil.getInt(pJSON, EStorageStructureKeys.BLOCKS);
        this.mDim = new Dim(ReadableUtil.getJSON(pJSON, EStorageStructureKeys.DIM));
        this.mOffset = new Offset(ReadableUtil.getJSON(pJSON, EStorageStructureKeys.OFFSET));
    }

    @NotNull
    public static String toRelativePath(@NotNull File pFile) {
        String fileName = pFile.getName();
        String parentName = pFile.getParentFile().getName();
        if (parentName.equals("structures")) {
            return fileName;
        }
        return parentName + CCon.SEP + fileName;
    }

    @NotNull
    public static File toAbsoluteFile(@NotNull String pRelativePath) throws StorageException {
        File file = new File(StorageUtil.structuresFolder(), pRelativePath);
        if (file.exists()) {
            return file;
        }
        throw new StorageException(EStorageException.STRUCTURE_FILE_NOT_FOUND, "file: " + file.getAbsolutePath());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StorageStructure{");
        sb.append("mFile=").append(this.mFile);
        sb.append(", mName='").append(this.mName).append('\'');
        sb.append(", mDim=").append(this.mDim);
        sb.append(", mOffset=").append(this.mOffset);
        sb.append(", mBlocks=").append(this.mBlocks);
        sb.append(", mPlaced=").append(this.mPlaced);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        StorageStructure that = (StorageStructure)pO;
        return this.mBlocks == that.mBlocks && this.mFile.equals(that.mFile) && this.mName.equals(that.mName) && this.mDim.equals(that.mDim) && this.mOffset.equals(that.mOffset);
    }

    public int hashCode() {
        return Objects.hash(this.mFile, this.mName, this.mDim, this.mOffset, this.mBlocks);
    }

    @Override
    @NotNull
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        StorableUtil.put(json, (IUniqueID<String>)EStorageStructureKeys.PATH, StorageStructure.toRelativePath(this.mFile));
        StorableUtil.put(json, (IUniqueID<String>)EStorageStructureKeys.NAME, this.mName);
        StorableUtil.put(json, (IUniqueID<String>)EStorageStructureKeys.PLACED, this.mPlaced);
        StorableUtil.put(json, (IUniqueID<String>)EStorageStructureKeys.BLOCKS, this.mBlocks);
        StorableUtil.put(json, (IUniqueID<String>)EStorageStructureKeys.DIM, this.mDim.toJSON());
        StorableUtil.put(json, (IUniqueID<String>)EStorageStructureKeys.OFFSET, this.mOffset.toJSON());
        return json;
    }

    @Override
    public boolean existsFile() {
        return this.mFile.exists();
    }

    @Override
    @NotNull
    public File getFile() {
        return this.mFile;
    }

    @Override
    @NotNull
    public IDim getDim() {
        return this.mDim;
    }

    @Override
    @NotNull
    public IOffset getOffset() {
        return this.mOffset;
    }

    @Override
    @NotNull
    public IStorageProjectBase getProject() {
        return this.mProject;
    }

    @Override
    @NotNull
    public String getName() {
        return this.mName;
    }

    @Override
    public int getPlaced() {
        return this.mPlaced;
    }

    @Override
    public int getBlocks() {
        return this.mBlocks;
    }

    public static enum EStorageStructureKeys implements IUID
    {
        NAME("nme"),
        PATH("pth"),
        PLACED("pqu"),
        BLOCKS("blk"),
        DIF_BLOCKS("dbl"),
        DIM("dim"),
        OFFSET("off");

        @NotNull
        private final String mUID;

        private EStorageStructureKeys(String pUID) {
            this.mUID = pUID;
        }

        @Override
        @NotNull
        public String getUID() {
            return this.mUID;
        }
    }
}

