/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.storage;

import de.maggicraft.ism.analytics.trackers.IDownloadTracker;
import de.maggicraft.ism.gui.MTrackableDialogs;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.manager.IISM;
import de.maggicraft.ism.storage.Converter;
import de.maggicraft.ism.storage.EStorageException;
import de.maggicraft.ism.storage.StorageCompoundException;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.view.util.EWindowSize;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class StorageUtil {
    private static File sStructuresFolder;

    private StorageUtil() {
    }

    public static File structuresFolder() {
        if (sStructuresFolder == null) {
            sStructuresFolder = new File(MCon.appFolder(), IISM.PATH_STRS);
        }
        return sStructuresFolder;
    }

    @NotNull
    public static URL getURL(@NotNull String pURL) throws StorageException {
        try {
            return new URL(pURL);
        }
        catch (MalformedURLException pE) {
            throw new StorageException(EStorageException.URL_EXCEPTION, "url: " + pURL, pE);
        }
    }

    public static void downloadFile(@NotNull IDownloadTracker pTracker, @NotNull File pDownloadFile, @NotNull URL pURL) throws StorageException {
        long timeDownload = System.currentTimeMillis();
        Converter.downloadFile(pDownloadFile, pURL);
        pTracker.setTimeDownload(System.currentTimeMillis() - timeDownload);
    }

    public static void deleteRemaining(@NotNull Collection<String> pNames, @NotNull File pFolder) {
        for (String name : pNames) {
            File schematic = new File(pFolder, name + ".schematic");
            try {
                Files.deleteIfExists(schematic.toPath());
            }
            catch (IOException pE) {
                ISMContainer.getLogger().log(pE);
            }
        }
    }

    public static void handleStorageException(@NotNull StorageException pException) {
        ISMContainer.getLogger().log(pException);
        String text = StorageUtil.text(pException);
        MTrackableDialogs.makeNote(ISMContainer.getStrExplorer().getFrame(), EWindowSize.FOUR, text, "storage-exception/");
    }

    public static void handleStorageException(@NotNull StorageCompoundException pException) {
        ISMContainer.getLogger().log(pException);
        StringBuilder sb = new StringBuilder();
        for (StorageException exception : pException.getExceptions()) {
            sb.append(StorageUtil.text(exception)).append(CCon.LINE_SEP);
        }
        String uri = "storage-compound-exception/";
        MTrackableDialogs.makeNote(ISMContainer.getStrExplorer().getFrame(), EWindowSize.FOUR, sb.toString(), uri);
    }

    @NotNull
    private static String text(@NotNull StorageException pE) {
        return MLangManager.rep("te.strExp", pE.getType(), MLangManager.get(pE.getCauseText()), pE.getMessage());
    }
}

