/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.str;

import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.world.boundingbox.EBoundingBoxState;
import de.maggicraft.ism.world.util.Dim;
import de.maggicraft.ism.world.util.Pos;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.filter.check.MCheckSign;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import org.jetbrains.annotations.NotNull;

public class BoundingBoxButton
extends MButton {
    private final MCheckSign mSign;
    private int mCurCornerX;
    private int mCurCornerY;
    private int mCurCornerZ;
    private int mCurDimX;
    private int mCurDimZ;
    private int mNextCornerX;
    private int mNextCornerY;
    private int mNextCornerZ;
    private int mNextDimX;
    private int mNextDimZ;

    public BoundingBoxButton(@NotNull MPos pPos, int pHeight) {
        super((MMPos)pPos, null);
        this.addActionListener(pEvent -> {
            this.mCurCornerX = this.mNextCornerX;
            this.mCurCornerY = this.mNextCornerY;
            this.mCurCornerZ = this.mNextCornerZ;
            this.mCurDimX = this.mNextDimX;
            this.mCurDimZ = this.mNextDimZ;
            Pos corner = new Pos(this.mCurCornerX, this.mCurCornerY, this.mCurCornerZ);
            ISMContainer.getBoundingBox().place(corner, new Dim(this.mCurDimX, pHeight, this.mCurDimZ));
            this.checkDisable();
            this.checkChanged();
        });
        this.title("markArea");
        this.mSign = new MCheckSign(this).title("changedArea");
        this.checkChanged();
    }

    private void checkDisable() {
        this.setEnabled(false);
    }

    private void checkChanged() {
        if (ISMContainer.getBoundingBox().getState() == EBoundingBoxState.PLACED && this.hasChanged()) {
            this.mSign.show();
        } else {
            this.mSign.hide();
        }
    }

    private boolean hasChanged() {
        return this.mNextCornerX != this.mCurCornerX || this.mNextCornerY != this.mCurCornerY || this.mNextCornerZ != this.mCurCornerZ || this.mNextDimX != this.mCurDimX || this.mNextDimZ != this.mCurDimZ;
    }

    public void setNext(int[] pPosDim) {
        this.mNextCornerX = pPosDim[0];
        this.mNextCornerY = pPosDim[1];
        this.mNextCornerZ = pPosDim[2];
        this.mNextDimX = pPosDim[3];
        this.mNextDimZ = pPosDim[4];
        this.checkChanged();
        this.checkDisable();
    }
}

