/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.str;

import de.maggicraft.ism.str.IReadableStructure;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IOffset;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ReadableStructure
implements IReadableStructure {
    @NotNull
    private final File mFile;
    @NotNull
    private final IDim mDim;
    @NotNull
    private final IOffset mOffset;
    private final int mBlocks;

    public ReadableStructure(@NotNull File pFile, @NotNull IDim pDim, @NotNull IOffset pOffset, int pBlocks) {
        this.mFile = pFile;
        this.mDim = pDim;
        this.mOffset = pOffset;
        this.mBlocks = pBlocks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadableStructure{");
        sb.append("mFile=").append(this.mFile);
        sb.append(", mDim=").append(this.mDim);
        sb.append(", mOffset=").append(this.mOffset);
        sb.append(", mBlocks=").append(this.mBlocks);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        ReadableStructure structure = (ReadableStructure)pO;
        return this.mBlocks == structure.mBlocks && this.mFile.equals(structure.mFile) && this.mDim.equals(structure.mDim) && this.mOffset.equals(structure.mOffset);
    }

    public int hashCode() {
        return Objects.hash(this.mFile, this.mDim, this.mOffset, this.mBlocks);
    }

    @Override
    @NotNull
    public File getFile() {
        return this.mFile;
    }

    @Override
    @NotNull
    public IDim getDim() {
        return this.mDim;
    }

    @Override
    @NotNull
    public IOffset getOffset() {
        return this.mOffset;
    }

    @Override
    public int getBlocks() {
        return this.mBlocks;
    }
}

