/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.str;

import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mioutil.cbstream.CBInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class StrUtil {
    public static final int POS_X = 0;
    public static final int POS_Z = 1;
    public static final int POS_MAX_X = 2;
    public static final int POS_MAX_Z = 3;
    public static final int SP_X = 0;
    public static final int SP_Y = 1;
    public static final int SP_Z = 2;
    public static final int SP_DIM_X = 3;
    public static final int SP_DIM_Z = 4;

    private StrUtil() {
    }

    public static int[] convertPosDim(int pRot, int pSPX, int pSPY, int pSPZ, @NotNull IPos pPos, @NotNull IDim pDim) {
        int[] posDim = StrUtil.convertPosDim(pRot, pPos.getX(), pPos.getZ(), pDim.getX(), pDim.getZ());
        int[] pos = StrUtil.convertPos(pRot, pSPX, pSPY, pSPZ, posDim[0], pPos.getY(), posDim[1], posDim[2], pDim.getY(), posDim[3]);
        return new int[]{pos[0], pos[1], pos[2], posDim[2], posDim[3]};
    }

    public static int[] convertPosDim(int pRot, int pPosX, int pPosZ, int pWidth, int pLength) {
        int dimZ;
        int dimX;
        if (pRot % 2 == 0) {
            dimX = pWidth;
            dimZ = pLength;
        } else {
            dimX = pLength;
            dimZ = pWidth;
        }
        if (pRot == 1) {
            pPosX -= pLength - 1;
        } else if (pRot == 2) {
            pPosX -= pWidth - 1;
            pPosZ -= pLength - 1;
        } else if (pRot == 3) {
            pPosZ -= pWidth - 1;
        }
        return new int[]{pPosX, pPosZ, dimX, dimZ};
    }

    public static int[] convertPos(int pRot, int pSPX, int pSPY, int pSPZ, int pPosX, int pPosY, int pPosZ, int pMaxX, int pMaxY, int pMaxZ) {
        pPosX = StrUtil.convertThird(pSPX, pPosX, pMaxX, pRot == 2 || pRot == 1);
        pPosY = StrUtil.convertThird(pSPY, pPosY, pMaxY, false);
        pPosZ = StrUtil.convertThird(pSPZ, pPosZ, pMaxZ, pRot == 2 || pRot == 3);
        return new int[]{pPosX, pPosY, pPosZ};
    }

    public static int[] rotateRectangle(int pRot, int pSPX, int pSPZ, int pPosX, int pPosZ, int pWidth, int pLength) {
        int dimZ;
        int dimX;
        if (pRot % 2 == 0) {
            dimX = pWidth;
            dimZ = pLength;
        } else {
            dimX = pLength;
            dimZ = pWidth;
        }
        int[] fixPoints = StrUtil.rotateFixPoints(pRot, pSPX, pSPZ);
        int posX = pPosX + StrUtil.third(pSPX, pWidth) - StrUtil.third(fixPoints[0], dimX);
        int posZ = pPosZ + StrUtil.third(pSPZ, pLength) - StrUtil.third(fixPoints[1], dimZ);
        return new int[]{posX, posZ, dimX, dimZ};
    }

    public static int[] rotateFixPoints(int pRot, int pX, int pZ) {
        int posX = 0;
        int posZ = 0;
        if (pRot == 0) {
            posX = pX;
            posZ = pZ;
        } else if (pRot == 1) {
            posX = 2 - pZ;
            posZ = pX;
        } else if (pRot == 2) {
            posX = 2 - pX;
            posZ = 2 - pZ;
        } else if (pRot == 3) {
            posX = pZ;
            posZ = 2 - pX;
        }
        return new int[]{posX, posZ};
    }

    public static int convertThird(int pThird, int pPos, int pDim, boolean pInvert) {
        return pPos + StrUtil.third(pThird, pDim) * (pInvert ? 1 : -1);
    }

    private static int third(int pThird, int pDim) {
        int change = 0;
        if (pThird == 1) {
            change = (int)((double)(pDim - 1) / 2.0);
        } else if (pThird == 2) {
            change = pDim - 1;
        }
        return change;
    }

    public static int ensureCornerY(int pPosY, boolean pContainBedrock) {
        int offset = pContainBedrock ? 1 : 0;
        return Math.max(pPosY, offset);
    }

    public static String[] split(@NotNull CBInputStream pIn) throws IOException {
        String header = StrUtil.rawHeader(pIn);
        ArrayList<StringBuilder> list = new ArrayList<StringBuilder>(20);
        int len = header.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char cur = header.charAt(i);
            if (StrUtil.isNewContent(header, len, cur, i) || i == len - 1) {
                list.add(sb);
                sb = new StringBuilder();
                continue;
            }
            sb.append(cur);
        }
        String[] arr = new String[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = ((StringBuilder)list.get(i)).toString();
        }
        return arr;
    }

    private static String rawHeader(@NotNull CBInputStream pIn) throws EOFException {
        char t;
        StringBuilder sb = new StringBuilder();
        int prev = 0;
        while ((t = pIn.readChar()) != '\u00fe' || prev != 255) {
            sb.append(t);
            prev = t;
        }
        return sb.toString();
    }

    private static boolean isNewContent(@NotNull String pHeader, int pLen, char pCur, int pI) {
        return pI < pLen - 1 && pCur == '\u00ff' && pHeader.charAt(pI + 1) >= '\u00e9' && pHeader.charAt(pI + 1) < '\u00ff';
    }
}

