/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.analytics.util.EUTMView;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.placed.EPlacedSortingType;
import de.maggicraft.ism.placed.IPlaced;
import de.maggicraft.ism.placed.IPlacedIntern;
import de.maggicraft.ism.results.ViewPlaced;
import de.maggicraft.ism.views.EChangeType;
import de.maggicraft.ism.views.IViewDeinit;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.ism.world.info.IWorldInfo;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MChangeView
extends MISMView<Integer>
implements IViewDeinit {
    private final EChangeType mType;
    @Nullable
    protected IPlaced mPlaced;
    private MCombo mSort;

    public MChangeView(EChangeType pType) {
        this.mType = pType;
    }

    private void mainHeader(@NotNull IPlacedIntern pPlaced, @NotNull IProject pProject, @NotNull ICreator pCreator) {
        MFlowPanel header = new MFlowPanel((MMPos)LPos.pos(this, "[[<>m<>,[[<>61", 1), MCon.colorFrame());
        MText tPreTitle = new MText(MPos.pos(header, "[[<30>p,]]p<5>")).title("pre" + this.mType.getTypeName());
        tPreTitle.setForeground(MCon.colorTitleText());
        tPreTitle.setFont(MCon.fontTitle());
        MText tTitle = ViewUtil.titleSelectable(MPos.pos("H[]<>p,]]p<5>", tPreTitle), pPlaced.getStructureName(), () -> ViewManager.displayDetail(pProject));
        MText tBy = new MText(MPos.pos("H[]<>p,]]p<5>", tTitle)).text(' ' + MLangManager.get("te.by"));
        tBy.setForeground(MCon.colorTitleText());
        tBy.setFont(MCon.fontTitle());
        ViewUtil.titleSelectable(MPos.pos("H[]<>p,]]p<5>", tBy), pCreator.getName(), () -> ViewManager.displayDetail(pCreator));
        MButton bTut = this.mType == EChangeType.TYPE_REPOS ? ViewUtil.tutorialButton(header, "repStr", EUTMView.VIEW_REPOS_STRUCTURE) : ViewUtil.tutorialButton(header, "remStr", EUTMView.VIEW_REMOVE_STRUCTURE);
        new MPanel(MPos.pos("H][m,]]<>p<>", bTut), MCon.colorTitleLine());
    }

    private void mainHeader(@NotNull IPlaced pPlaced) {
        MFlowPanel header = new MFlowPanel((MMPos)LPos.pos(this, "[[<>m<>,[[<>61", 1), MCon.colorFrame());
        MText tPreTitle = new MText(MPos.pos(header, "[[<30>p,]]p<5>")).title("pre" + this.mType.getTypeName());
        tPreTitle.setForeground(MCon.colorTitleText());
        tPreTitle.setFont(MCon.fontTitle());
        ViewUtil.titleSelectable(MPos.pos("H[]<>p,]]p<5>", tPreTitle), pPlaced.getStructureName(), () -> ViewManager.displayLeftMenu(ViewManager.VIEW_LOCAL_STRUCTURES));
        MButton bTut = this.mType == EChangeType.TYPE_REPOS ? ViewUtil.tutorialButton(header, "repStr", EUTMView.VIEW_REPOS_STRUCTURE) : ViewUtil.tutorialButton(header, "remStr", EUTMView.VIEW_REMOVE_STRUCTURE);
        new MPanel(MPos.pos("H][m,]]<>p<>", bTut), MCon.colorTitleLine());
    }

    protected MText headerIntern(@NotNull IPlacedIntern pPlaced) {
        IProject project = MData.getProject(pPlaced.getPID());
        ICreator creator = MData.getCreator(pPlaced.getCID());
        this.mainHeader(pPlaced, project, creator);
        int w = Util.getWidth(MCon.fontText(), MLangManager.prefix("te.", "strName", "placedOn", "wid", "hig", "len", "blks")) + MCon.defaultGap();
        w = Math.max(w, Util.getWidth(MCon.fontText(), MLangManager.get("te.cre")) + MCon.defaultGap());
        MButton thumb = ViewUtil.thumbnailButton(MPos.pos(this, "[[<30>256,[[<76>150"), project);
        MPos pos = MPos.pos("V[[<30>" + w + ",[]p", thumb);
        String posLeft = "[[<>" + w + ",[]<8>p";
        MText tLast = new MText(pos).title("strName");
        ViewUtil.addInfo(tLast, pPlaced.getStructureName());
        tLast = new MText(MPos.pos(posLeft, tLast)).title("cre");
        ViewUtil.addInfo(tLast, creator.getName());
        MText tPlcOn = new MText(MPos.pos(posLeft, tLast)).title("placedOn");
        MText tWid = new MText(MPos.pos(posLeft, tPlcOn)).title("wid");
        MText tHig = new MText(MPos.pos(posLeft, tWid)).title("hig");
        MText tLen = new MText(MPos.pos(posLeft, tHig)).title("len");
        MText tBlk = new MText(MPos.pos(posLeft, tLen)).title("blks");
        ViewUtil.addInfo(tPlcOn, SharedUtil.formatExactDate(pPlaced.getDatePlaced()));
        IDim dim = pPlaced.getDim();
        ViewUtil.addInfo(tWid, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getX())));
        ViewUtil.addInfo(tHig, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getY())));
        ViewUtil.addInfo(tLen, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getZ())));
        ViewUtil.addInfo(tBlk, CommonUtil.decMark(pPlaced.getBlocks()));
        return tBlk;
    }

    protected MText headerLocal(@NotNull IPlaced pPlaced) {
        this.mainHeader(pPlaced);
        int w = Util.getWidth(MCon.fontText(), MLangManager.prefix("te.", "strName", "placedOn", "wid", "hig", "len", "blks")) + MCon.defaultGap();
        MPos pos = MPos.pos(this, "[[<30>" + w + ",[[<76>p");
        String posLeft = "[[<>" + w + ",[]<8>p";
        MText tLast = new MText(pos).title("strName");
        ViewUtil.addInfo(tLast, pPlaced.getStructureName());
        MText tPlcOn = new MText(MPos.pos(posLeft, tLast)).title("placedOn");
        MText tWid = new MText(MPos.pos(posLeft, tPlcOn)).title("wid");
        MText tHig = new MText(MPos.pos(posLeft, tWid)).title("hig");
        MText tLen = new MText(MPos.pos(posLeft, tHig)).title("len");
        MText tBlk = new MText(MPos.pos(posLeft, tLen)).title("blks");
        ViewUtil.addInfo(tPlcOn, SharedUtil.formatExactDate(pPlaced.getDatePlaced()));
        IDim dim = pPlaced.getDim();
        ViewUtil.addInfo(tWid, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getX())));
        ViewUtil.addInfo(tHig, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getY())));
        ViewUtil.addInfo(tLen, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getZ())));
        ViewUtil.addInfo(tBlk, CommonUtil.decMark(pPlaced.getBlocks()));
        return tBlk;
    }

    void viewListStrs() {
        MButton bTut = this.mType == EChangeType.TYPE_REPOS ? ViewUtil.headerTutorial(this, MLangManager.get("ti.repStrs"), "repStr", EUTMView.VIEW_REPOS_STRUCTURE) : ViewUtil.headerTutorial(this, MLangManager.get("ti.remStrs"), "remStr", EUTMView.VIEW_REMOVE_STRUCTURE);
        ViewPlaced viewPlaced = new ViewPlaced(MPos.pos(this, "||<>m<>,[[<105>p"), ViewManager.getScroll()){

            @Override
            public void actPrefDim(int pWidth, int pHeight) {
                MChangeView.this.setDim(Math.max(pWidth, 500), pHeight + 185);
            }

            @Override
            @NotNull
            public List<IPlaced> getPlaced() {
                EPlacedSortingType sorting = MChangeView.this.mSort.getSelectedIndex() == 0 ? EPlacedSortingType.SORT_DATE : EPlacedSortingType.SORT_DISTANCE;
                IWorldInfo world = ISMContainer.getWorldInfoManager().getWorldInfo();
                return ISMContainer.getPlacedManager().getPlacedWorld(world).getPlaceds(sorting, true);
            }

            @Override
            public EChangeType getType() {
                return MChangeView.this.mType;
            }
        };
        viewPlaced.buttonsResType(MPos.pos("][p,]]p<5>", bTut));
        viewPlaced.buttonsPage(MPos.pos(this, "||p,]]p<25>"));
        MFlowPanel panelFilter = new MFlowPanel(LPos.pos(this, "[[<>m<>,[[<61>60", 1), 61, MCon.colorFrame());
        MPanel view = new MPanel(MPos.pos(panelFilter, "||<30>M850<30>,||<>30<>"), MCon.colorFrame());
        int w = Util.getWidth(MLangManager.get("te.filter")) + MCon.defaultGap();
        this.mSort = new MCombo(MPos.pos(view, "[[<" + w + ">p,||<>s<>")).title("dtPlc", "disStr");
        new MText(MPos.pos("V[[<>p,||<>p<>", this.mSort)).title("sort");
        ViewUtil.initFilter(this, 121, MPos.pos("[]m<>,||<>30<>", this.mSort), viewPlaced);
        this.mSort.setSelectedIndex((Boolean)CSettings.SETTING_SORT_BY_DATE.getValue() != false ? 0 : 1);
        this.mSort.addItemListener(pEvent -> {
            CSettings.SETTING_SORT_BY_DATE.setValue(this.mSort.getSelectedIndex() == 0);
            this.display(0);
        });
        viewPlaced.displayResPage();
    }

    public void setPlaced(@Nullable IPlaced pPlaced) {
        this.mPlaced = pPlaced;
    }

    @Override
    public void deinitializeObjects() {
        this.mPlaced = null;
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        String uri;
        if (ISMContainer.getUpdateManager().isLegal()) {
            if (ISMContainer.getWorldInfoManager().isLoggedOut()) {
                uri = EURI.ATTR_LOGGED_OUT.toString();
            } else if (this.mPlaced == null) {
                uri = EURI.LIST.toString();
            } else if (this.mPlaced instanceof IPlacedIntern) {
                uri = "project/" + ((IPlacedIntern)this.mPlaced).getProjectURL();
            } else {
                try {
                    uri = "local-structure/" + URLEncoder.encode(this.mPlaced.getStructureName(), "UTF-8") + '/';
                }
                catch (UnsupportedEncodingException pE) {
                    ISMContainer.getLogger().log(pE);
                    uri = "local-structure/wrong-encoding/";
                }
            }
        } else {
            uri = EURI.ATTR_ILLEGAL.toString();
        }
        return (Object)((Object)EURI.PRE_WORLD) + this.mType.getURI() + uri;
    }
}

