/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.ESearchMode;
import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.search.Search;
import de.maggicraft.ism.search.SearchManager;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.comp.MPicture;
import de.maggicraft.mgui.pos.MPicPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.util.ImgUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class MViewBrowse
extends MISMView<Integer> {
    private MButton mButtonSearch;

    @Override
    public void initialize() {
        ImageIcon img = ImgUtil.getAppIcon("str_explorer");
        MPicture pic = new MPicture(MPicPos.pos(this, "||p,||p"), img){

            @Override
            public void setBounds(int pX, int pY, int pWidth, int pHeight) {
                super.setBounds(pX, pY - 75, pWidth, pHeight);
            }
        };
        final MField fSearch = new MField(MPos.pos("||" + (img.getIconWidth() + 45) + ",[]30", pic)){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                if (MViewBrowse.this.mButtonSearch != null && MViewBrowse.this.mButtonSearch.getPos() != null) {
                    x += (-MViewBrowse.this.mButtonSearch.getPrefWidth() - ((MPos)MViewBrowse.this.mButtonSearch.getPos()).getGapWest()) / 2;
                }
                super.setBounds(x, y, width, height);
            }
        }.title("search");
        fSearch.addListener(pEvent -> {
            boolean enabled = !fSearch.getText().equals(fSearch.getPlaceholder());
            this.mButtonSearch.setEnabled(enabled);
        }, true);
        fSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent pE) {
                if (pE.getKeyCode() == 10 && !fSearch.getText().equals(fSearch.getPlaceholder())) {
                    ViewManager.SEARCH_MANAGER.search(ViewManager.VIEW_SEARCH_RES, fSearch.getText(), ESearchMode.SEARCH_ALL);
                }
            }
        });
        this.mButtonSearch = new MButton(MPos.pos("[]p,||30", fSearch)).addAction(pEvent -> ViewManager.SEARCH_MANAGER.search(ViewManager.VIEW_SEARCH_RES, fSearch.getText(), ESearchMode.SEARCH_ALL)).title("search");
        this.mButtonSearch.prefWidth();
        this.mButtonSearch.setEnabled(false);
        MEditor edAlt = new MEditor(MPos.pos("V||p,[]p", fSearch)).title("browseAlt");
        edAlt.addHyperlinkListener(pEvent -> {
            if (pEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String desc = pEvent.getDescription();
                if (desc.equals("mguiAllStrs")) {
                    fSearch.text("[all]");
                    ViewManager.SEARCH_MANAGER.search(ViewManager.VIEW_SEARCH_RES, "[all]", ESearchMode.SEARCH_ALL);
                } else if (desc.equals("mguiRdmStrs")) {
                    fSearch.text("[random]");
                    ViewManager.SEARCH_MANAGER.search(ViewManager.VIEW_SEARCH_RES, "[random]", ESearchMode.SEARCH_ALL);
                } else if (desc.equals("mguiRdmSearch")) {
                    MField field;
                    String search = fSearch.getText();
                    if ((search.isEmpty() || search.equals(fSearch.getPlaceholder())) && (search = (field = ISMContainer.getStrExplorer().getMainMenu().getSearchField()).getText()).equals(field.getPlaceholder())) {
                        search = "";
                    }
                    SearchManager manager = ViewManager.SEARCH_MANAGER;
                    Search.rdmSearch(search, manager.mSetSrc, manager.mSetBlocks, manager.mSetArea);
                }
            }
        });
        this.setDim(750, 200);
    }

    @Override
    protected void displayState(Integer pMode) {
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        return (Object)((Object)EURI.PRE_BROWSE) + "start-page/";
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_BROWSE;
    }

    @Override
    public int getMenuButton() {
        return 0;
    }
}

