/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.results.ViewRes;
import de.maggicraft.ism.storage.EStorageObserverType;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.comp.MPicture;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.pos.MPicPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mioutil.compr.Compressed;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MViewCreators
extends MISMView<Integer> {
    @Override
    public void initialize() {
        ISMContainer.getStorageManager().registerObserver(EStorageObserverType.CREATOR_REMOVED, pStorable -> {
            if (ViewManager.isCurrent(ViewManager.VIEW_CREATORS)) {
                ViewManager.displayLeftMenu(ViewManager.VIEW_CREATORS);
            }
        });
    }

    @Override
    protected void displayState(Integer pMode) {
        Compressed creators = ISMContainer.getStorageManager().getCIDs();
        if (creators.size() == 0) {
            ViewUtil.header(this, MLangManager.get("te.tiCres"));
            MTitle tHint = new MTitle(MPos.pos(this, "[[<30>m<30>,[[<76>p")).title("hintCres");
            MEditor edText = new MEditor(MPos.pos("[[m<45>,[]p", tHint)).title("hintCres");
            edText.setFont(MCon.fontText());
            MPicture last = new MPicture(MPicPos.pos("[[p,[]p<45>", tHint, edText), ImgUtil.getAppIcon("add_cres"));
            this.setDim(last, 500);
        } else {
            ViewRes viewRes = ViewUtil.initStrView(this, "tiCres", 300);
            Compressed resType = new Compressed(creators.size(), 1);
            for (int i = 0; i < creators.size(); ++i) {
                resType.set(i, 1);
            }
            ViewUtil.initFilter(this, viewRes);
            viewRes.init(creators, resType);
        }
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        return (Object)((Object)EURI.PRE_LIBRARY) + EURI.LIST.toString() + "creators/";
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_CREATORS;
    }

    @Override
    public int getMenuButton() {
        return 13;
    }

    @Override
    @NotNull
    public EFeature getFeature() {
        return EFeature.CREATORS;
    }
}

