/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.analytics.util.EUTMExternal;
import de.maggicraft.ism.database.ICreator;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.manager.CSettings;
import de.maggicraft.ism.results.ViewRes;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MPicture;
import de.maggicraft.mgui.comp.MPictureMode;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPicPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MViewDetailCreator
extends MISMView<Integer> {
    private ICreator mCreator;
    private int mPosY;

    @Override
    protected void displayState(Integer pMode) {
        MPicture banner = new MPicture(MPicPos.pos(this, "||<>m<>,[[<>p"), this.mCreator.getBanner(), MPictureMode.FIT_WIDTH){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                int[] header = ViewManager.getScroll().halfHeader(0, 0, y, height);
                super.setBounds(x, header[0], width, header[1]);
            }

            @Override
            public void setIcon(@NotNull Icon icon) {
                super.setIcon(icon);
                if (this.getPos() != null) {
                    int prefHeight = Math.min(icon.getIconHeight(), 300);
                    MViewDetailCreator.this.mPosY = prefHeight + 61 + MCon.defaultGap();
                    this.getPos().setPrefHeight(prefHeight);
                    MViewDetailCreator.this.update();
                }
            }
        }.horizontal(0);
        banner.setFont(MCon.fontTitle());
        banner.setForeground(MCon.colorTitleText());
        MFlowPanel pTitle = new MFlowPanel((MMPos)LPos.pos("V||<>m<>,[]<>61", (IComp)banner, 1), MCon.colorFrame());
        new MTitle(MPos.pos(pTitle, "[[m,]]<>p<>")).text(this.mCreator.getName());
        MPicture pic = new MPicture(MPicPos.pos(this, "[[<30>120,[[120"), this.mCreator.getAvatar()){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, MViewDetailCreator.this.mPosY, width, height);
            }
        };
        int w = Math.max(120, Util.getWidth(MCon.fontText(), MLangManager.prefix("te.", "lvl", "subs", "tBlk", "tVws", "tDls", "tFav", "tDia", "tCom"))) + MCon.defaultGap();
        ViewUtil.buttonCre(MPos.pos("V[[<" + (w + 30) + ">p,[[<>p", pic), this.mCreator, EUTMExternal.EXT_DETAIL_VIEW_CRE);
        MText tLvl = new MText(MPos.pos("[[<>" + w + ",[]<25>p", pic)).title("lvl");
        MText tSubs = new MText(MPos.pos("[[<>" + w + ",[]<8>p", tLvl)).title("subs");
        MText tBlk = new MText(MPos.pos("[[<>" + w + ",[]<25>p", tSubs)).title("tVws");
        MText tVws = new MText(MPos.pos("[[<>" + w + ",[]<8>p", tBlk)).title("tDls");
        MText tDls = new MText(MPos.pos("[[<>" + w + ",[]<8>p", tVws)).title("tFav");
        MText tDia = new MText(MPos.pos("[[<>" + w + ",[]<8>p", tDls)).title("tDia");
        MText tCom = new MText(MPos.pos("[[<>" + w + ",[]<8>p", tDia)).title("tCom");
        ViewUtil.addInfo(tLvl, this.mCreator.getLevels());
        ViewUtil.addInfo(tSubs, this.mCreator.getSubs());
        ViewUtil.addInfo(tBlk, this.mCreator.getBlocks());
        ViewUtil.addInfo(tVws, this.mCreator.getViews());
        ViewUtil.addInfo(tDls, this.mCreator.getDownloads());
        ViewUtil.addInfo(tDia, this.mCreator.getDiamonds());
        ViewUtil.addInfo(tCom, this.mCreator.getComments());
        MFlowPanel header = new MFlowPanel(LPos.pos("V[[<>m<>,[]45", (IComp)tCom, 1), 61, MCon.colorFrame());
        MText title = new MText(MPos.pos(header, "[[<30>p,]]<>p<5>")).title("strs");
        title.setForeground(MCon.colorTitleText());
        title.setFont(MCon.fontTitle());
        new MPanel(MPos.pos(header, "[[m,]]1<>"), MCon.colorTitleLine());
        ViewRes viewRes = new ViewRes(MPos.pos(this, "||<>m<>,[[p"), ViewManager.getScroll(), CSettings.SETTING_VIEW_CRE, false){

            @Override
            public void actPrefDim(int pWidth, int pHeight) {
                ViewManager.VIEW_DETAIL_CREATOR.setDim(Math.max(740, pWidth), pHeight + MViewDetailCreator.this.mPosY + 460);
            }

            @Override
            public int getSort() {
                return 0;
            }

            @Override
            public void setBounds(int pX, int pY, int pWidth, int pHeight) {
                super.setBounds(pX, MViewDetailCreator.this.mPosY + 405, pWidth, pHeight);
            }
        };
        viewRes.init(this.mCreator.getSearchRes(), 0);
        viewRes.buttonsResType(MPos.pos(header, "]]p<30>,]]p<5>"));
    }

    public void setCreator(ICreator pCreator) {
        this.mCreator = pCreator;
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(() -> {
            this.update();
            ViewManager.getScroll().scrollToTop();
            Dimension pref = ViewManager.VIEW_DETAIL_CREATOR.getPreferredSize();
            ViewManager.VIEW_DETAIL_CREATOR.setDim(pref.width, pref.height);
            this.eventLoaded();
        });
    }

    @Override
    @NotNull
    public String getURI() {
        return (Object)((Object)EURI.PRE_BROWSE) + EURI.VIEW.toString() + "creator/" + this.mCreator.getURL();
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_DETAIL_CREATOR;
    }

    @Override
    public int getMenuButton() {
        return 0;
    }
}

