/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.analytics.util.EUTMExternal;
import de.maggicraft.ism.database.ICollection;
import de.maggicraft.ism.database.IProject;
import de.maggicraft.ism.database.IStructure;
import de.maggicraft.ism.favorites.EFavoriteObservedOperation;
import de.maggicraft.ism.favorites.IFavorite;
import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.SharedUtil;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.results.ResSearch;
import de.maggicraft.ism.storage.EStorageObserverType;
import de.maggicraft.ism.storage.StorageManagerWrapper;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.ism.world.util.IDim;
import de.maggicraft.mcommons.event.IObserver;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CommonUtil;
import de.maggicraft.mcommons.util.MTriple;
import de.maggicraft.mcommons.util.MTuple;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MPicture;
import de.maggicraft.mgui.comp.MPictureMode;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.comp.MToggle;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPicPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.schemes.types.MSchemeFont;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mioutil.json.IStorable;
import de.maggicraft.mthread.AssemblyThread;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MViewDetailProject
extends MISMView<Integer> {
    @NotNull
    private static final ImageIcon ICON_SLIDER;
    @NotNull
    private static final ImageIcon ICON_SLIDER_SELECTED;
    @NotNull
    private static final ImageIcon ICON_SLIDER_BACKGROUND;
    @NotNull
    private static final ImageIcon ICON_SLIDER_BACKGROUND_SELECTED;
    private static final ImageIcon ICON_LOADING;
    private static final ImageIcon ICON_ADD;
    private static final ImageIcon ICON_ADD_HOVER;
    private static final ImageIcon ICON_ADD_PRESSED;
    private LinkedList<MTuple<String, ImageIcon>> mThumbURLS;
    private ConcurrentHashMap<Integer, MTuple<String, ImageIcon>> mImages;
    private MButton[] mSlider;
    private MPicture mImg;
    private MText mImgTitle;
    private IProject mProject;
    @Nullable
    private IObserver<IFavorite> mFavoriteAdded;
    @Nullable
    private IObserver<IFavorite> mFavoriteRemoved;
    @Nullable
    private IObserver<IStorable> mObserverAdded;
    @Nullable
    private IObserver<IStorable> mObserverRemoved;
    private int mCurImg;

    @Override
    protected void displayState(Integer pMode) {
        if (this.mFavoriteAdded != null) {
            ISMContainer.getFavoritesManager().removeObserver(EFavoriteObservedOperation.FAVORITE_REMOVED, this.mFavoriteAdded);
        }
        if (this.mFavoriteRemoved != null) {
            ISMContainer.getFavoritesManager().removeObserver(EFavoriteObservedOperation.FAVORITE_ADDED, this.mFavoriteRemoved);
        }
        if (this.mObserverAdded != null) {
            ISMContainer.getStorageManager().removeObserver(EStorageObserverType.PROJECT_COLLECTION_ADDED, this.mObserverAdded);
        }
        if (this.mObserverAdded != null) {
            ISMContainer.getStorageManager().removeObserver(EStorageObserverType.PROJECT_COLLECTION_REMOVED, this.mObserverRemoved);
        }
        SharedUtil.moreStr(this.mProject, this, false, false);
        this.initHeader();
        IComp last = this.initSlider();
        MPos pos = MPos.pos("V[[<30>p,[]<30>p", last);
        if (!this.mProject.isCollection()) {
            last = this.buttonPlaceStructure(pos);
            pos = MPos.pos("[]p,||p", last);
        }
        MButton bAdd = this.buttonAdd(pos);
        if (this.mProject.isCollection()) {
            last = bAdd;
        }
        MTriple<MToggle, IObserver<IFavorite>, IObserver<IFavorite>> bFav = ViewUtil.buttonFav(MPos.pos("[]p,||p", bAdd), this.mProject);
        this.mFavoriteAdded = bFav.getB();
        this.mFavoriteRemoved = bFav.getC();
        MButton bProject = ViewUtil.buttonProject(MPos.pos("[]p,||p", bFav.getA()), this.mProject, EUTMExternal.EXT_DETAIL_VIEW_PROJECT);
        ViewUtil.buttonCre(MPos.pos("[]p,||p", bProject), this.mProject.getCreator(), EUTMExternal.EXT_DETAIL_VIEW_PROJECT);
        int w = Util.getWidth(MCon.fontText(), MLangManager.prefix("te.", "col", "str", "cre", "upl", "upd", "vws", "dls", "favo", "dia", "com")) + MCon.defaultGap();
        String posLeft = "[[<>" + w + ",[]<8>p";
        MText tStr = new MText(MPos.pos("[[<>" + w + ",[]<55>p", last)).title(this.mProject.isCollection() ? "col" : "str");
        ViewUtil.addInfo(tStr, this.mProject.getTitle());
        MText tCre1 = new MText(MPos.pos(posLeft, tStr)).title("cre");
        MText tCreOpen = new MText(MPos.pos("[]<>p,||p", tCre1)).text(this.mProject.getCreatorName());
        SharedUtil.addLink(tCreOpen, () -> ViewManager.displayDetail(this.mProject.getCreator()));
        this.mCurImg = 0;
        this.mSlider[0].setIcon(ICON_SLIDER_SELECTED);
        this.update();
        MText tTags = new MText(MPos.pos(posLeft, tCre1)).title("tag");
        last = tTags;
        String[] tags = this.mProject.getTags();
        int curWidth = 0;
        for (int i = 0; i < tags.length; ++i) {
            MPos posTag;
            int wid = Util.getWidth(MCon.fontText(), tags[i]);
            if ((curWidth += wid) < 720 - w - 2 * MCon.defaultGap()) {
                posTag = MPos.pos("[]<>p,||p", last);
            } else {
                curWidth = wid;
                posTag = MPos.pos("[]<>p,[]<8>p", tTags, last);
            }
            last = new MText(posTag).text(tags[i]);
            int finalI = i;
            SharedUtil.addLink((MText)last, () -> ViewManager.SEARCH_MANAGER.searchTag(ViewManager.VIEW_SEARCH_RES, tags[finalI]));
            if (i >= tags.length - 1) continue;
            last = new MText(MPos.pos("[]<>p,||p", last)).text(", ");
        }
        MText tDate = new MText(MPos.pos("[[<>" + w + ",[]<25>p", tTags, last)).title("upl");
        ViewUtil.addInfo(tDate, this.mProject.getDatePosted());
        if (this.mProject.hasUpdate()) {
            tDate = new MText(MPos.pos(posLeft, tDate)).title("upd");
            ViewUtil.addInfo(tDate, this.mProject.getDateUpdated());
        }
        MText tViews = new MText(MPos.pos("[[<>" + w + ",[]<25>p", tDate)).title("vws");
        MText tDls = new MText(MPos.pos(posLeft, tViews)).title("dls");
        MText tFav = new MText(MPos.pos(posLeft, tDls)).title("favo");
        MText tDia = new MText(MPos.pos(posLeft, tFav)).title("dia");
        MText tCom = new MText(MPos.pos(posLeft, tDia)).title("com");
        ViewUtil.addInfo(tViews, this.mProject.getViews());
        ViewUtil.addInfo(tDls, this.mProject.getDownloads());
        ViewUtil.addInfo(tFav, this.mProject.getFavorites());
        ViewUtil.addInfo(tDia, this.mProject.getDiamonds());
        ViewUtil.addInfo(tCom, this.mProject.getComments());
        last = tCom;
        last = this.mProject.isCollection() ? this.footerCollection(last) : this.footerProject(last, w);
        ViewManager.VIEW_DETAIL_PROJECT.setDim(last, 860);
    }

    private void initHeader() {
        MFlowPanel header = new MFlowPanel((MMPos)MPos.pos(this, "[[<>m<>,[[<>61<>"), MCon.colorFrame());
        MText title = new MText(MPos.pos(header, "[[<30>p,]]<>p<5>")).rep("byTitle", this.mProject.getTitle());
        title.setForeground(MCon.colorTitleText());
        title.setFont(MCon.fontTitle());
        final MText tCre = new MText(MPos.pos("[]<>p,||p<>", title)).text(this.mProject.getCreatorName());
        tCre.setForeground(MCon.colorTitleText());
        tCre.setFont(MCon.fontTitle());
        tCre.setCursor(CSharedCon.CURSOR_HAND);
        tCre.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent pEvent) {
                ViewManager.displayDetail(MViewDetailProject.this.mProject.getCreator());
            }

            @Override
            public void mouseEntered(MouseEvent pEvent) {
                tCre.setFont(ViewUtil.FONT_TITLE_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent pEvent) {
                tCre.setFont(MCon.fontTitle());
            }
        });
        new MPanel(MPos.pos(header, "[[m,]]1<>"), MCon.colorTitleLine());
    }

    @NotNull
    private IComp initSlider() {
        this.mImg = new MPicture(MPicPos.pos(this, "[[<30>720,[[<76>405"), ICON_LOADING, MPictureMode.CUT);
        this.mImg.setHorizontalAlignment(0);
        this.mThumbURLS = new LinkedList();
        this.mImg.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent pEvent) {
                for (MTuple tuple : MViewDetailProject.this.mThumbURLS) {
                    if (tuple.getB() != ((MTuple)MViewDetailProject.this.mImages.get(MViewDetailProject.this.mCurImg)).getB()) continue;
                    String out = ".addThumb(\"" + MViewDetailProject.this.mProject.getURL() + "\", \"" + (String)tuple.getA() + "\");";
                    System.err.println(out);
                    break;
                }
            }
        });
        JComponent last = this.mImg;
        if (this.mProject.hasTitles()) {
            this.mImgTitle = new MText(MPos.pos("||p,[]p", this.mImg)).text(this.mProject.getImgTitles()[0]);
            last = this.mImgTitle;
        }
        MButton left = new MButton(MPos.pos("[[<>p,[]p", this.mImg, last), ViewUtil.ICON_LEFT_ENABLED, ViewUtil.ICON_LEFT_ROLLOVER, ViewUtil.ICON_LEFT_PRESSED){

            @Override
            public void setBounds(int pX, int pY, int pWidth, int pHeight) {
                int offset = 0;
                if (MViewDetailProject.this.mSlider != null) {
                    int wid = 2 * ViewUtil.ICON_RIGHT_ENABLED.getIconWidth();
                    wid += MViewDetailProject.this.mSlider.length * ICON_SLIDER.getIconWidth();
                    offset = (720 - (wid += (MViewDetailProject.this.mSlider.length + 1) * 6)) / 2;
                }
                super.setBounds(pX + offset, pY, pWidth, pHeight);
            }
        };
        left.addAction(pEvent -> this.displayImg(this.mCurImg - 1));
        this.mSlider = new MButton[this.mProject.getImgURLs().length];
        for (int i = 0; i < this.mSlider.length; ++i) {
            int finalI = i;
            MPos pos = MPos.pos("[]<6>p<6>,||<>p<>", i == 0 ? left : this.mSlider[i - 1]);
            this.mSlider[i] = new MButton((MMPos)pos, (Icon)ICON_SLIDER).addAction(pEvent -> this.displayImg(finalI));
            this.mSlider[i].setRolloverIcon(ICON_SLIDER_BACKGROUND);
            this.mSlider[i].setEnabled(false);
        }
        MButton right = new MButton(MPos.pos("[]<6>p,||p", this.mSlider[this.mSlider.length - 1]), ViewUtil.ICON_RIGHT_ENABLED, ViewUtil.ICON_RIGHT_ROLLOVER, ViewUtil.ICON_RIGHT_PRESSED).addAction(pEvent -> this.displayImg(this.mCurImg + 1));
        this.loadImages(this.mProject.getImgURLs());
        if (this.mImages.size() == 1) {
            left.setDisabledIcon(ViewUtil.ICON_LEFT_DISABLED);
            right.setDisabledIcon(ViewUtil.ICON_RIGHT_DISABLED);
            left.setEnabled(false);
            right.setEnabled(false);
        }
        return left;
    }

    @NotNull
    private IComp footerProject(@NotNull IComp pLast, int pWidth) {
        IStructure str = this.mProject.getStructures().get(0);
        MText tBlocks = new MText(MPos.pos("[[<>" + pWidth + ",[]<25>p", pLast)).title("blks");
        MText tWidth = new MText(MPos.pos("[[<>" + pWidth + ",[]<8>p", tBlocks)).title("wid");
        MText tHeight = new MText(MPos.pos("[[<>" + pWidth + ",[]<8>p", tWidth)).title("hig");
        MText tLength = new MText(MPos.pos("[[<>" + pWidth + ",[]<8>p<30>", tHeight)).title("len");
        ViewUtil.addInfo(tBlocks, str.getBlocks());
        IDim dim = str.getDim();
        ViewUtil.addInfo(tWidth, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getX())));
        ViewUtil.addInfo(tHeight, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getY())));
        ViewUtil.addInfo(tLength, MLangManager.rep("te.mBlk", CommonUtil.decMark(dim.getZ())));
        return tLength;
    }

    @NotNull
    private IComp footerCollection(@NotNull IComp pLast) {
        int j;
        MFlowPanel panelTitle = new MFlowPanel(MPos.pos("V[[<>m<>,[]45", pLast), 61, MCon.colorFrame());
        new MTitle(MPos.pos(panelTitle, "[[m,]]<>p<>")).title("strs");
        int strSize = this.mProject.getStructures().size();
        String[] names = new String[strSize];
        String[] blocks = new String[strSize];
        String[] strs = new String[strSize];
        String[] dimArr = new String[strSize];
        int i = 0;
        for (IStructure str : this.mProject.getStructures()) {
            names[i] = str.getName();
            blocks[i] = MLangManager.rep("te.blk", CommonUtil.decMark(str.getBlocks()));
            strs[i] = SharedUtil.lang("i.str", str.getName());
            IDim dim = str.getDim();
            dimArr[i] = MLangManager.rep("te.dim", CommonUtil.decMark(dim.getX()), CommonUtil.decMark(dim.getY()), CommonUtil.decMark(dim.getZ()));
            ++i;
        }
        int x = 0;
        Font fontStr = MSchemeFont.font(MCon.fontText().getSize() + 1, 1);
        for (j = 0; j < strSize; ++j) {
            x = Math.max(x, Math.max(Util.getWidth(blocks[j], strs[j]), Util.getWidth(fontStr, dimArr[j])) + 55);
        }
        for (j = 0; j < strSize; ++j) {
            MPos pos = j == 0 ? MPos.pos("V||<30>M850<30>,[]<75>105", pLast) : MPos.pos("V||<30>M850<30>,[]105<30>", pLast);
            MPanel panel = new MPanel(pos, ResSearch.COLOR_BACKGROUND);
            pLast = panel;
            MText tTitle = new MText(MPos.pos(panel, "[[p,[[<16>p")).text(strs[j]);
            MText tBlocks = new MText(MPos.pos("[[<>p,[]<8>p", tTitle)).text(blocks[j]);
            new MText(MPos.pos("[[<>p,[]<8>p<>", tBlocks)).text(dimArr[j]);
            this.buttonPlaceStructure(MPos.pos(panel, "]]p,||p"), names[j]);
        }
        return pLast;
    }

    private void displayImg(int pNewId) {
        if (pNewId < 0) {
            pNewId += this.mImages.size();
        } else if (pNewId >= this.mImages.size()) {
            pNewId -= this.mImages.size();
        }
        if (pNewId == this.mCurImg) {
            return;
        }
        this.mSlider[this.mCurImg].setIcon(ICON_SLIDER);
        this.mSlider[this.mCurImg].setRolloverIcon(ICON_SLIDER_BACKGROUND);
        this.mCurImg = pNewId;
        this.mSlider[this.mCurImg].setIcon(ICON_SLIDER_SELECTED);
        this.mSlider[this.mCurImg].setRolloverIcon(ICON_SLIDER_BACKGROUND_SELECTED);
        MTuple<String, ImageIcon> tuple = this.mImages.get(pNewId);
        this.mImg.setIcon(tuple == null ? ICON_LOADING : (Icon)tuple.getB());
        if (this.mImgTitle != null) {
            this.mImgTitle.text(tuple == null ? "" : tuple.getA());
        }
    }

    private void loadImages(@NotNull String[] pContent) {
        this.mImages = new ConcurrentHashMap(pContent.length);
        int thrQuan = Math.min(6, pContent.length);
        new AssemblyThread(pI -> {
            Optional<BufferedImage> img = SharedUtil.loadImg("https://static.planetminecraft.com/files/resource_media/screenshot/" + pContent[pI]);
            if (img.isPresent()) {
                ImageIcon icon = ImgUtil.makePropScaled(ImgUtil.getImg(img.get()), 720, 405);
                MTuple<String, ImageIcon> tuple = new MTuple<String, ImageIcon>(pContent[pI], icon);
                this.mThumbURLS.add(tuple);
                if (this.mImages != null) {
                    this.mImages.put(pI, tuple);
                }
                if (pI == this.mCurImg) {
                    this.mImg.setIcon(icon);
                }
            } else if (this.mImages != null) {
                this.mImages.put(pI, new MTuple<String, ImageIcon>(pContent[pI], ICON_LOADING));
            }
            if (this.mSlider != null) {
                this.mSlider[pI].setEnabled(true);
                this.mSlider[pI].setRolloverIcon(pI == 0 ? ICON_SLIDER_BACKGROUND_SELECTED : ICON_SLIDER_BACKGROUND);
            }
        }, pContent.length, "loadImages", thrQuan).start();
    }

    @NotNull
    private MButton buttonPlaceStructure(@NotNull MPos pPos) {
        if (this.mProject.isCollection()) {
            throw new IllegalArgumentException("expected project");
        }
        MButton button = new MButton(pPos, SharedUtil.ICON_PLACE, SharedUtil.ICON_PLACE_HOVER, SharedUtil.ICON_PLACE_PRESSED);
        String tip = ISMContainer.getStorageManager().isProjectAdded(this.mProject) ? "" : "Add";
        button.addAction(pEvent -> StorageManagerWrapper.displayPlaceStructure(pEvent, this.mProject)).tip(new MTip(MLangManager.get("tip.place" + tip)));
        ViewUtil.roundButtonLabel(button, "plcStrRound", ViewUtil.LabelAlign.BOTTOM);
        return button;
    }

    private void buttonPlaceStructure(@NotNull MPos pPos, @NotNull String pStr) {
        if (!this.mProject.isCollection()) {
            throw new IllegalArgumentException("expected collection");
        }
        MButton button = new MButton(pPos, SharedUtil.ICON_PLACE, SharedUtil.ICON_PLACE_HOVER, SharedUtil.ICON_PLACE_PRESSED);
        String tip = ISMContainer.getStorageManager().isProjectAdded(this.mProject) ? "" : "Add";
        button.addAction(pEvent -> StorageManagerWrapper.displayPlaceStructure(pEvent, (ICollection)this.mProject, pStr)).tip(new MTip(MLangManager.get("tip.place" + tip)));
        ViewUtil.roundButtonLabel(button, "plcStrRound", ViewUtil.LabelAlign.LEFT);
    }

    @NotNull
    private MButton buttonAdd(@NotNull MPos pPos) {
        MButton button = new MButton((MMPos)pPos, (Icon)ICON_ADD);
        button.addAction(pEvent -> StorageManagerWrapper.toggleProject(pEvent, this.mProject));
        button.setRolloverIcon(ICON_ADD_HOVER);
        MText tLabel = ViewUtil.roundButtonLabel(button, null, ViewUtil.LabelAlign.BOTTOM);
        String tip = this.mProject.isCollection() ? "Col" : "Proj";
        MTip tipAdd = new MTip(MLangManager.get("tip.add" + tip));
        MTip tipRem = new MTip(MLangManager.get("tip.rem" + tip));
        this.mObserverAdded = pStorable -> {
            button.setIcon(ICON_ADD_PRESSED);
            button.setPressedIcon(ICON_ADD);
            button.tip(tipRem);
            tLabel.title("remStr");
        };
        this.mObserverRemoved = pStorable -> {
            button.setIcon(ICON_ADD);
            button.setPressedIcon(ICON_ADD_PRESSED);
            button.tip(tipAdd);
            tLabel.title("addStr");
        };
        if (ISMContainer.getStorageManager().isProjectAdded(this.mProject)) {
            button.setIcon(ICON_ADD_PRESSED);
            button.setPressedIcon(ICON_ADD);
            button.tip(tipRem);
            tLabel.title("remStr");
        } else {
            button.setIcon(ICON_ADD);
            button.setPressedIcon(ICON_ADD_PRESSED);
            button.tip(tipAdd);
            tLabel.title("addStr");
        }
        ISMContainer.getStorageManager().registerObserver(EStorageObserverType.PROJECT_COLLECTION_ADDED, this.mObserverAdded);
        ISMContainer.getStorageManager().registerObserver(EStorageObserverType.PROJECT_COLLECTION_REMOVED, this.mObserverRemoved);
        return button;
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        return EURI.PRE_BROWSE.toString() + (Object)((Object)EURI.VIEW) + (this.mProject.isCollection() ? "collection/" : "project/" + this.mProject.getURL());
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_DETAIL_PROJECT;
    }

    @Override
    public int getMenuButton() {
        return 0;
    }

    public void setProject(IProject pProject) {
        this.mProject = pProject;
    }

    static {
        ICON_LOADING = ImgUtil.makePropScaled(ImgUtil.getAppIcon("empty_thumbnail_240x135"), 720, 405);
        ICON_ADD = ImgUtil.getAppIcon("add");
        ICON_ADD_HOVER = ImgUtil.getAppIcon("add_hover");
        ICON_ADD_PRESSED = ImgUtil.getAppIcon("add_pressed");
        Optional<BufferedImage> circle = ImgUtil.getAppBuffered("slider_button");
        if (!circle.isPresent()) {
            throw new NullPointerException();
        }
        ICON_SLIDER = ImgUtil.getImg(ImgUtil.makeColorChanged(circle.get(), ViewUtil.COLOR_ARROW_ENABLED));
        ICON_SLIDER_SELECTED = ImgUtil.getImg(ImgUtil.makeColorChanged(circle.get(), MCon.colorAccent()));
        Optional<BufferedImage> circleLarge = ImgUtil.getAppBuffered("slider_button_background");
        if (!circleLarge.isPresent()) {
            throw new NullPointerException();
        }
        ICON_SLIDER_BACKGROUND = ImgUtil.getImg(ImgUtil.makeColorChanged(circleLarge.get(), ViewUtil.COLOR_ARROW_ENABLED));
        ICON_SLIDER_BACKGROUND_SELECTED = ImgUtil.getImg(ImgUtil.makeColorChanged(circleLarge.get(), MCon.colorAccent()));
    }
}

