/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.database.MData;
import de.maggicraft.ism.favorites.EFavoriteObservedOperation;
import de.maggicraft.ism.favorites.IFavorite;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.results.ViewRes;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.MEditor;
import de.maggicraft.mgui.comp.MPicture;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.pos.MPicPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mioutil.compr.Compressed;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MViewFavorites
extends MISMView<Integer> {
    @Override
    public void initialize() {
        ISMContainer.getFavoritesManager().registerObserver(EFavoriteObservedOperation.FAVORITE_REMOVED, pFavorite -> {
            if (ISMContainer.getViewManager().isCurrent(EView.VIEW_FAVORITES)) {
                ISMContainer.getViewManager().displayLeftMenu(EView.VIEW_FAVORITES);
            }
        });
    }

    @Override
    protected void displayState(Integer pMode) {
        Collection<IFavorite> favorites = ISMContainer.getFavoritesManager().getFavorites();
        if (favorites.size() == 0) {
            ViewUtil.header(this, MLangManager.get("te.favProjects"));
            MTitle tHint = new MTitle(MPos.pos(this, "[[<30>m<30>,[[<76>p")).title("hintFavs");
            MEditor edText = new MEditor(MPos.pos("[[m<45>,[]p", tHint)).title("hintFavs");
            edText.setFont(MCon.fontText());
            MPicture last = new MPicture(MPicPos.pos("[[p,[]p<45>", tHint, edText), ImgUtil.getAppIcon("add_favs"));
            this.setDim(last, 500);
        } else {
            ViewRes viewRes = ViewUtil.initStrView(this, "favProjects", 370);
            ViewUtil.initFilter(this, viewRes);
            Compressed res = new Compressed(favorites.size(), Integer.toBinaryString(MData.projectQuantity()).length());
            int i = 0;
            for (IFavorite favorite : favorites) {
                res.set(i, favorite.getPID());
                ++i;
            }
            viewRes.init(res, null);
        }
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        return "favorites/" + (Object)((Object)EURI.LIST);
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_FAVORITES;
    }

    @Override
    public int getMenuButton() {
        return 2;
    }
}

