/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.gui.CSharedCon;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.MTrackableDialog;
import de.maggicraft.ism.gui.MTrackableDialogs;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.results.ViewLocal;
import de.maggicraft.ism.storage.StorageException;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MFileChooser;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.IDataDrop;
import de.maggicraft.mgui.util.ImgUtil;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.MDialog;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mgui.view.MScroll;
import de.maggicraft.mgui.view.util.EWindowSize;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MViewLocals
extends MISMView<Integer> {
    private ViewLocal mViewLocal;

    private static void showDialogNotAdded(final @NotNull List<String> pAdded) {
        new MTrackableDialog((Frame)ISMContainer.getStrExplorer().getFrame(), EWindowSize.THREE){

            @Override
            public void init(@NotNull MDialog pView) {
                MScroll scroll = MScroll.single(MPos.pos(pView, "[[<>m<>,[[<>m<60>"));
                MText tInfo = new MText(MPos.pos(scroll, "||m,[[p")).text(MViewLocals.getListText(pAdded));
                scroll.getCurView().setDim(tInfo, EWindowSize.THREE.getDimX() - 2 * MCon.defaultGap());
                new MButton(MPos.pos(pView, "]]p,]]s")).addAction(pEvent -> pView.dispose()).defButton().title("ok");
            }

            @Override
            public void afterInit() {
                SwingUtilities.invokeLater(this::afterDisplay);
            }

            @Override
            @NotNull
            protected String getURI() {
                return EURI.PRE_LIBRARY.toString() + (Object)((Object)EURI.LIST) + "local-structures/" + (Object)((Object)EURI.DIALOG) + "not-added/";
            }
        }.title("note").visible();
    }

    private static String getListText(@NotNull List<String> pAdded) {
        StringBuilder sb = new StringBuilder();
        sb.append(MLangManager.get(pAdded.size() == 1 ? "te.locAdded1" : "te.locsAdded1")).append(CCon.LINE_SEP);
        for (String name : pAdded) {
            sb.append("    \"").append(name).append('\"').append(CCon.LINE_SEP);
        }
        sb.append(MLangManager.get(pAdded.size() == 1 ? "te.locAdded2" : "te.locsAdded2"));
        return sb.toString();
    }

    @Override
    public void initialize() {
        MFlowPanel header = new MFlowPanel((MMPos)MPos.pos(this, "[[<>m<>,[[<>61"), MCon.colorFrame());
        MButton bTut = new MButton(MPos.pos(header, "]]p<30>,]]s<>")).addAction(pEvent -> {
            String uri = EURI.PRE_LIBRARY.toString() + (Object)((Object)EURI.LIST) + "local-structures/" + (Object)((Object)EURI.DIALOG) + "info/";
            MTrackableDialogs.makeNote(ISMContainer.getStrExplorer().getFrame(), MLangManager.get("te.localInfo"), uri).visible();
        }).title("info");
        new MTitle(MPos.pos("H][m,]]p<>", bTut)).title("addLocStr");
        this.dropArea();
    }

    private void dropArea() {
        MPanel panel = new MPanel(MPos.pos(this, "[[<>m<>,[[<61>259"), MCon.colorFrame());
        Optional<BufferedImage> img = ImgUtil.getAppBuffered("add_local");
        if (!img.isPresent()) {
            throw new NullPointerException();
        }
        ImageIcon icon = ImgUtil.getImg(ImgUtil.makeColorChanged(img.get(), MCon.colorText()));
        ActionListener listener = this.getListener();
        MButton picAdd = new MButton((MMPos)MPos.pos(panel, "||p,[[p"), (Icon)icon).addAction(listener);
        picAdd.setCursor(CSharedCon.CURSOR_HAND);
        MText tInfo = new MText(MPos.pos("||p,[]p", picAdd)).title("dropFiles");
        MButton bAdd = new MButton(MPos.pos("V[[<30>p,[]30", tInfo)).addAction(listener).title("addStrs");
        IDataDrop dataDrop = this::addFiles;
        Util.addDataDrop(panel, dataDrop);
        Util.addDataDrop(picAdd, dataDrop);
        Util.addDataDrop(tInfo, dataDrop);
        Util.addDataDrop(bAdd, dataDrop);
    }

    private void addFiles(List<File> pFiles) {
        boolean added = false;
        LinkedList<String> notAdded = new LinkedList<String>();
        for (File file : pFiles) {
            try {
                ISMContainer.getLocalManager().addLocal(file);
                added = true;
            }
            catch (StorageException pE) {
                notAdded.add(file.getName());
                ISMContainer.getLogger().log(pE);
            }
        }
        if (added) {
            ISMContainer.getLocalManager().store();
            this.loadLoc();
        }
        if (!notAdded.isEmpty()) {
            MViewLocals.showDialogNotAdded(notAdded);
        }
    }

    @NotNull
    private ActionListener getListener() {
        return pEvent -> SwingUtilities.invokeLater(() -> {
            File path = MCon.appFolder().getParentFile().getParentFile();
            MFileChooser chooser = new MFileChooser(path).title("addStrs");
            chooser.setMultiSelectionEnabled(true);
            int returnValue = chooser.showOpenDialog(null);
            if (returnValue == 0) {
                this.addFiles(Arrays.asList(chooser.getSelectedFiles()));
            }
        });
    }

    @Override
    protected void displayState(Integer pMode) {
        MFlowPanel header = new MFlowPanel((MMPos)LPos.pos(this, "[[<>m<>,[[<320>61", 1), MCon.colorFrame());
        MText title = new MText(MPos.pos(header, "[[<30>p,]]<>p<5>")).title("locStr");
        title.setForeground(MCon.colorTitleText());
        title.setFont(MCon.fontTitle());
        new MPanel(MPos.pos(header, "[[m,]]1<>"), MCon.colorTitleLine());
        this.mViewLocal = new ViewLocal(MPos.pos(this, "||<>m<>,[[<426>p"), ViewManager.getScroll()){

            @Override
            public void actPrefDim(int pWidth, int pHeight) {
                MViewLocals.this.setDim(pWidth, pHeight + 485);
            }

            @Override
            public int getSort() {
                return 0;
            }
        };
        this.mViewLocal.buttonsResType(MPos.pos(header, "]]p<30>,]]p<5>"));
        this.mViewLocal.buttonsPage(MPos.pos(this, "||p,]]p<25>"));
        MFlowPanel panelFilter = new MFlowPanel(LPos.pos(this, "[[<>m<>,[[<381>60", 1), 61, MCon.colorFrame());
        ViewUtil.initFilter(this, 440, MPos.pos(panelFilter, "||<30>M850<30>,||<>30<>"), this.mViewLocal);
        this.mViewLocal.displayResPage();
    }

    public void loadLoc() {
        this.update();
        this.mViewLocal.displayResPage();
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        return EURI.PRE_LIBRARY.toString() + (Object)((Object)EURI.LIST) + "local-structures/";
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_LOCAL_STRUCTURES;
    }

    @Override
    public int getMenuButton() {
        return 14;
    }

    @Override
    @NotNull
    public EFeature getFeature() {
        return EFeature.LOCAL_STRUCTURES;
    }
}

