/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.views;

import de.maggicraft.ism.analytics.server.TrackShape;
import de.maggicraft.ism.analytics.util.EURI;
import de.maggicraft.ism.analytics.util.EUTMView;
import de.maggicraft.ism.config.EFeature;
import de.maggicraft.ism.gui.EView;
import de.maggicraft.ism.gui.MMenuHorizontal;
import de.maggicraft.ism.gui.ViewManager;
import de.maggicraft.ism.loader.ISMContainer;
import de.maggicraft.ism.views.IViewPos;
import de.maggicraft.ism.views.MISMView;
import de.maggicraft.ism.views.ViewUtil;
import de.maggicraft.ism.world.util.IPos;
import de.maggicraft.mcommons.filter.types.MFilters;
import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.MButton;
import de.maggicraft.mgui.comp.MCombo;
import de.maggicraft.mgui.comp.MField;
import de.maggicraft.mgui.comp.MSwitcher;
import de.maggicraft.mgui.comp.MText;
import de.maggicraft.mgui.comp.MTitle;
import de.maggicraft.mgui.filter.check.MChecker;
import de.maggicraft.mgui.pos.LPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.view.MFlowPanel;
import de.maggicraft.mgui.view.MPanel;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MViewPlaceShape
extends MISMView<Integer>
implements IViewPos {
    public static final String[] TITLES = new String[]{"cub", "circ", "cyl", "ov", "cone", "sph", "pyr", "rep"};
    private static final String[] URIS = new String[]{"cuboid/", "circle/", "cylinder/", "oval/", "cone/", "sphere/", "pyramid/", "replace/"};
    private static final int VIEW_INDEPENDENT = -2;
    @Nullable
    private IPos mPos;
    private MMenuHorizontal mMenu;
    private MCombo mComboBlocks;
    private MCombo mComboDirs;
    private MField mFieldMeta;
    private MField mFieldPosX;
    private MField mFieldPosY;
    private MField mFieldPosZ;
    private MChecker mChecker;
    private MPanel mPanelShape;
    private IComp mTop;
    private int mDir;
    private int mMode = 0;
    private boolean mPlaced;

    private static MSwitcher switcher(@NotNull MPos pPos, @NotNull String pTitle) {
        return MViewPlaceShape.switcher(pPos, pTitle, false);
    }

    private static MSwitcher switcher(@NotNull MPos pPos, @NotNull String pTitle, boolean pSelected) {
        MSwitcher switcher = new MSwitcher(pPos, pSelected).tips(pTitle, new MTip(), new MTip());
        new MText(MPos.pos("V[[<>p,||<>p<>", switcher)).title(pTitle);
        return switcher;
    }

    private MField fieldText(@NotNull MPos pPos, @NotNull String pTitle) {
        MField field = this.field(pPos, pTitle);
        new MText(MPos.pos("V[[<>p,||<>p<>", field)).title(pTitle);
        return field;
    }

    private MField field(@NotNull MPos pPos, String pTitle) {
        String tipText = MLangManager.get("f.tt.enter") + MLangManager.get("te." + pTitle).replace(":", "");
        MField field = new MField(pPos).text("0").tip(new MTip(tipText));
        this.mChecker.add(MFilters.filterInt(1, 1000), field);
        return field;
    }

    private void shapesInfo() {
        int blockId = ISMContainer.getShapesTables().getBlockIdByIndex(this.mComboBlocks.getSelectedIndex());
        ISMContainer.getPlaceShapes().setInfo(blockId, this.mFieldMeta.getInt(), this.mComboDirs.getSelectedIndex(), this.mFieldPosX.getInt(), this.mFieldPosY.getInt(), this.mFieldPosZ.getInt());
    }

    @Override
    public void setPos(@NotNull IPos pPos, int pDir) {
        this.mPos = pPos;
        this.mDir = pDir;
        if (this.mComboDirs != null) {
            this.mComboDirs.setSelectedIndex(this.mDir);
            this.mFieldPosX.text(Integer.toString(pPos.getX()));
            this.mFieldPosY.text(Integer.toString(pPos.getY()));
            this.mFieldPosZ.text(Integer.toString(pPos.getZ()));
        }
    }

    @Override
    public void initialize() {
        ViewUtil.titleTutorial(this, "plcShp", EUTMView.VIEW_PLACE_SHAPE);
        MFlowPanel headerMat = new MFlowPanel(LPos.pos(this, "[[<>m<>,[[<61>45", 1), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerMat, "[[m,]]<>p<>")).title("mat").setFont(MCon.fontText());
        this.mComboBlocks = new MCombo(MPos.pos(this, "[[<30>p,[[<120>s")).text(ISMContainer.getShapesTables().getBlockNames());
        MField fSearch = new MField(MPos.pos("[]100,||30", this.mComboBlocks)).title("srchFld");
        this.mComboBlocks.addSearchBar(fSearch, true);
        MText tMeta = new MText(MPos.pos("[]<25>p,||p", fSearch)).title("meta");
        this.mFieldMeta = new MField(MPos.pos("[]p,||s", tMeta, fSearch)).text("0");
        MFlowPanel headerPos = new MFlowPanel(LPos.pos("V[[<>m<>,[]<25>45", (IComp)this.mComboBlocks, 2), 61, MCon.colorFrame());
        new MTitle(MPos.pos(headerPos, "[[m,]]<>p<>")).title("pos").setFont(MCon.fontText());
        MPanel panel = new MPanel(MPos.pos("[[<>M300,[]<85>165", this.mComboBlocks), MCon.colorFrame());
        String[] dirs = new String[]{MLangManager.get("sth"), MLangManager.get("wst"), MLangManager.get("nrth"), MLangManager.get("st")};
        this.mComboDirs = new MCombo(MPos.pos(panel, "]]<>120<>,[[<>30")).text(dirs);
        this.mComboDirs.setSelectedIndex(this.mDir);
        this.mPos = ViewUtil.checkPos(this.mPos);
        this.mFieldPosX = new MField(MPos.pos("V]]<>120<>,[]30", this.mComboDirs)).text(Integer.toString(this.mPos.getX()));
        this.mFieldPosY = new MField(MPos.pos("V]]<>120<>,[]30", this.mFieldPosX)).text(Integer.toString(this.mPos.getY()));
        this.mFieldPosZ = new MField(MPos.pos("V]]<>120<>,[]30<>", this.mFieldPosY)).text(Integer.toString(this.mPos.getZ()));
        new MText(MPos.pos("V[[<>p,||<>p", this.mComboDirs)).title("dir");
        new MText(MPos.pos("V[[<>p,||p", this.mFieldPosX)).title("pX");
        new MText(MPos.pos("V[[<>p,||p", this.mFieldPosY)).title("pY");
        new MText(MPos.pos("V[[<>p,||p<>", this.mFieldPosZ)).title("pZ");
        MText tShape = new MText(MPos.pos("V[[<30>p,[]<25>p", panel)).title("shape");
        tShape.setForeground(MCon.colorTitleText());
        tShape.setFont(MCon.fontText());
        this.mTop = tShape;
        ActionListener[] listeners = new ActionListener[TITLES.length];
        for (int i = 0; i < listeners.length; ++i) {
            int finalI = i;
            listeners[i] = pEvent -> ViewManager.displayLeftMenu(this, finalI);
        }
        this.mMenu = new MMenuHorizontal(LPos.pos("V[[m,[[<30>p<100>", (IComp)tShape, 3), listeners, TITLES){

            @Override
            public void setBounds(int pX, int pY, int pWidth, int pHeight) {
                pY = ViewManager.getScroll().attachHeader(72, pY);
                super.setBounds(pX, pY, pWidth, pHeight);
            }
        };
    }

    @Override
    protected void displayState(Integer pMode) {
        if (!ISMContainer.getUpdateManager().isLegal()) {
            return;
        }
        if (pMode != -1 && pMode != -2) {
            this.mMode = pMode;
        }
        this.mPlaced = false;
        int width = Math.max(600, this.mMenu.prefWidth() + 3 * MCon.defaultGap());
        if (pMode == -2) {
            MPanel panel = new MPanel(MPos.pos("V||<>m<>,[]<45>m<><60>", this.mTop), MCon.colorFrame());
            MText text = new MText(MPos.pos(panel, "||p,||p")).title("placedShape");
            new MButton(MPos.pos("||p,[]30", text)).addAction(pEvent -> ViewManager.displayLeftMenu(this, 0)).title("placeNew");
            this.setDim(this.mMenu, width);
            this.mPlaced = true;
        } else if (ISMContainer.getWorldInfoManager().isLoggedOut()) {
            MPanel panel = new MPanel(MPos.pos("V||<>m<>,[]<45>m<><60>", this.mTop), MCon.colorFrame());
            new MText(MPos.pos(panel, "||p,||p")).title("loadShape");
            this.setDim(this.mMenu, width);
        } else {
            ActionListener listener;
            this.mChecker = new MChecker();
            this.mChecker.add(MFilters.filterInt(0, 255), true, this.mFieldPosY);
            this.mChecker.add(ViewUtil.WORLD_SIZE, true, this.mFieldPosX, this.mFieldPosZ);
            this.mChecker.add(MFilters.filterInt(pMode == 7 ? -1 : 0, 15), true, this.mFieldMeta);
            if (this.mMode == 0) {
                listener = this.displayCuboid();
            } else if (this.mMode == 1) {
                listener = this.displayCircle();
            } else if (this.mMode == 2) {
                listener = this.displayCylinder();
            } else if (this.mMode == 3) {
                listener = this.displayOval();
            } else if (this.mMode == 4) {
                listener = this.displayCone();
            } else if (this.mMode == 5) {
                listener = this.displaySphere();
            } else if (this.mMode == 6) {
                listener = this.displayPyramide();
            } else if (this.mMode == 7) {
                listener = this.displayReplace();
            } else {
                throw new IllegalArgumentException();
            }
            this.mMenu.setActivated(this.mMode);
            new MButton(MPos.pos(this, "[[p,]]30")).addAction(listener).text("place");
            this.setDim(this.mPanelShape, width);
        }
    }

    private ActionListener displayCuboid() {
        this.mPanelShape = new MPanel(MPos.pos("[[<>M300,[]<60>160<60>", this.mTop), MCon.colorFrame());
        MField fWidth = this.fieldText(MPos.pos(this.mPanelShape, "]]120<>,[[<>s"), "cubWid");
        MField fHeight = this.fieldText(MPos.pos("V]]120<>,[]s", fWidth), "cubHgt");
        MField fDepth = this.fieldText(MPos.pos("V]]120<>,[]s", fHeight), "cubDpt");
        MSwitcher swHollow = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]s<>", fDepth), "cubHollowed");
        new MText(MPos.pos("V[[<>p,||<>p", fWidth)).title("cubWid");
        new MText(MPos.pos("V[[<>p,||p", fHeight)).title("cubHgt");
        new MText(MPos.pos("V[[<>p,||p", fDepth)).title("cubDpt");
        new MText(MPos.pos("V[[<>p,||p<>", swHollow)).title("cubHollowed");
        return pEvent -> {
            if (!this.mChecker.check()) {
                return;
            }
            this.shapesInfo();
            long time = System.currentTimeMillis();
            int width = fWidth.getInt();
            int height = fHeight.getInt();
            int depth = fDepth.getInt();
            boolean isHollow = swHollow.isSelected();
            int blocks = ISMContainer.getPlaceShapes().cuboid(width, height, depth, isHollow);
            time = System.currentTimeMillis() - time;
            ViewManager.displayLeftMenu(this, -2);
            String dim = "w: " + width + ", h: " + height + ", d: " + depth + '_' + (isHollow ? "isH" : "isF");
            TrackShape.trackShape("Cuboid", ISMContainer.getPlaceShapes().getBlockName(), ISMContainer.getPlaceShapes().getMeta(), blocks, time, dim);
        };
    }

    private ActionListener displayCircle() {
        this.mPanelShape = new MPanel(MPos.pos("[[<>M300,[]<60>160<60>", this.mTop), MCon.colorFrame());
        MField fDia = this.fieldText(MPos.pos(this.mPanelShape, "]]120<>,[[<>30"), "circDia");
        MSwitcher swTilted = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30", fDia), "circTilted");
        MSwitcher swCenter = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30", swTilted), "circCentered", true);
        MSwitcher swHollow = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30<>", swCenter), "circHollowed");
        return pEvent -> {
            if (!this.mChecker.check()) {
                return;
            }
            this.shapesInfo();
            long time = System.currentTimeMillis();
            int dia = fDia.getInt();
            boolean isHollow = swHollow.isSelected();
            boolean isCentered = swCenter.isSelected();
            boolean isTilted = swTilted.isSelected();
            int blocks = ISMContainer.getPlaceShapes().circle(dia, dia, isHollow, isCentered, isTilted);
            time = System.currentTimeMillis() - time;
            ViewManager.displayLeftMenu(this, -2);
            String dim = "dia: " + dia + '_' + (isHollow ? "isH_" : "nH_") + (isCentered ? "isC_" : "nC_") + (isTilted ? "isT" : "nT");
            TrackShape.trackShape("Circle", ISMContainer.getPlaceShapes().getBlockName(), ISMContainer.getPlaceShapes().getMeta(), blocks, time, dim);
        };
    }

    private ActionListener displayCylinder() {
        this.mPanelShape = new MPanel(MPos.pos("[[<>M300,[]<60>205<60>", this.mTop), MCon.colorFrame());
        MField fWidth = this.fieldText(MPos.pos(this.mPanelShape, "]]120<>,[[<>30"), "cylWid");
        MField fHeight = this.fieldText(MPos.pos("V]]120<>,[]30", fWidth), "cylHgt");
        MSwitcher swTilted = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30", fHeight), "cylTilted");
        MSwitcher swCenter = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30", swTilted), "cylCentered", true);
        MSwitcher swHollow = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30<>", swCenter), "cylHollowed");
        swTilted.addItemListener(evt -> fHeight.tip(new MTip("f.tt.cyl" + (swTilted.isSelected() ? "Depth" : "Hgt"))));
        return pEvent -> {
            if (!this.mChecker.check()) {
                return;
            }
            this.shapesInfo();
            long time = System.currentTimeMillis();
            int width = fWidth.getInt();
            int height = fHeight.getInt();
            boolean isHollow = swHollow.isSelected();
            boolean isCentered = swCenter.isSelected();
            boolean isTilted = swTilted.isSelected();
            int blocks = ISMContainer.getPlaceShapes().cylinder(width, height, isHollow, !isTilted, isCentered);
            time = System.currentTimeMillis() - time;
            ViewManager.displayLeftMenu(this, -2);
            String dim = "w: " + width + ", h: " + height + '_' + (isHollow ? "isH_" : "nH_") + (isCentered ? "isC_" : "nC_") + (isTilted ? "isT" : "nT");
            TrackShape.trackShape("Cylinder", ISMContainer.getPlaceShapes().getBlockName(), ISMContainer.getPlaceShapes().getMeta(), blocks, time, dim);
        };
    }

    private ActionListener displayOval() {
        this.mPanelShape = new MPanel(MPos.pos("[[<>M300,[]<60>255<60>", this.mTop), MCon.colorFrame());
        MField fWidth = this.fieldText(MPos.pos(this.mPanelShape, "]]120<>,[[<>30"), "ovlWid");
        MField fHeight = this.fieldText(MPos.pos("V]]120<>,[]30", fWidth), "ovlHgt");
        MField fDepth = this.fieldText(MPos.pos("V]]120<>,[]30", fHeight), "ovlDpt");
        MSwitcher swTilted = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30", fDepth), "ovlTilted");
        MSwitcher swCenter = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30", swTilted), "ovlCentered", true);
        MSwitcher swHollow = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30<>", swCenter), "ovlHollowed");
        swTilted.addItemListener(evt -> {
            fDepth.tip(new MTip("f.tt.ovl" + (swTilted.isSelected() ? "Depth" : "Hgt")));
            fHeight.tip(new MTip("f.tt.ovl" + (swTilted.isSelected() ? "Depth" : "Hgt")));
        });
        return pEvent -> {
            if (!this.mChecker.check()) {
                return;
            }
            this.shapesInfo();
            long time = System.currentTimeMillis();
            int width = fWidth.getInt();
            int height = fHeight.getInt();
            int depth = fDepth.getInt();
            boolean isHollow = swHollow.isSelected();
            boolean isCentered = swCenter.isSelected();
            boolean isTilted = swTilted.isSelected();
            int blocks = ISMContainer.getPlaceShapes().oval(width, height, depth, isHollow, isCentered, isTilted);
            time = System.currentTimeMillis() - time;
            ViewManager.displayLeftMenu(this, -2);
            String dim = "w: " + width + ", h:" + height + ", d: " + depth + '_' + (isHollow ? "isH_" : "nH_") + (isCentered ? "isC_" : "nC_") + (isTilted ? "isT" : "nT");
            TrackShape.trackShape("Oval", ISMContainer.getPlaceShapes().getBlockName(), ISMContainer.getPlaceShapes().getMeta(), blocks, time, dim);
        };
    }

    private ActionListener displayCone() {
        this.mPanelShape = new MPanel(MPos.pos("[[<>M300,[]<60>300<60>", this.mTop), MCon.colorFrame());
        MField fWidth = this.fieldText(MPos.pos(this.mPanelShape, "]]120<>,[[<>30"), "conWid");
        MField fHeight = this.fieldText(MPos.pos("V]]120<>,[]30", fWidth), "conHgt");
        MField fDepth = this.fieldText(MPos.pos("V]]120<>,[]30", fHeight), "conDpt");
        MSwitcher swTilted = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30", fDepth), "conTilted");
        MSwitcher swCenter = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30", swTilted), "conCentered", true);
        MSwitcher swHollow = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30<>", swCenter), "conHollowed");
        MSwitcher swTurned = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30<>", swHollow), "conTurned");
        swTurned.addItemListener(e -> {
            if (swTurned.isSelected()) {
                swTilted.setSelected(false);
            }
        });
        return pEvent -> {
            if (!this.mChecker.check()) {
                return;
            }
            this.shapesInfo();
            long time = System.currentTimeMillis();
            int width = fWidth.getInt();
            int height = fHeight.getInt();
            int depth = fDepth.getInt();
            boolean isHollow = swHollow.isSelected();
            boolean isCentered = swCenter.isSelected();
            boolean isTilted = swTilted.isSelected();
            boolean isTurned = swTurned.isSelected();
            int blocks = ISMContainer.getPlaceShapes().cone(width, depth, height, isHollow, isCentered, isTilted, isTurned);
            time = System.currentTimeMillis() - time;
            ViewManager.displayLeftMenu(this, -2);
            String dim = "w: " + width + ", d: " + depth + ", h: " + height + '_' + (isHollow ? "isH_" : "nH_") + (isCentered ? "isC_" : "nC_") + (isTilted ? "isT_" : "nT_") + (isTilted ? "isTu" : "nTu");
            TrackShape.trackShape("Cone", ISMContainer.getPlaceShapes().getBlockName(), ISMContainer.getPlaceShapes().getMeta(), blocks, time, dim);
        };
    }

    private ActionListener displaySphere() {
        this.mPanelShape = new MPanel(MPos.pos("[[<>M300,[]<60>120<60>", this.mTop), MCon.colorFrame());
        MField fDia = this.fieldText(MPos.pos(this.mPanelShape, "]]120<>,[[<>30"), "sphDia");
        MSwitcher swCenter = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30", fDia), "sphCentered", true);
        MSwitcher swHollow = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30<>", swCenter), "sphHollowed");
        return pEvent -> {
            if (!this.mChecker.check()) {
                return;
            }
            this.shapesInfo();
            long time = System.currentTimeMillis();
            int dia = fDia.getInt();
            boolean isHollow = swHollow.isSelected();
            boolean isCentered = swCenter.isSelected();
            int blocks = ISMContainer.getPlaceShapes().sphere(dia, isHollow, isCentered);
            time = System.currentTimeMillis() - time;
            ViewManager.displayLeftMenu(this, -2);
            String dim = "dia: " + dia + (isHollow ? "isH_" : "nH_") + (isCentered ? "isC" : "nC");
            TrackShape.trackShape("Sphere", ISMContainer.getPlaceShapes().getBlockName(), ISMContainer.getPlaceShapes().getMeta(), blocks, time, dim);
        };
    }

    private ActionListener displayPyramide() {
        this.mPanelShape = new MPanel(MPos.pos("[[<>M300,[]<60>165<60>", this.mTop), MCon.colorFrame());
        MField fWidth = this.fieldText(MPos.pos(this.mPanelShape, "]]120<>,[[<>30"), "pyrWid");
        MField fDepth = this.fieldText(MPos.pos("V]]120<>,[]30", fWidth), "pyrDpt");
        MSwitcher swCenter = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30", fDepth), "pyrCentered", true);
        MSwitcher swHollow = MViewPlaceShape.switcher(MPos.pos("V]]120<>,[]30<>", swCenter), "pyrHollowed");
        return pEvent -> {
            if (!this.mChecker.check()) {
                return;
            }
            this.shapesInfo();
            int height = fDepth.getInt();
            if (fDepth.getInt() < height) {
                height = fDepth.getInt();
            }
            height = (int)Math.round((double)height / 2.0 + 0.5);
            long time = System.currentTimeMillis();
            int width = fWidth.getInt();
            int depth = fDepth.getInt();
            boolean isHollow = swHollow.isSelected();
            boolean isCentered = swCenter.isSelected();
            int blocks = ISMContainer.getPlaceShapes().pyramid(width, depth, height, isHollow, isCentered);
            time = System.currentTimeMillis() - time;
            ViewManager.displayLeftMenu(this, -2);
            String dim = "w: " + width + ", h:" + height + ", d: " + depth + '_' + (isHollow ? "isH_" : "nH_") + (isCentered ? "isC" : "nC");
            TrackShape.trackShape("Pyramide", ISMContainer.getPlaceShapes().getBlockName(), ISMContainer.getPlaceShapes().getMeta(), blocks, time, dim);
        };
    }

    private ActionListener displayReplace() {
        this.mPanelShape = new MPanel(MPos.pos("[[<>M300,[]<60>210<60>", this.mTop), MCon.colorFrame());
        MField fWidth = this.fieldText(MPos.pos(this.mPanelShape, "]]120<>,[[<>30"), "repWid");
        MField fHeight = this.fieldText(MPos.pos("V]]120<>,[]30", fWidth), "repHgt");
        MField fDepth = this.fieldText(MPos.pos("V]]120<>,[]30", fHeight), "repDpt");
        MField fSearch = new MField(MPos.pos("V]]120<>,[]30<>", fDepth)).text("Search");
        MCombo comboBlocks = new MCombo(MPos.pos("V[[<>p<135>,||30", fSearch)).text(ISMContainer.getShapesTables().getBlockNames());
        comboBlocks.addSearchBar(fSearch, true);
        MField fMeta = this.fieldText(MPos.pos("V]]120<>,[]30<>", fSearch), "repMeta");
        this.mChecker.add(MFilters.filterInt(0, 15), true, this.mFieldMeta);
        return pEvent -> {
            if (!this.mChecker.check()) {
                return;
            }
            this.shapesInfo();
            long time = System.currentTimeMillis();
            int width = fWidth.getInt();
            int height = fHeight.getInt();
            int depth = fDepth.getInt();
            int blockId = ISMContainer.getShapesTables().getBlockIdByIndex(comboBlocks.getSelectedIndex());
            int blocks = ISMContainer.getPlaceShapes().replace(blockId, fMeta.getInt(), width, height, depth);
            time = System.currentTimeMillis() - time;
            ViewManager.displayLeftMenu(this, -2);
            String dim = "w: " + width + ", h:" + height + ", d: " + depth;
            TrackShape.trackShape("Replace", ISMContainer.getPlaceShapes().getBlockName(), ISMContainer.getPlaceShapes().getMeta(), blocks, time, dim);
        };
    }

    @Override
    public void afterDisplay(Integer pMode) {
        SwingUtilities.invokeLater(this::afterDisplay);
    }

    @Override
    @NotNull
    public String getURI() {
        String uri = ISMContainer.getUpdateManager().isLegal() ? (ISMContainer.getWorldInfoManager().isLoggedOut() ? EURI.ATTR_LOGGED_OUT.toString() : (this.mPlaced ? "placed/" + URIS[this.mMode] : URIS[this.mMode])) : EURI.ATTR_ILLEGAL.toString();
        return (Object)((Object)EURI.PRE_WORLD) + "place-shape/" + uri;
    }

    @Override
    @NotNull
    public EView getView() {
        return EView.VIEW_PLACE_SHAPE;
    }

    @Override
    public int getMenuButton() {
        return 9;
    }

    @Override
    @NotNull
    public EFeature getFeature() {
        return EFeature.PLACE_SHAPES;
    }
}

